/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.core.thread;

import com.xxl.job.core.biz.AdminBiz;
import com.xxl.job.core.biz.model.HandleCallbackParam;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.executor.XxlJobExecutor;
import java.util.ArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerCallbackThread {
    private static Logger logger = LoggerFactory.getLogger(TriggerCallbackThread.class);
    private static TriggerCallbackThread instance = new TriggerCallbackThread();
    private LinkedBlockingQueue<HandleCallbackParam> callBackQueue = new LinkedBlockingQueue();
    private Thread triggerCallbackThread;
    private boolean toStop = false;

    public static TriggerCallbackThread getInstance() {
        return instance;
    }

    public void start() {
        this.triggerCallbackThread = new Thread(new Runnable(){

            @Override
            public void run() {
                block4: while (!TriggerCallbackThread.this.toStop) {
                    try {
                        HandleCallbackParam callback = (HandleCallbackParam)TriggerCallbackThread.getInstance().callBackQueue.take();
                        if (callback == null) continue;
                        ArrayList<HandleCallbackParam> callbackParamList = new ArrayList<HandleCallbackParam>();
                        int drainToNum = TriggerCallbackThread.getInstance().callBackQueue.drainTo(callbackParamList);
                        callbackParamList.add(callback);
                        if (XxlJobExecutor.getAdminBizList() == null) {
                            logger.warn(">>>>>>>>>>>> xxl-job callback fail, adminAddresses is null, callbackParamList\uff1a{}", callbackParamList);
                            continue;
                        }
                        for (AdminBiz adminBiz : XxlJobExecutor.getAdminBizList()) {
                            try {
                                ReturnT<String> callbackResult = adminBiz.callback(callbackParamList);
                                if (callbackResult != null && 200 == callbackResult.getCode()) {
                                    callbackResult = ReturnT.SUCCESS;
                                    logger.info(">>>>>>>>>>> xxl-job callback success, callbackParamList:{}, callbackResult:{}", new Object[]{callbackParamList, callbackResult});
                                    continue block4;
                                }
                                logger.info(">>>>>>>>>>> xxl-job callback fail, callbackParamList:{}, callbackResult:{}", new Object[]{callbackParamList, callbackResult});
                            }
                            catch (Exception e) {
                                logger.error(">>>>>>>>>>> xxl-job callback error, callbackParamList\uff1a{}", callbackParamList, (Object)e);
                            }
                        }
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        });
        this.triggerCallbackThread.setDaemon(true);
        this.triggerCallbackThread.start();
    }

    public void toStop() {
        this.toStop = true;
    }

    public static void pushCallBack(HandleCallbackParam callback) {
        TriggerCallbackThread.getInstance().callBackQueue.add(callback);
        logger.debug(">>>>>>>>>>> xxl-job, push callback request, logId:{}", (Object)callback.getLogId());
    }
}

