/*
 * Decompiled with CFR 0.152.
 */
package de.flapdoodle.embed.mongo.config;

import de.flapdoodle.embed.mongo.Command;
import de.flapdoodle.embed.mongo.Paths;
import de.flapdoodle.embed.mongo.config.Defaults;
import de.flapdoodle.embed.process.config.store.DownloadConfig;
import de.flapdoodle.embed.process.config.store.PackageResolver;
import de.flapdoodle.embed.process.extract.TempNaming;
import de.flapdoodle.embed.process.extract.UUIDTempNaming;
import de.flapdoodle.embed.process.io.directories.Directory;
import de.flapdoodle.embed.process.io.directories.PropertyOrPlatformTempDir;
import de.flapdoodle.embed.process.store.ArtifactStore;
import de.flapdoodle.embed.process.store.IArtifactStore;
import de.flapdoodle.embed.process.store.ImmutableArtifactStore;

public class ArtifactStores {
    private ArtifactStores() {
    }

    public static IArtifactStore defaultArtifactStore() {
        return ArtifactStores.artifactStore(Command.MongoD);
    }

    public static IArtifactStore mongoSArtifactStore() {
        return ArtifactStores.artifactStore(Command.MongoS);
    }

    private static IArtifactStore artifactStore(Command command) {
        return ArtifactStores.builder(command).build();
    }

    public static ImmutableArtifactStore.Builder builder(Command command) {
        return ArtifactStores.defaultBuilder().downloadConfig((DownloadConfig)Defaults.downloadConfigDefaults().packageResolver((PackageResolver)new Paths(command)).build());
    }

    public static ImmutableArtifactStore.Builder defaultBuilder() {
        return ArtifactStore.builder().tempDirFactory((Directory)new PropertyOrPlatformTempDir()).executableNaming((TempNaming)new UUIDTempNaming());
    }
}

