/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public class BeanFactoryUtil
implements ApplicationContextAware {
    private static final String pl_version = "1.0";
    private static Log log = LogFactory.getLog(BeanFactoryUtil.class);
    private static volatile ApplicationContext applicationContext;

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        if (applicationContext != null) {
            throw new IllegalStateException("BeanFactoryUtil already holded 'applicationContext' !");
        }
        applicationContext = context;
        log.info((Object)("holded applicationContext,displayName:" + applicationContext.getDisplayName()));
        log.info((Object)"kotel platform version is 1.0");
    }

    public static ApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            throw new IllegalStateException("BeanFactoryUtil not holded 'applicationContext' !");
        }
        return applicationContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initApplicationContext(String ... xmlPath) {
        if (applicationContext != null) return;
        log.info((Object)"test unit begin init 'applicationContext'.");
        Class<BeanFactoryUtil> clazz = BeanFactoryUtil.class;
        synchronized (BeanFactoryUtil.class) {
            if (applicationContext != null) return;
            new ClassPathXmlApplicationContext(xmlPath);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static Object getBean(String beanName) {
        return BeanFactoryUtil.getApplicationContext().getBean(beanName);
    }

    public static <T> T getBean(String beanName, Class<T> requiredType) {
        return (T)BeanFactoryUtil.getApplicationContext().getBean(beanName, requiredType);
    }

    public static boolean containsBean(String beanName) {
        return BeanFactoryUtil.getApplicationContext().containsBean(beanName);
    }
}

