/*
 * Decompiled with CFR 0.152.
 */
package com.kotelmems.platform.enumerable.loader;

import com.kotelmems.platform.enumerable.EnumItem;
import com.kotelmems.platform.enumerable.PlainEnumItem;
import com.kotelmems.platform.enumerable.loader.EnumLoader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DBEnumLoader
implements EnumLoader {
    private static Log log = LogFactory.getLog(DBEnumLoader.class);
    private DataSource dataSource;
    private String tableName;
    private String typeColumnName;
    private String codeColumnName;
    private String nameColumnName;
    private String indexColumnName;

    public String getQuerySql() {
        return new StringBuffer("select ").append(this.typeColumnName).append(",").append(this.codeColumnName).append(",").append(this.nameColumnName).append(",").append(this.indexColumnName).append(" from ").append(this.tableName).append(" order by ").append(this.typeColumnName).append(",").append(this.indexColumnName).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, List<EnumItem>> load() {
        HashMap<String, List<EnumItem>> result = new HashMap<String, List<EnumItem>>();
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            conn = this.dataSource.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(this.getQuerySql());
            log.debug((Object)("loaded " + rs.getMetaData().getColumnCount() + " enum items from db with sql:" + this.getQuerySql()));
            while (rs.next()) {
                List<PlainEnumItem> ets;
                PlainEnumItem item = new PlainEnumItem(rs.getString(1), rs.getString(2), rs.getString(3), rs.getInt(4));
                if (!result.containsKey(item.getType())) {
                    ets = new ArrayList<PlainEnumItem>();
                    ets.add(item);
                    result.put(item.getType(), ets);
                    continue;
                }
                ets = (List)result.get(item.getType());
                ets.add(item);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        finally {
            try {
                rs.close();
                stmt.close();
                conn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        return result;
    }

    public void setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public void setTypeColumnName(String typeColumnName) {
        this.typeColumnName = typeColumnName;
    }

    public void setCodeColumnName(String codeColumnName) {
        this.codeColumnName = codeColumnName;
    }

    public void setNameColumnName(String nameColumnName) {
        this.nameColumnName = nameColumnName;
    }

    public void setIndexColumnName(String indexColumnName) {
        this.indexColumnName = indexColumnName;
    }
}

