/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.WdmServer;
import io.github.bonigarcia.wdm.cache.CacheHandler;
import io.github.bonigarcia.wdm.cache.ResolutionCache;
import io.github.bonigarcia.wdm.config.Architecture;
import io.github.bonigarcia.wdm.config.Config;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.managers.ChromeDriverManager;
import io.github.bonigarcia.wdm.managers.ChromiumDriverManager;
import io.github.bonigarcia.wdm.managers.EdgeDriverManager;
import io.github.bonigarcia.wdm.managers.FirefoxDriverManager;
import io.github.bonigarcia.wdm.managers.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.managers.OperaDriverManager;
import io.github.bonigarcia.wdm.managers.PhantomJsDriverManager;
import io.github.bonigarcia.wdm.managers.SeleniumServerStandaloneManager;
import io.github.bonigarcia.wdm.managers.VoidDriverManager;
import io.github.bonigarcia.wdm.online.BitBucketApi;
import io.github.bonigarcia.wdm.online.Downloader;
import io.github.bonigarcia.wdm.online.GitHubApi;
import io.github.bonigarcia.wdm.online.HttpClient;
import io.github.bonigarcia.wdm.online.S3NamespaceContext;
import io.github.bonigarcia.wdm.online.UrlHandler;
import io.github.bonigarcia.wdm.versions.VersionComparator;
import io.github.bonigarcia.wdm.versions.VersionDetector;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebDriverManager {
    protected static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String SLASH = "/";
    protected static final String LATEST_RELEASE = "LATEST_RELEASE";
    protected static final NamespaceContext S3_NAMESPACE_CONTEXT = new S3NamespaceContext();
    protected static Map<DriverManagerType, WebDriverManager> instanceMap = new EnumMap<DriverManagerType, WebDriverManager>(DriverManagerType.class);
    protected HttpClient httpClient;
    protected Downloader downloader;
    protected String downloadedDriverVersion;
    protected String downloadedDriverPath;
    protected boolean mirrorLog;
    protected boolean forcedArch;
    protected boolean forcedOs;
    protected int retryCount = 0;
    protected Config config = new Config();
    protected ResolutionCache resolutionCache;
    protected CacheHandler cacheHandler;
    protected VersionDetector versionDetector;

    protected abstract List<URL> getDriverUrls() throws IOException;

    protected abstract String getDriverName();

    protected abstract String getDriverVersion();

    protected abstract void setDriverVersion(String var1);

    protected abstract String getBrowserVersion();

    protected abstract void setBrowserVersion(String var1);

    protected abstract void setDriverUrl(URL var1);

    protected abstract URL getDriverUrl();

    protected abstract Optional<URL> getMirrorUrl();

    protected abstract Optional<String> getExportParameter();

    public abstract DriverManagerType getDriverManagerType();

    public static Config globalConfig() {
        Config global = new Config();
        global.setAvoidAutoReset(true);
        for (DriverManagerType type : DriverManagerType.values()) {
            WebDriverManager.getInstance(type).setConfig(global);
        }
        return global;
    }

    public Config config() {
        return this.config;
    }

    public static synchronized WebDriverManager chromedriver() {
        instanceMap.putIfAbsent(DriverManagerType.CHROME, new ChromeDriverManager());
        return instanceMap.get((Object)DriverManagerType.CHROME);
    }

    public static synchronized WebDriverManager chromiumdriver() {
        instanceMap.putIfAbsent(DriverManagerType.CHROMIUM, new ChromiumDriverManager());
        return instanceMap.get((Object)DriverManagerType.CHROMIUM);
    }

    public static synchronized WebDriverManager firefoxdriver() {
        instanceMap.putIfAbsent(DriverManagerType.FIREFOX, new FirefoxDriverManager());
        return instanceMap.get((Object)DriverManagerType.FIREFOX);
    }

    public static synchronized WebDriverManager operadriver() {
        instanceMap.putIfAbsent(DriverManagerType.OPERA, new OperaDriverManager());
        return instanceMap.get((Object)DriverManagerType.OPERA);
    }

    public static synchronized WebDriverManager edgedriver() {
        instanceMap.putIfAbsent(DriverManagerType.EDGE, new EdgeDriverManager());
        return instanceMap.get((Object)DriverManagerType.EDGE);
    }

    public static synchronized WebDriverManager iedriver() {
        instanceMap.putIfAbsent(DriverManagerType.IEXPLORER, new InternetExplorerDriverManager());
        return instanceMap.get((Object)DriverManagerType.IEXPLORER);
    }

    public static synchronized WebDriverManager phantomjs() {
        instanceMap.putIfAbsent(DriverManagerType.PHANTOMJS, new PhantomJsDriverManager());
        return instanceMap.get((Object)DriverManagerType.PHANTOMJS);
    }

    public static synchronized WebDriverManager seleniumServerStandalone() {
        instanceMap.putIfAbsent(DriverManagerType.SELENIUM_SERVER_STANDALONE, new SeleniumServerStandaloneManager());
        return instanceMap.get((Object)DriverManagerType.SELENIUM_SERVER_STANDALONE);
    }

    protected static synchronized WebDriverManager voiddriver() {
        return new VoidDriverManager();
    }

    public static synchronized WebDriverManager getInstance(DriverManagerType driverManagerType) {
        if (driverManagerType == null) {
            return WebDriverManager.voiddriver();
        }
        switch (driverManagerType) {
            case CHROME: {
                return WebDriverManager.chromedriver();
            }
            case CHROMIUM: {
                return WebDriverManager.chromiumdriver();
            }
            case FIREFOX: {
                return WebDriverManager.firefoxdriver();
            }
            case OPERA: {
                return WebDriverManager.operadriver();
            }
            case IEXPLORER: {
                return WebDriverManager.iedriver();
            }
            case EDGE: {
                return WebDriverManager.edgedriver();
            }
            case PHANTOMJS: {
                return WebDriverManager.phantomjs();
            }
            case SELENIUM_SERVER_STANDALONE: {
                return WebDriverManager.seleniumServerStandalone();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public static synchronized WebDriverManager getInstance(Class<?> webDriverClass) {
        switch (webDriverClass.getName()) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                return WebDriverManager.chromedriver();
            }
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                return WebDriverManager.firefoxdriver();
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                return WebDriverManager.operadriver();
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                return WebDriverManager.iedriver();
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                return WebDriverManager.edgedriver();
            }
            case "org.openqa.selenium.phantomjs.PhantomJSDriver": {
                return WebDriverManager.phantomjs();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public synchronized void setup() {
        DriverManagerType driverManagerType = this.getDriverManagerType();
        this.initResolutionCache();
        this.cacheHandler = new CacheHandler(this.config);
        if (driverManagerType != null) {
            try {
                if (this.config().getClearingDriverCache()) {
                    this.clearDriverCache();
                }
                if (this.config().getClearingResolutionCache()) {
                    this.clearResolutionCache();
                }
                String driverVersion = this.getDriverVersion();
                this.manage(driverVersion);
            }
            finally {
                if (!this.config().isAvoidAutoReset()) {
                    this.reset();
                }
            }
        }
    }

    public WebDriverManager driverVersion(String driverVersion) {
        this.setDriverVersion(driverVersion);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager browserVersion(String browserVersion) {
        this.setBrowserVersion(browserVersion);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager architecture(Architecture architecture) {
        this.config().setArchitecture(architecture);
        this.forcedArch = true;
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager arch32() {
        this.architecture(Architecture.X32);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager arch64() {
        this.architecture(Architecture.X64);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager arm64() {
        this.architecture(Architecture.ARM64);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager win() {
        this.operatingSystem(OperatingSystem.WIN);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager linux() {
        this.operatingSystem(OperatingSystem.LINUX);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager mac() {
        this.operatingSystem(OperatingSystem.MAC);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager operatingSystem(OperatingSystem os) {
        this.config().setOs(os.name());
        this.forcedOs = true;
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager forceDownload() {
        this.config().setForceDownload(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager driverRepositoryUrl(URL url) {
        this.setDriverUrl(url);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager useMirror() {
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (!mirrorUrl.isPresent()) {
            throw new WebDriverManagerException("Mirror URL not available");
        }
        this.config().setUseMirror(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager proxy(String proxy) {
        this.config().setProxy(proxy);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager proxyUser(String proxyUser) {
        this.config().setProxyUser(proxyUser);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager proxyPass(String proxyPass) {
        this.config().setProxyPass(proxyPass);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager useBetaVersions() {
        this.config().setUseBetaVersions(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager ignoreDriverVersions(String ... driverVersions) {
        this.config().setIgnoreVersions(driverVersions);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager gitHubTokenSecret(String gitHubTokenSecret) {
        this.config().setGitHubTokenSecret(gitHubTokenSecret);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager gitHubTokenName(String gitHubTokenName) {
        this.config().setGitHubTokenName(gitHubTokenName);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager localRepositoryUser(String localRepositoryUser) {
        this.config().setLocalRepositoryUser(localRepositoryUser);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager localRepositoryPassword(String localRepositoryPassword) {
        this.config().setLocalRepositoryPassword(localRepositoryPassword);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager timeout(int timeout) {
        this.config().setTimeout(timeout);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager properties(String properties) {
        this.config().setProperties(properties);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager cachePath(String cachePath) {
        this.config().setCachePath(cachePath);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager resolutionCachePath(String resolutionCachePath) {
        this.config().setResolutionCachePath(resolutionCachePath);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidExport() {
        this.config().setAvoidExport(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidOutputTree() {
        this.config().setAvoidOutputTree(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidBrowserDetection() {
        this.config().setAvoidBrowserDetection(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidResolutionCache() {
        this.config().setAvoidResolutionCache(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidFallback() {
        this.config().setAvoidFallback(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager avoidReadReleaseFromRepository() {
        this.config().setAvoidReadReleaseFromRepository(true);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager ttl(int seconds) {
        this.config().setTtl(seconds);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager ttlBrowsers(int seconds) {
        this.config().setTtlForBrowsers(seconds);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager browserVersionDetectionCommand(String browserVersionCommand) {
        this.config().setBrowserVersionDetectionCommand(browserVersionCommand);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager useLocalVersionsPropertiesFirst() {
        this.config().setVersionsPropertiesOnlineFirst(false);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager useLocalCommandsPropertiesFirst() {
        this.config().setCommandsPropertiesOnlineFirst(false);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager versionsPropertiesUrl(URL url) {
        this.config().setVersionsPropertiesUrl(url);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager commandsPropertiesUrl(URL url) {
        this.config().setCommandsPropertiesUrl(url);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager clearResolutionCache() {
        this.initResolutionCache();
        WebDriverManager.instanceMap.get((Object)((Object)this.getDriverManagerType())).resolutionCache.clear();
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager clearDriverCache() {
        String cachePath = this.config().getCachePath();
        try {
            log.debug("Clearing driver cache at {}", (Object)cachePath);
            FileUtils.cleanDirectory((File)new File(cachePath));
        }
        catch (Exception e) {
            log.warn("Exception deleting driver cache at {}", (Object)cachePath, (Object)e);
        }
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public WebDriverManager browserVersionDetectionRegex(String regex) {
        this.config().setBrowserVersionDetectionRegex(regex);
        return instanceMap.get((Object)this.getDriverManagerType());
    }

    public String getDownloadedDriverPath() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.getDriverManagerType())).downloadedDriverPath;
    }

    public String getDownloadedDriverVersion() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.getDriverManagerType())).downloadedDriverVersion;
    }

    public List<String> getDriverVersions() {
        this.httpClient = new HttpClient(this.config());
        try {
            List<URL> driverUrls = this.getDriverUrls();
            ArrayList<String> driverVersionList = new ArrayList<String>();
            for (URL url : driverUrls) {
                String driverVersion = this.getCurrentVersion(url);
                if (driverVersion.isEmpty() || driverVersion.equalsIgnoreCase("icons") || driverVersionList.contains(driverVersion)) continue;
                driverVersionList.add(driverVersion);
            }
            log.trace("Driver version list before sorting {}", driverVersionList);
            Collections.sort(driverVersionList, new VersionComparator());
            return driverVersionList;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    protected void manage(String driverVersion) {
        this.httpClient = new HttpClient(this.config());
        try (HttpClient wdmHttpClient = this.httpClient;){
            String exportValue;
            this.versionDetector = new VersionDetector(this.config, this.httpClient);
            this.downloader = new Downloader(this.httpClient, this.config(), this::postDownload);
            if (this.isUnknown(driverVersion)) {
                driverVersion = this.resolveDriverVersion(driverVersion);
            }
            if (this.versionDetector.isSnap() && this.config.isUseChromiumDriverSnap()) {
                String chromiumDriverSnapPath = this.config().getChromiumDriverSnapPath();
                File snapChromiumDriverPath = new File(chromiumDriverSnapPath);
                boolean existsSnap = snapChromiumDriverPath.exists();
                if (existsSnap) {
                    log.debug("Found {} snap", (Object)this.getDriverManagerType());
                    this.exportDriver(chromiumDriverSnapPath);
                }
                return;
            }
            Optional<Object> driverInCache = Optional.empty();
            if (!this.isUnknown(driverVersion)) {
                driverInCache = this.cacheHandler.getDriverFromCache(driverVersion, this.getDriverName(), this.getDriverManagerType(), this.config().getArchitecture(), this.config().getOs());
            }
            if (driverInCache.isPresent() && !this.config().isForceDownload()) {
                log.debug("Driver {} {} found in cache", (Object)this.getDriverName(), (Object)this.getDriverVersionLabel(driverVersion));
                exportValue = (String)driverInCache.get();
                this.downloadedDriverVersion = driverVersion;
            } else {
                exportValue = this.download(driverVersion);
            }
            this.exportDriver(exportValue);
        }
        catch (Exception e) {
            this.handleException(e, driverVersion);
        }
    }

    protected String resolveDriverVersion(String driverVersion) {
        String preferenceKey = this.getKeyForResolutionCache();
        Optional<String> optionalBrowserVersion = Optional.ofNullable(this.getBrowserVersion()).filter(StringUtils::isNotEmpty);
        if (!optionalBrowserVersion.isPresent()) {
            optionalBrowserVersion = this.getValueFromResolutionCache(preferenceKey);
        }
        if (!optionalBrowserVersion.isPresent()) {
            optionalBrowserVersion = this.detectBrowserVersion();
        }
        if (optionalBrowserVersion.isPresent()) {
            preferenceKey = this.getKeyForResolutionCache() + optionalBrowserVersion.get();
            Optional<String> optionalDriverVersion = this.getValueFromResolutionCache(preferenceKey);
            if (!optionalDriverVersion.isPresent()) {
                optionalDriverVersion = this.getDriverVersionFromRepository(optionalBrowserVersion);
            }
            if (!optionalDriverVersion.isPresent()) {
                optionalDriverVersion = this.versionDetector.getDriverVersionFromProperties(preferenceKey);
            }
            if (optionalDriverVersion.isPresent()) {
                driverVersion = optionalDriverVersion.get();
                log.info("Using {} {} (resolved driver for {} {})", new Object[]{this.getDriverName(), driverVersion, this.getDriverManagerType().getBrowserName(), optionalBrowserVersion.get()});
                if (this.config.getIgnoreVersions().contains(driverVersion)) {
                    String formerBrowserVersion = String.valueOf(Integer.parseInt(optionalBrowserVersion.get()) - 1);
                    log.info("The driver {} {} is configured to be ignored ... trying again resolving driver for former version of {} (i.e. {})", new Object[]{this.getDriverName(), driverVersion, this.getDriverManagerType(), formerBrowserVersion});
                    this.setBrowserVersion(formerBrowserVersion);
                    return this.resolveDriverVersion("");
                }
                this.storeInResolutionCache(preferenceKey, driverVersion, optionalBrowserVersion.get());
            }
        }
        if (this.isUnknown(driverVersion)) {
            String browserVersionStr = optionalBrowserVersion.isPresent() ? " " + optionalBrowserVersion.get() : "";
            log.debug("The driver version for {}{} is unknown ... trying with latest", (Object)this.getDriverManagerType(), (Object)browserVersionStr);
            Optional<String> latestDriverVersionFromRepository = this.getLatestDriverVersionFromRepository();
            if (latestDriverVersionFromRepository.isPresent()) {
                driverVersion = latestDriverVersionFromRepository.get();
            }
        }
        return driverVersion;
    }

    protected void initResolutionCache() {
        this.resolutionCache = new ResolutionCache(this.config);
    }

    protected String download(String driverVersion) throws IOException {
        if (driverVersion.startsWith(".")) {
            driverVersion = driverVersion.substring(1);
        }
        UrlHandler urlHandler = this.createUrlHandler(driverVersion);
        URL url = urlHandler.getCandidateUrl();
        this.downloadedDriverVersion = urlHandler.getDriverVersion();
        return this.downloader.download(url, this.downloadedDriverVersion, this.getDriverName(), this.getDriverManagerType());
    }

    protected void exportDriver(String variableValue) {
        this.downloadedDriverPath = variableValue;
        Optional<String> exportParameter = this.getExportParameter();
        if (!this.config.isAvoidExport() && exportParameter.isPresent()) {
            String variableName = exportParameter.get();
            log.info("Exporting {} as {}", (Object)variableName, (Object)variableValue);
            System.setProperty(variableName, variableValue);
        } else {
            log.info("Driver location: {}", (Object)variableValue);
        }
    }

    protected void storeInResolutionCache(String preferenceKey, String resolvedDriverVersion, String resolvedBrowserVersion) {
        if (this.useResolutionCache()) {
            this.resolutionCache.putValueInResolutionCacheIfEmpty(this.getKeyForResolutionCache(), resolvedBrowserVersion, this.config().getTtlForBrowsers());
            this.resolutionCache.putValueInResolutionCacheIfEmpty(preferenceKey, resolvedDriverVersion, this.config().getTtl());
        }
    }

    protected Optional<String> getValueFromResolutionCache(String preferenceKey) {
        Optional<String> optionalBrowserVersion = Optional.empty();
        if (this.useResolutionCacheWithKey(preferenceKey)) {
            optionalBrowserVersion = Optional.of(this.resolutionCache.getValueFromResolutionCache(preferenceKey));
        }
        return optionalBrowserVersion;
    }

    protected List<File> postDownload(File archive) {
        File[] ls;
        File parentFolder = archive.getParentFile();
        for (File f : ls = parentFolder.listFiles()) {
            if (!this.getDriverName().contains(FilenameUtils.removeExtension((String)f.getName()))) continue;
            log.trace("Found driver in post-download: {}", (Object)f);
            return Collections.singletonList(f);
        }
        throw new WebDriverManagerException("Driver " + this.getDriverName() + " not found (using temporal folder " + parentFolder + ")");
    }

    protected Optional<String> getBrowserVersionFromTheShell() {
        return this.versionDetector.getBrowserVersionFromTheShell(this.getDriverManagerType().getBrowserName().toLowerCase());
    }

    protected Optional<String> detectBrowserVersion() {
        Optional<String> optionalBrowserVersion;
        if (this.config().isAvoidBrowserDetection()) {
            return Optional.empty();
        }
        String driverManagerTypeLowerCase = this.getDriverManagerType().name().toLowerCase(Locale.ROOT);
        if (this.useResolutionCacheWithKey(driverManagerTypeLowerCase)) {
            optionalBrowserVersion = Optional.of(this.resolutionCache.getValueFromResolutionCache(driverManagerTypeLowerCase));
            log.trace("Detected {} version {}", (Object)this.getDriverManagerType(), optionalBrowserVersion);
        } else {
            optionalBrowserVersion = this.getBrowserVersionFromTheShell();
        }
        return optionalBrowserVersion;
    }

    protected boolean useResolutionCacheWithKey(String key) {
        return this.useResolutionCache() && this.resolutionCache.checkKeyInResolutionCache(key);
    }

    protected boolean useResolutionCache() {
        return !this.config().isAvoidingResolutionCache() && !this.config().isForceDownload();
    }

    protected boolean isUnknown(String driverVersion) {
        return Config.isNullOrEmpty(driverVersion) || driverVersion.equalsIgnoreCase("latest");
    }

    protected String getCurrentVersion(URL url) {
        String currentVersion = "";
        String pattern = "/([^/]*?)/[^/]*?" + this.getShortDriverName();
        Matcher matcher = Pattern.compile(pattern, 2).matcher(url.getFile());
        boolean find = matcher.find();
        if (find) {
            currentVersion = matcher.group(1);
        } else {
            log.trace("Version not found in URL {}", (Object)url);
        }
        return currentVersion;
    }

    protected void handleException(Exception e, String driverVersion) {
        String driverVersionStr = this.getDriverVersionLabel(driverVersion);
        String errorMessage = String.format("There was an error managing %s %s (%s)", this.getDriverName(), driverVersionStr, e.getMessage());
        if (this.retryCount == 0 && !this.config().isAvoidFallback()) {
            ++this.retryCount;
            if (this.getDriverManagerType() == DriverManagerType.EDGE || this.getDriverManagerType() == DriverManagerType.CHROME) {
                this.config().setAvoidReadReleaseFromRepository(true);
                this.clearResolutionCache();
                log.warn("{} ... trying again avoiding reading release from repository", (Object)errorMessage);
                this.manage("");
            } else {
                ++this.retryCount;
                this.fallback(e, errorMessage);
            }
        } else if (this.retryCount == 1 && !this.config().isAvoidFallback()) {
            this.fallback(e, errorMessage);
        } else {
            log.error("{}", (Object)errorMessage, (Object)e);
            throw new WebDriverManagerException(e);
        }
    }

    protected void fallback(Exception e, String errorMessage) {
        this.config().setAvoidBrowserDetection(true);
        String driverVersion = "";
        this.setBrowserVersion("");
        ++this.retryCount;
        log.warn("{} ... trying again using latest driver stored in cache", (Object)errorMessage);
        if (log.isTraceEnabled()) {
            log.trace("Error trace: ", (Throwable)e);
        }
        this.manage(driverVersion);
    }

    protected UrlHandler createUrlHandler(String driverVersion) throws IOException {
        boolean continueSearchingVersion;
        List<URL> candidateUrls = this.getDriverUrls();
        String shortDriverName = this.getShortDriverName();
        UrlHandler urlHandler = new UrlHandler(this.config(), candidateUrls, driverVersion, shortDriverName, this::buildUrl);
        log.trace("All driver URLs: {}", candidateUrls);
        boolean getLatest = this.isUnknown(driverVersion);
        do {
            urlHandler.filterByDriverName(shortDriverName);
            if (getLatest) {
                urlHandler.filterByLatestVersion(this::getCurrentVersion);
            } else {
                urlHandler.filterByVersion(driverVersion);
            }
            if (urlHandler.getDriverVersion() == null) break;
            log.debug("Driver to be downloaded {} {}", (Object)shortDriverName, (Object)urlHandler.getDriverVersion());
            log.trace("Driver URLs after filtering for version: {}", urlHandler.getCandidateUrls());
            String os = this.config().getOs();
            Architecture architecture = this.config().getArchitecture();
            if (architecture != Architecture.ARM64 || this.getDriverManagerType() != DriverManagerType.EDGE) {
                urlHandler.filterByOs(this.getDriverName(), os);
            }
            urlHandler.filterByArch(architecture, this.forcedArch);
            urlHandler.filterByDistro(os, this.getDriverName());
            urlHandler.filterByIgnoredVersions(this.config().getIgnoreVersions());
            urlHandler.filterByBeta(this.config().isUseBetaVersions());
            boolean bl = continueSearchingVersion = urlHandler.hasNoCandidateUrl() && getLatest;
            if (!continueSearchingVersion) continue;
            log.info("No proper driver found for {} {} ... seeking another version", (Object)this.getDriverName(), (Object)this.getDriverVersionLabel(driverVersion));
            urlHandler.resetList(candidateUrls);
            candidateUrls = urlHandler.getCandidateUrls();
        } while (continueSearchingVersion);
        return urlHandler;
    }

    protected List<URL> getDriversFromMirror(URL driverUrl) throws IOException {
        if (!this.mirrorLog) {
            log.debug("Crawling driver list from mirror {}", (Object)driverUrl);
            this.mirrorLog = true;
        } else {
            log.trace("[Recursive call] Crawling driver list from mirror {}", (Object)driverUrl);
        }
        String driverStr = driverUrl.toString();
        String driverOrigin = String.format("%s://%s", driverUrl.getProtocol(), driverUrl.getAuthority());
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(driverUrl));){
            InputStream in = response.getEntity().getContent();
            Document doc = Jsoup.parse((InputStream)in, null, (String)driverStr);
            Iterator iterator = doc.select("a").iterator();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (iterator.hasNext()) {
                String link = ((org.jsoup.nodes.Element)iterator.next()).attr("abs:href");
                if (link.startsWith(driverStr) && link.endsWith(SLASH)) {
                    urlList.addAll(this.getDriversFromMirror(new URL(link)));
                    continue;
                }
                if (!link.startsWith(driverOrigin) || link.contains("icons") || !link.toLowerCase(Locale.ROOT).endsWith(".bz2") && !link.toLowerCase(Locale.ROOT).endsWith(".zip") && !link.toLowerCase(Locale.ROOT).endsWith(".gz")) continue;
                urlList.add(new URL(link));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    protected NamespaceContext getNamespaceContext() {
        return null;
    }

    protected Optional<NamespaceContext> getS3NamespaceContext() {
        return Optional.of(S3_NAMESPACE_CONTEXT);
    }

    protected List<URL> getDriversFromXml(URL driverUrl, String xpath, Optional<NamespaceContext> namespaceContext) throws IOException {
        this.logSeekRepo(driverUrl);
        ArrayList<URL> urls = new ArrayList<URL>();
        try (CloseableHttpResponse response = this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(driverUrl));){
            org.w3c.dom.Document xml = this.loadXML(response.getEntity().getContent());
            XPath xPath = XPathFactory.newInstance().newXPath();
            if (namespaceContext.isPresent()) {
                xPath.setNamespaceContext(namespaceContext.get());
            }
            NodeList nodes = (NodeList)xPath.evaluate(xpath, xml.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                urls.add(new URL(driverUrl.toURI().resolve(".") + e.getChildNodes().item(0).getNodeValue()));
            }
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        return urls;
    }

    protected void logSeekRepo(URL driverUrl) {
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)this.getDriverName());
    }

    protected org.w3c.dom.Document loadXML(InputStream inputStream) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(new InputSource(new ByteArrayInputStream(IOUtils.toByteArray((InputStream)inputStream))));
    }

    protected InputStream openGitHubConnection(URL driverUrl) throws IOException {
        HttpGet get = this.httpClient.createHttpGet(driverUrl);
        String gitHubTokenName = this.config().getGitHubTokenName();
        String gitHubTokenSecret = this.config().getGitHubTokenSecret();
        if (!Config.isNullOrEmpty(gitHubTokenName) && !Config.isNullOrEmpty(gitHubTokenSecret)) {
            String userpass = gitHubTokenName + ":" + gitHubTokenSecret;
            String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
            get.addHeader("Authorization", (Object)basicAuth);
        }
        return this.httpClient.execute((ClassicHttpRequest)get).getEntity().getContent();
    }

    protected List<URL> getDriversFromGitHub() throws IOException {
        List<URL> urls;
        URL driverUrl = this.getDriverUrl();
        this.logSeekRepo(driverUrl);
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (mirrorUrl.isPresent() && this.config.isUseMirror()) {
            urls = this.getDriversFromMirror(mirrorUrl.get());
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
                urls = new ArrayList<URL>();
                for (GitHubApi release : releaseArray) {
                    if (release == null) continue;
                    List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                    for (LinkedTreeMap<String, Object> asset : assets) {
                        urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                    }
                }
            }
        }
        return urls;
    }

    protected List<URL> getDriversFromBitBucket() throws IOException {
        List<URL> urls;
        URL driverUrl = this.getDriverUrl();
        this.logSeekRepo(driverUrl);
        Optional<URL> mirrorUrl = this.getMirrorUrl();
        if (mirrorUrl.isPresent() && this.config.isUseMirror()) {
            urls = this.getDriversFromMirror(mirrorUrl.get());
        } else {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.httpClient.execute((ClassicHttpRequest)this.httpClient.createHttpGet(driverUrl)).getEntity().getContent()));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                BitBucketApi bitBucketInfo = (BitBucketApi)gson.fromJson((Reader)reader, BitBucketApi.class);
                urls = bitBucketInfo.getUrls();
            }
        }
        return urls;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected FilenameFilter getFolderFilter() {
        return (dir, name) -> dir.isDirectory() && name.toLowerCase(Locale.ROOT).contains(this.getDriverName());
    }

    protected Charset getVersionCharset() {
        return Charset.defaultCharset();
    }

    protected String getLatestVersionLabel() {
        return LATEST_RELEASE;
    }

    protected Optional<String> getOsLabel() {
        return Optional.empty();
    }

    protected Optional<String> getDriverVersionFromRepository(Optional<String> driverVersion) {
        return this.config().isAvoidReadReleaseFromRepository() ? Optional.empty() : this.versionDetector.getDriverVersionFromRepository(driverVersion, this.getDriverUrl(), this.getVersionCharset(), this.getDriverName(), this.getLatestVersionLabel(), LATEST_RELEASE, this.getOsLabel());
    }

    protected void reset() {
        this.config().reset();
        this.mirrorLog = false;
        this.forcedArch = false;
        this.forcedOs = false;
        this.retryCount = 0;
    }

    protected String getProgramFilesEnv() {
        return System.getProperty("os.arch").contains("64") ? "PROGRAMFILES" : "PROGRAMFILES(X86)";
    }

    protected String getOtherProgramFilesEnv() {
        return System.getProperty("os.arch").contains("64") ? "PROGRAMFILES(X86)" : "PROGRAMFILES";
    }

    protected URL getDriverUrlCkeckingMirror(URL url) {
        Optional<URL> mirrorUrl;
        if (this.config().isUseMirror() && (mirrorUrl = this.getMirrorUrl()).isPresent()) {
            return mirrorUrl.get();
        }
        return url;
    }

    protected static void resolveLocal(String validBrowsers, String arg) {
        log.info("Using WebDriverManager to resolve {}", (Object)arg);
        try {
            DriverManagerType driverManagerType = DriverManagerType.valueOf(arg.toUpperCase(Locale.ROOT));
            WebDriverManager wdm = WebDriverManager.getInstance(driverManagerType).avoidExport().cachePath(".").forceDownload();
            if (arg.equalsIgnoreCase("edge") || arg.equalsIgnoreCase("iexplorer")) {
                wdm.operatingSystem(OperatingSystem.WIN);
            }
            wdm.avoidOutputTree().setup();
        }
        catch (Exception e) {
            log.error("Driver for {} not found (valid browsers {})", (Object)arg, (Object)validBrowsers);
        }
    }

    protected static void startServer(String[] args) {
        int port = new Config().getServerPort();
        if (args.length > 1 && StringUtils.isNumeric((CharSequence)args[1])) {
            port = Integer.parseInt(args[1]);
        }
        new WdmServer(port);
    }

    protected static void logCliError(String validBrowsers) {
        log.error("There are 3 options to run WebDriverManager CLI");
        log.error("1. WebDriverManager used to resolve drivers locally:");
        log.error("\tWebDriverManager browserName");
        log.error("\t(where browserName={})", (Object)validBrowsers);
        log.error("2. WebDriverManager as a server:");
        log.error("\tWebDriverManager server <port>");
        log.error("\t(where default port is 4041)");
        log.error("3. To clear resolution cache (i.e. previously resolved driver versions):");
        log.error("\tWebDriverManager clear-resolution-cache");
    }

    protected void setConfig(Config config) {
        this.config = config;
    }

    protected Optional<String> getLatestDriverVersionFromRepository() {
        return Optional.empty();
    }

    protected String getShortDriverName() {
        return this.getDriverName();
    }

    protected String getKeyForResolutionCache() {
        return this.getDriverManagerType().name().toLowerCase(Locale.ROOT);
    }

    protected String getDriverVersionLabel(String driverVersion) {
        return this.isUnknown(driverVersion) ? "(latest version)" : driverVersion;
    }

    protected Optional<URL> buildUrl(String driverVersion) {
        return Optional.empty();
    }

    public static void main(String[] args) {
        String validBrowsers = "chrome|chromium|firefox|opera|edge|phantomjs|iexplorer|selenium_server_standalone";
        if (args.length <= 0) {
            WebDriverManager.logCliError(validBrowsers);
        } else {
            String arg = args[0];
            if (arg.equalsIgnoreCase("server")) {
                WebDriverManager.startServer(args);
            } else if (arg.equalsIgnoreCase("clear-resolution-cache")) {
                new ResolutionCache(new Config()).clear();
            } else {
                WebDriverManager.resolveLocal(validBrowsers, arg);
            }
        }
    }
}

