/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.adaptor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.BpmnNodeParamTypeEnum;
import org.openoa.base.constant.enums.OrderNodeTypeEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.AdaptorService;
import org.openoa.base.interf.BpmnPersonnelProviderService;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.adaptor.bpmnelementadp.AbstractOrderedSignNodeAdp;
import org.springframework.util.ObjectUtils;

public abstract class AbstractBpmnPersonnelAdaptor
implements AdaptorService {
    private final BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService;
    private final BpmnPersonnelProviderService bpmnPersonnelProviderService;

    public AbstractBpmnPersonnelAdaptor(BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService, BpmnPersonnelProviderService bpmnPersonnelProviderService) {
        this.bpmnEmployeeInfoProviderService = bpmnEmployeeInfoProviderService;
        this.bpmnPersonnelProviderService = bpmnPersonnelProviderService;
    }

    public void setNodeParams(BpmnNodeVo nodeVo, BpmnStartConditionsVo startConditionsVo, BpmnNodeParamTypeEnum nodeParamTypeEnum, String nextId, Map<String, BpmnNodeVo> mapPreNodes, HashSet<BpmnNodeVo> setAddNodes) {
        if (nodeVo == null) {
            throw new AFBizException("nodeVo can not be null if you want to set property to it");
        }
        if (nodeParamTypeEnum == null) {
            throw new AFBizException("param:nodeParamTypeEnum can not be null");
        }
        BpmnNodeParamsVo paramsVo = nodeVo.getParams();
        String nodeName = nodeVo.getNodeName();
        if (paramsVo == null) {
            throw new AFBizException("param:paramsVo can not be null");
        }
        Integer orderedNodeType = nodeVo.getOrderedNodeType();
        if (orderedNodeType != null) {
            OrderNodeTypeEnum orderNodeTypeEnum = OrderNodeTypeEnum.getByCode((Integer)orderedNodeType);
            Collection abstractOrderedSignNodeAdps = SpringBeanUtils.getBeans(AbstractOrderedSignNodeAdp.class);
            AbstractOrderedSignNodeAdp orderedSignNodeAdp = null;
            for (AbstractOrderedSignNodeAdp abstractOrderedSignNodeAdp : abstractOrderedSignNodeAdps) {
                if (!abstractOrderedSignNodeAdp.isSupportBusinessObject((Enum)orderNodeTypeEnum)) continue;
                orderedSignNodeAdp = abstractOrderedSignNodeAdp;
                break;
            }
            orderedSignNodeAdp.formatNodes(nodeVo, startConditionsVo, nextId, mapPreNodes, setAddNodes);
            return;
        }
        paramsVo.setParamType(nodeParamTypeEnum.getCode());
        List<BpmnNodeParamsAssigneeVo> assigneeList = this.assigneeListUniq(this.bpmnPersonnelProviderService.getAssigneeList(nodeVo, startConditionsVo));
        this.setAssigneeOrList(paramsVo, assigneeList, nodeParamTypeEnum);
        this.setEmployeeName(assigneeList, nodeName, nodeVo);
    }

    private void setEmployeeName(List<BpmnNodeParamsAssigneeVo> assigneeList, String nodeName, BpmnNodeVo bpmnNodeVo) {
        if (assigneeList.stream().noneMatch(a -> StringUtils.isEmpty((CharSequence)a.getAssigneeName()))) {
            return;
        }
        List ids = assigneeList.stream().map(BpmnNodeParamsAssigneeVo::getAssignee).collect(Collectors.toList());
        Map empIdNameMap = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo(ids);
        for (BpmnNodeParamsAssigneeVo assigneeVo : assigneeList) {
            String empId = assigneeVo.getAssignee();
            if (!empIdNameMap.containsKey(empId)) continue;
            assigneeVo.setAssigneeName((String)empIdNameMap.get(empId));
        }
    }

    private void setAssigneeOrList(BpmnNodeParamsVo paramsVo, List<BpmnNodeParamsAssigneeVo> assigneeList, BpmnNodeParamTypeEnum nodeParamTypeEnum) {
        if (ObjectUtils.isEmpty((Object)paramsVo)) {
            throw new AFBizException("\u53c2\u6570paramsVo\u4e3a\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty(assigneeList)) {
            throw new AFBizException("\u5ba1\u6279\u4eba\u5217\u8868\u5fc5\u987b\u5305\u542b\u4eba\u5458\u4fe1\u606f!");
        }
        if (nodeParamTypeEnum == BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE) {
            paramsVo.setAssignee(assigneeList.get(0));
        } else {
            paramsVo.setAssigneeList(assigneeList);
        }
    }

    private List<BpmnNodeParamsAssigneeVo> assigneeListUniq(List<BpmnNodeParamsAssigneeVo> paramsList) {
        ArrayList<BpmnNodeParamsAssigneeVo> result = new ArrayList<BpmnNodeParamsAssigneeVo>();
        if (ObjectUtils.isEmpty(paramsList)) {
            return result;
        }
        HashSet<String> uniqList = new HashSet<String>();
        for (BpmnNodeParamsAssigneeVo vo : paramsList) {
            if (!uniqList.contains(vo.getAssignee())) {
                result.add(vo);
            }
            uniqList.add(vo.getAssignee());
        }
        return result;
    }
}

