/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.adaptor.bpmnelementadp;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SerializationUtils;
import org.openoa.base.constant.enums.AFSpecialAssigneeEnum;
import org.openoa.base.constant.enums.BpmnNodeParamTypeEnum;
import org.openoa.base.interf.AdaptorService;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.util.AssigneeVoBuildUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.CollectionUtils;

public abstract class AbstractOrderedSignNodeAdp
implements AdaptorService {
    @Autowired
    private AssigneeVoBuildUtils assigneeVoBuildUtils;

    public abstract List<String> getAssigneeIds(BpmnNodeVo var1, BpmnStartConditionsVo var2);

    public void formatNodes(BpmnNodeVo nodeVo, BpmnStartConditionsVo bpmnStartConditions, String nextNodeId, Map<String, BpmnNodeVo> mapPreNodes, HashSet<BpmnNodeVo> setAddNodes) {
        boolean b;
        List<BpmnNodeVo> orderedSignNodes = this.getOrderedSignNodes(nodeVo, bpmnStartConditions, nextNodeId);
        boolean bl = b = nodeVo.getParams().getAssigneeList() != null && nodeVo.getParams().getAssigneeList().size() == 1 && !AFSpecialAssigneeEnum.TO_BE_REMOVED.getId().equals(((BpmnNodeParamsAssigneeVo)nodeVo.getParams().getAssigneeList().get(0)).getAssignee());
        if (!CollectionUtils.isEmpty(orderedSignNodes) || b) {
            if (!CollectionUtils.isEmpty(orderedSignNodes)) {
                mapPreNodes.get(nextNodeId).getParams().setNodeTo(orderedSignNodes.get(orderedSignNodes.size() - 1).getNodeId());
                setAddNodes.addAll(orderedSignNodes);
            } else {
                mapPreNodes.get(nextNodeId).getParams().setNodeTo(nodeVo.getNodeId());
            }
        } else {
            nodeVo.getParams().setAssigneeList((List)Lists.newArrayList((Object[])new BpmnNodeParamsAssigneeVo[]{this.assigneeVoBuildUtils.buildZeroVo()}));
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<BpmnNodeVo> getOrderedSignNodes(BpmnNodeVo nodeVo, BpmnStartConditionsVo bpmnStartConditions, String nextNodeId) {
        if (nodeVo.getParams().getAssigneeList() == null) {
            nodeVo.getParams().setAssigneeList((List)Lists.newArrayList((Object[])new BpmnNodeParamsAssigneeVo[]{BpmnNodeParamsAssigneeVo.builder().assignee(AFSpecialAssigneeEnum.TO_BE_REMOVED.getId()).isDeduplication(Integer.valueOf(0)).build()}));
        }
        ArrayList<BpmnNodeVo> result = new ArrayList<BpmnNodeVo>();
        List<Object> listAssign = this.getAssignees(nodeVo, bpmnStartConditions);
        if (CollectionUtils.isEmpty(listAssign)) {
            return result;
        }
        LinkedHashSet<String> emplIds = new LinkedHashSet<String>();
        for (BpmnNodeParamsAssigneeVo bpmnNodeParamsAssigneeVo : listAssign) {
            emplIds.add(bpmnNodeParamsAssigneeVo.getAssignee());
        }
        if (emplIds.contains(AFSpecialAssigneeEnum.TO_BE_REMOVED.getId()) && 1 == emplIds.size()) {
            return result;
        }
        listAssign = listAssign.stream().filter(a -> !Objects.equals(a.getAssignee(), AFSpecialAssigneeEnum.TO_BE_REMOVED.getId())).collect(Collectors.toList());
        BpmnNodeParamsAssigneeVo firstAssignee = (BpmnNodeParamsAssigneeVo)listAssign.get(0);
        if (nodeVo.getParams().getAssigneeList().size() == 1 && AFSpecialAssigneeEnum.TO_BE_REMOVED.getId().equals(((BpmnNodeParamsAssigneeVo)nodeVo.getParams().getAssigneeList().get(0)).getAssignee())) {
            nodeVo.getParams().setAssigneeList((List)Lists.newArrayList((Object[])new BpmnNodeParamsAssigneeVo[]{firstAssignee}));
            nodeVo.getParams().setParamType(BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER.getCode());
        }
        boolean bl = true;
        for (BpmnNodeParamsAssigneeVo bpmnNodeParamsAssigneeVo : listAssign) {
            void var8_10;
            if (bpmnNodeParamsAssigneeVo == firstAssignee) continue;
            BpmnNodeVo copyNode = (BpmnNodeVo)SerializationUtils.clone((Serializable)nodeVo);
            copyNode.setNodeId(nodeVo.getNodeId() + "copy" + (int)var8_10);
            ++var8_10;
            copyNode.getProperty().setIsMultiPeople(Integer.valueOf(1));
            copyNode.getParams().setAssigneeList((List)Lists.newArrayList((Object[])new BpmnNodeParamsAssigneeVo[]{bpmnNodeParamsAssigneeVo}));
            copyNode.getParams().setParamType(BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_MULTIPLAYER.getCode());
            result.add(copyNode);
        }
        String forNext = nextNodeId;
        for (BpmnNodeVo vo : result) {
            vo.getParams().setNodeTo(forNext);
            forNext = vo.getNodeId();
        }
        return result;
    }

    private List<BpmnNodeParamsAssigneeVo> getAssignees(BpmnNodeVo nodeVo, BpmnStartConditionsVo bpmnStartConditions) {
        List<String> assigneeIds = this.getAssigneeIds(nodeVo, bpmnStartConditions);
        if (CollectionUtils.isEmpty(assigneeIds)) {
            return Lists.newArrayList();
        }
        assigneeIds = assigneeIds.stream().distinct().collect(Collectors.toList());
        List<Object> assigneeVos = this.assigneeVoBuildUtils.buildVos(assigneeIds, nodeVo.getNodeName(), true);
        assigneeVos = assigneeVos.stream().filter(a -> !AFSpecialAssigneeEnum.TO_BE_REMOVED.getId().equals(a.getAssignee())).collect(Collectors.toList());
        assigneeVos.add(this.assigneeVoBuildUtils.buildZeroVo());
        return assigneeVos;
    }
}

