/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.adaptor.bpmnelementadp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.SignTypeEnum;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.common.adaptor.bpmnelementadp.BpmnElementAdaptor;
import org.openoa.common.util.BpmnElementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BpmnElementOutSideAccessAdp
extends BpmnElementAdaptor {
    private static final Logger log = LoggerFactory.getLogger(BpmnElementOutSideAccessAdp.class);

    @Override
    protected BpmnConfCommonElementVo getElementVo(BpmnNodePropertysVo property, BpmnNodeParamsVo params, Integer elementCode, String elementId) {
        String elementName = ((BpmnNodeParamsAssigneeVo)params.getAssigneeList().get(0)).getElementName();
        String collectionName = "outSideAccessList";
        Integer signType = property.getSignType();
        Map<String, String> assigneeMap = params.getAssigneeList().stream().collect(Collectors.toMap(BpmnNodeParamsAssigneeVo::getAssignee, BpmnNodeParamsAssigneeVo::getAssigneeName, (k1, k2) -> k1));
        if (SignTypeEnum.SIGN_TYPE_SIGN.getCode().equals(signType)) {
            return BpmnElementUtils.getMultiplayerSignElement(elementId, elementName, StringUtils.join((Object[])new Serializable[]{collectionName, elementCode}), new ArrayList<String>(assigneeMap.keySet()), assigneeMap);
        }
        return BpmnElementUtils.getMultiplayerOrSignElement(elementId, elementName, StringUtils.join((Object[])new Serializable[]{collectionName, elementCode}), new ArrayList<String>(assigneeMap.keySet()), assigneeMap);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{NodePropertyEnum.NODE_PROPERTY_OUT_SIDE_ACCESS});
    }
}

