/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.adaptor.bpmnelementadp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.SignTypeEnum;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.common.adaptor.bpmnelementadp.BpmnElementAdaptor;
import org.openoa.common.util.BpmnElementUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class BpmnElementPersonnelAdp
extends BpmnElementAdaptor {
    private static final Logger log = LoggerFactory.getLogger(BpmnElementPersonnelAdp.class);

    @Override
    protected BpmnConfCommonElementVo getElementVo(BpmnNodePropertysVo property, BpmnNodeParamsVo params, Integer elementCode, String elementId) {
        List assigneeList = params.getAssigneeList();
        String elementName = ((BpmnNodeParamsAssigneeVo)assigneeList.get(0)).getElementName();
        String collectionName = "personnelList";
        Integer signType = property.getSignType();
        LinkedHashMap<String, String> assigneeMap = new LinkedHashMap<String, String>();
        ArrayList<String> assignee = new ArrayList<String>();
        for (BpmnNodeParamsAssigneeVo assigneeVo : assigneeList) {
            if (assigneeVo.getIsDeduplication() != 0) continue;
            assignee.add(assigneeVo.getAssignee());
            assigneeMap.put(assigneeVo.getAssignee(), assigneeVo.getAssigneeName());
        }
        if (SignTypeEnum.SIGN_TYPE_SIGN.getCode().equals(signType)) {
            return BpmnElementUtils.getMultiplayerSignElement(elementId, elementName, StringUtils.join((Object[])new Serializable[]{collectionName, elementCode}), new ArrayList<String>(assigneeMap.keySet()), assigneeMap);
        }
        if (SignTypeEnum.SIGN_TYPE_SIGN_IN_ORDER.getCode().equals(signType)) {
            return BpmnElementUtils.getMultiplayerSignInOrderElement(elementId, elementName, StringUtils.join((Object[])new Serializable[]{collectionName, elementCode}), new ArrayList<String>(assigneeMap.keySet()), assigneeMap);
        }
        return BpmnElementUtils.getMultiplayerOrSignElement(elementId, elementName, StringUtils.join((Object[])new Serializable[]{collectionName, elementCode}), new ArrayList<String>(assigneeMap.keySet()), assigneeMap);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{NodePropertyEnum.NODE_PROPERTY_PERSONNEL});
    }
}

