/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.formatter;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.openoa.base.constant.enums.BpmnNodeParamTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.constant.enums.PersonnelEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.BpmnUtils;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.adaptor.AbstractBpmnPersonnelAdaptor;
import org.openoa.common.formatter.BpmnPersonnelFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class BpmnPersonnelFormatImpl
implements BpmnPersonnelFormat {
    private static final Logger log = LoggerFactory.getLogger(BpmnPersonnelFormatImpl.class);

    @Override
    public BpmnConfVo formatPersonnelsConf(BpmnConfVo bpmnConfVo, BpmnStartConditionsVo bpmnStartConditions) {
        if (ObjectUtils.isEmpty((Object)bpmnConfVo) || ObjectUtils.isEmpty((Object)bpmnStartConditions)) {
            throw new AFBizException("the process's conf is null or empty,can not go on!");
        }
        if (ObjectUtils.isEmpty((Object)bpmnConfVo.getNodes())) {
            throw new AFBizException("process's nodes is empty,can not go on!");
        }
        if (ObjectUtils.isEmpty((Object)bpmnStartConditions.getStartUserId())) {
            throw new AFBizException("process's start userId is null or empty,can not go on");
        }
        String startNodeId = null;
        HashMap<String, BpmnNodeVo> mapNodes = new HashMap<String, BpmnNodeVo>();
        HashMap<String, BpmnNodeVo> mapPreNodes = new HashMap<String, BpmnNodeVo>();
        HashSet<BpmnNodeVo> setAddNodes = new HashSet<BpmnNodeVo>();
        List manyEmployeeIds = bpmnStartConditions.getEmplIdList();
        for (BpmnNodeVo vo : bpmnConfVo.getNodes()) {
            mapNodes.put(vo.getNodeId(), vo);
            if (!ObjectUtils.isEmpty((Object)vo.getNodeType()) && vo.getNodeType().equals(NodeTypeEnum.NODE_TYPE_START.getCode())) {
                startNodeId = vo.getNodeId();
            }
            mapPreNodes.put(vo.getParams().getNodeTo(), vo);
        }
        if (ObjectUtils.isEmpty(startNodeId)) {
            throw new AFBizException("config error,can not find the start node id");
        }
        if (!mapNodes.containsKey(startNodeId)) {
            throw new AFBizException("config error,the start node is not in the nodes list");
        }
        BpmnNodeVo baseStart = (BpmnNodeVo)mapNodes.get(startNodeId);
        BpmnNodeParamsVo paramsStartVo = baseStart.getParams();
        paramsStartVo.setParamType(BpmnNodeParamTypeEnum.BPMN_NODE_PARAM_SINGLE.getCode());
        BpmnNodeParamsAssigneeVo startResult = new BpmnNodeParamsAssigneeVo();
        startResult.setAssignee(bpmnStartConditions.getStartUserId());
        startResult.setElementName("\u53d1\u8d77\u4eba");
        paramsStartVo.setAssignee(startResult);
        ((BpmnNodeVo)mapNodes.get(startNodeId)).setParams(paramsStartVo);
        String nextId = paramsStartVo.getNodeTo();
        if (ObjectUtils.isEmpty((Object)nextId)) {
            log.warn("the process only have one start node,maybe there is something wrong!");
            bpmnConfVo.setNodes(new ArrayList(mapNodes.values()));
            return bpmnConfVo;
        }
        do {
            if (!mapNodes.containsKey(nextId)) {
                throw new AFBizException("the processed node isn't in the nodes list,can not go on");
            }
            BpmnNodeVo base = (BpmnNodeVo)mapNodes.get(nextId);
            if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(base.getNodeType())) {
                BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)base, mapNodes.values());
                this.treatParallelGateWayRecursively(base, aggregationNode, mapNodes, setAddNodes, bpmnStartConditions);
                nextId = aggregationNode.getNodeId();
                continue;
            }
            this.processAssigneeNode(base, mapPreNodes, setAddNodes, nextId, bpmnStartConditions);
            nextId = base.getParams().getNodeTo();
        } while (!Strings.isNullOrEmpty((String)nextId));
        ArrayList<Object> finallyNodes = new ArrayList<Object>();
        finallyNodes.addAll(mapNodes.values());
        if (!ObjectUtils.isEmpty(setAddNodes)) {
            finallyNodes.addAll(setAddNodes);
        }
        bpmnConfVo.setNodes(finallyNodes);
        return bpmnConfVo;
    }

    private void treatParallelGateWayRecursively(BpmnNodeVo outerMostParallelGatewayNode, BpmnNodeVo itsAggregationNode, Map<String, BpmnNodeVo> mapNodes, HashSet<BpmnNodeVo> setAddNodes, BpmnStartConditionsVo bpmnStartConditions) {
        if (itsAggregationNode == null) {
            throw new AFBizException("there is a parallel gateway node,but can not get its aggregation node!");
        }
        String aggregationNodeNodeId = itsAggregationNode.getNodeId();
        List nodeTos = outerMostParallelGatewayNode.getNodeTo();
        for (String nodeTo : nodeTos) {
            BpmnNodeVo currentNodeVo;
            BpmnNodeVo nodeVo = currentNodeVo = mapNodes.get(nodeTo);
            while (nodeVo != null && !nodeVo.getNodeId().equals(aggregationNodeNodeId)) {
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nodeVo.getNodeType())) {
                    BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nodeVo, mapNodes.values());
                    this.treatParallelGateWayRecursively(nodeVo, aggregationNode, mapNodes, setAddNodes, bpmnStartConditions);
                }
                String nextId = nodeVo.getParams().getNodeTo();
                this.processAssigneeNode(nodeVo, mapNodes, setAddNodes, nextId, bpmnStartConditions);
                nodeVo = mapNodes.get(nodeVo.getParams().getNodeTo());
            }
        }
    }

    private void processAssigneeNode(BpmnNodeVo base, Map<String, BpmnNodeVo> mapPreNodes, HashSet<BpmnNodeVo> setAddNodes, String nextId, BpmnStartConditionsVo bpmnStartConditions) {
        if (base.getNodeType().equals(NodeTypeEnum.NODE_TYPE_APPROVER.getCode()) || base.getNodeType().equals(NodeTypeEnum.NODE_TYPE_COPY.getCode())) {
            BpmnNodeParamsVo paramsVo = base.getParams();
            if (1 == base.getNodeProperty()) {
                throw new AFBizException("the assignee node has no property,can not go on");
            }
            Integer nodeProperty = base.getNodeProperty();
            NodePropertyEnum nodePropertyEnum = NodePropertyEnum.getByCode((Integer)nodeProperty);
            if (nodePropertyEnum == null) {
                throw new AFBizException("node property is undefined!");
            }
            BpmnNodeParamTypeEnum paramTypeEnum = nodePropertyEnum.getParamTypeEnum();
            PersonnelEnum personnelEnum = PersonnelEnum.fromNodePropertyEnum((NodePropertyEnum)nodePropertyEnum);
            AbstractBpmnPersonnelAdaptor personnelAdaptor = null;
            Collection abstractBpmnPersonnelAdaptors = SpringBeanUtils.getBeans(AbstractBpmnPersonnelAdaptor.class);
            for (AbstractBpmnPersonnelAdaptor abstractBpmnPersonnelAdaptor : abstractBpmnPersonnelAdaptors) {
                if (!abstractBpmnPersonnelAdaptor.isSupportBusinessObject((Enum)personnelEnum)) continue;
                personnelAdaptor = abstractBpmnPersonnelAdaptor;
                break;
            }
            if (personnelAdaptor == null) {
                throw new AFBizException("can not find personnel adaptor by given node property");
            }
            personnelAdaptor.setNodeParams(base, bpmnStartConditions, paramTypeEnum, nextId, mapPreNodes, setAddNodes);
        }
    }
}

