/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.service;

import com.alibaba.fastjson2.JSON;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ConditionService;
import org.openoa.base.util.BpmnUtils;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnNodeParamsVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class ConditionFilterService {
    private static final Logger log = LoggerFactory.getLogger(ConditionFilterService.class);
    @Autowired
    private ConditionService conditionService;

    public void conditionfilterNode(BpmnConfVo bpmnConfVo, BpmnStartConditionsVo bpmnStartConditionsVo) {
        List nodeList = bpmnConfVo.getNodes();
        if (CollectionUtils.isEmpty((Collection)nodeList)) {
            log.warn("bpmn conf has no nodes");
            return;
        }
        HashMap<String, BpmnNodeVo> nodeIdMapNode = new HashMap<String, BpmnNodeVo>(16);
        BpmnNodeVo startNode = this.getNodeMapAndStartNode(nodeList, nodeIdMapNode);
        if (startNode == null) {
            log.info("process has no start user,bpmnCode:{}", (Object)bpmnConfVo.getBpmnCode());
            throw new AFBizException("999", "process has no start user");
        }
        List<BpmnNodeVo> filterNodes = this.filterNode(startNode, nodeIdMapNode, bpmnStartConditionsVo);
        bpmnConfVo.setNodes(filterNodes);
    }

    private BpmnNodeVo getNodeMapAndStartNode(List<BpmnNodeVo> nodeList, Map<String, BpmnNodeVo> nodeIdMapNode) {
        BpmnNodeVo startNode = null;
        for (BpmnNodeVo bpmnNodeVo : nodeList) {
            nodeIdMapNode.put(bpmnNodeVo.getNodeId(), bpmnNodeVo);
            if (!NodeTypeEnum.NODE_TYPE_START.getCode().equals(bpmnNodeVo.getNodeType())) continue;
            if (startNode == null) {
                startNode = bpmnNodeVo;
                continue;
            }
            log.info("multiple start user,nodeId:{}", (Object)bpmnNodeVo.getNodeId());
            throw new AFBizException("999", "process has multiple start user");
        }
        return startNode;
    }

    private List<BpmnNodeVo> filterNode(BpmnNodeVo startNode, Map<String, BpmnNodeVo> nodeIdMapNode, BpmnStartConditionsVo bpmnStartConditionsVo) {
        ArrayList<BpmnNodeVo> nodeList = new ArrayList<BpmnNodeVo>();
        BpmnNodeParamsVo params = new BpmnNodeParamsVo();
        params.setNodeTo((String)startNode.getNodeTo().get(0));
        startNode.setParams(params);
        String nextId = params.getNodeTo();
        do {
            if (NodeTypeEnum.NODE_TYPE_GATEWAY.getCode().equals(startNode.getNodeType()) && Boolean.TRUE.equals(startNode.getIsParallel())) {
                this.parallelTreate(startNode, nodeIdMapNode, nodeList, bpmnStartConditionsVo);
            }
            if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(startNode.getNodeType())) {
                BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)startNode, nodeIdMapNode.values());
                this.treatParallelGateWayRecursively(startNode, aggregationNode, nodeIdMapNode, nodeList, bpmnStartConditionsVo);
                nextId = aggregationNode.getNodeId();
            } else {
                this.recursionTreate(startNode, nodeIdMapNode, nodeList, bpmnStartConditionsVo);
                nextId = startNode.getParams().getNodeTo();
            }
            startNode = nodeIdMapNode.get(nextId);
        } while (!Strings.isNullOrEmpty((String)nextId));
        List<BpmnNodeVo> list = this.deleteConditionNode(nodeList);
        this.checkNode(list);
        return list;
    }

    private void treatParallelGateWayRecursively(BpmnNodeVo outerMostParallelGatewayNode, BpmnNodeVo itsAggregationNode, Map<String, BpmnNodeVo> nodeIdMapNode, List<BpmnNodeVo> nodeList, BpmnStartConditionsVo bpmnStartConditionsVo) {
        if (itsAggregationNode == null) {
            throw new AFBizException("there is a parallel gateway node,but can not get its aggregation node!");
        }
        this.recursionTreate(outerMostParallelGatewayNode, nodeIdMapNode, nodeList, bpmnStartConditionsVo);
        String aggregationNodeNodeId = itsAggregationNode.getNodeId();
        List nodeTos = outerMostParallelGatewayNode.getNodeTo();
        for (String nodeTo : nodeTos) {
            BpmnNodeVo currentNodeVo;
            BpmnNodeVo nodeVo = currentNodeVo = nodeIdMapNode.get(nodeTo);
            while (nodeVo != null && !nodeVo.getNodeId().equals(aggregationNodeNodeId)) {
                if (NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(nodeVo.getNodeType())) {
                    BpmnNodeVo aggregationNode = BpmnUtils.getAggregationNode((BpmnNodeVo)nodeVo, nodeIdMapNode.values());
                    this.treatParallelGateWayRecursively(nodeVo, aggregationNode, nodeIdMapNode, nodeList, bpmnStartConditionsVo);
                } else {
                    this.recursionTreate(nodeVo, nodeIdMapNode, nodeList, bpmnStartConditionsVo);
                }
                nodeVo = nodeIdMapNode.get(nodeVo.getParams().getNodeTo());
            }
        }
    }

    private void checkNode(List<BpmnNodeVo> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        int nodeCustomize = 0;
        for (BpmnNodeVo bpmnNodeVo : list) {
            if (!NodeTypeEnum.NODE_TYPE_APPROVER.getCode().equals(bpmnNodeVo.getNodeType()) || !NodePropertyEnum.NODE_PROPERTY_CUSTOMIZE.getCode().equals(bpmnNodeVo.getNodeProperty())) continue;
            ++nodeCustomize;
        }
    }

    private void recursionTreate(BpmnNodeVo node, Map<String, BpmnNodeVo> nodeIdMapNode, List<BpmnNodeVo> filterNodeList, BpmnStartConditionsVo bpmnStartConditionsVo) {
        if (CollectionUtils.isEmpty((Collection)node.getNodeTo())) {
            node.setParams(BpmnNodeParamsVo.builder().build());
            filterNodeList.add(node);
            return;
        }
        if (filterNodeList.size() > nodeIdMapNode.size()) {
            log.info("nodeId error,nodeMap:{}", (Object)JSON.toJSONString(nodeIdMapNode));
            throw new AFBizException("999", "Node's nodeId config error");
        }
        BpmnNodeVo nextNode = null;
        BpmnNodeParamsVo params = new BpmnNodeParamsVo();
        if (!NodeTypeEnum.NODE_TYPE_GATEWAY.getCode().equals(node.getNodeType())) {
            BpmnNodeVo next = nodeIdMapNode.get(node.getNodeTo().get(0));
            if (next == null) {
                log.error("can not find out process's next node,nodeId:{},nextNodeId:{}", (Object)node.getNodeId(), node.getNodeTo().get(0));
                throw new AFBizException("999", "can not find out process's next node");
            }
            params.setNodeTo(CollectionUtils.isEmpty((Collection)node.getNodeTo()) ? null : (String)node.getNodeTo().get(0));
            node.setParams(params);
            filterNodeList.add(node);
            nextNode = next;
        } else {
            ArrayList<BpmnNodeVo> beforeFilterNodeList = new ArrayList<BpmnNodeVo>();
            node.getNodeTo().forEach(o -> beforeFilterNodeList.add((BpmnNodeVo)nodeIdMapNode.get(o)));
            if (beforeFilterNodeList.size() != node.getNodeTo().size()) {
                log.info("wrong number of conditions node,nodeId:{}", (Object)node.getNodeId());
                throw new AFBizException("999", "wrong number of conditions node,nodeId");
            }
            boolean isDynamicConditionGateway = Boolean.TRUE.equals(node.getIsDynamicCondition());
            BpmnNodeVo afterFilterNode = this.filterCondition(beforeFilterNodeList, bpmnStartConditionsVo, isDynamicConditionGateway);
            if (afterFilterNode == null) {
                throw new AFBizException("999", "had no branch that meet the given condition,please contat the Administrator\uff01");
            }
            params.setNodeTo(afterFilterNode.getNodeId());
            node.setParams(params);
            filterNodeList.add(node);
            nextNode = afterFilterNode;
        }
    }

    private void parallelTreate(BpmnNodeVo node, Map<String, BpmnNodeVo> nodeIdMapNode, List<BpmnNodeVo> filterNodeList, BpmnStartConditionsVo bpmnStartConditionsVo) {
        ArrayList<BpmnNodeVo> beforeFilterNodeList = new ArrayList<BpmnNodeVo>();
        node.getNodeTo().forEach(o -> beforeFilterNodeList.add((BpmnNodeVo)nodeIdMapNode.get(o)));
        if (beforeFilterNodeList.size() != node.getNodeTo().size()) {
            log.info("wrong number of conditions node,nodeId:{}", (Object)node.getNodeId());
            throw new AFBizException("999", "wrong number of conditions node,nodeId");
        }
        List<BpmnNodeVo> afterFilterNodes = this.filterParallelCondition(beforeFilterNodeList, bpmnStartConditionsVo);
        if (CollectionUtils.isEmpty(afterFilterNodes)) {
            throw new AFBizException("999", "had no branch that meet the given condition,please contat the Administrator\uff01");
        }
        ArrayList nodetos = new ArrayList();
        for (BpmnNodeVo afterFilterNode : afterFilterNodes) {
            List nodeTo = afterFilterNode.getNodeTo();
            if (CollectionUtils.isEmpty((Collection)nodeTo)) continue;
            nodetos.add(nodeTo.get(0));
        }
        node.setNodeTo(nodetos);
        node.setNodeType(NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode());
    }

    private BpmnNodeVo filterCondition(List<BpmnNodeVo> beforeFilterNodeList, BpmnStartConditionsVo bpmnStartConditionsVo, boolean isDynamicConditionGateway) {
        if (CollectionUtils.isEmpty(beforeFilterNodeList)) {
            log.info("condition nodes are empty");
            return null;
        }
        List filterNodeList = beforeFilterNodeList.stream().filter(o -> o.getProperty().getConditionsConf().getIsDefault() == 0 && !ObjectUtils.isEmpty((Object)o.getProperty().getConditionsConf().getSort())).sorted(Comparator.comparing(o -> o.getProperty().getConditionsConf().getSort())).collect(Collectors.toList());
        for (BpmnNodeVo bpmnNodeVo : filterNodeList) {
            if (!NodeTypeEnum.NODE_TYPE_CONDITIONS.getCode().equals(bpmnNodeVo.getNodeType())) {
                log.info("gateway's next node,but not a condition node,continue,nodeId:{},nodeType:{}", (Object)bpmnNodeVo.getNodeId(), (Object)bpmnNodeVo.getNodeType());
                continue;
            }
            boolean matchCondition = this.conditionService.checkMatchCondition(bpmnNodeVo, bpmnNodeVo.getProperty().getConditionsConf(), bpmnStartConditionsVo, isDynamicConditionGateway);
            if (!matchCondition) continue;
            return bpmnNodeVo;
        }
        List defaultConditionNodes = beforeFilterNodeList.stream().filter(o -> o.getProperty().getConditionsConf().getIsDefault() == 1).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(defaultConditionNodes)) {
            return (BpmnNodeVo)defaultConditionNodes.get(0);
        }
        return null;
    }

    private List<BpmnNodeVo> filterParallelCondition(List<BpmnNodeVo> beforeFilterNodeList, BpmnStartConditionsVo bpmnStartConditionsVo) {
        if (CollectionUtils.isEmpty(beforeFilterNodeList)) {
            log.info("condition nodes are empty");
            return null;
        }
        List filterNodeList = beforeFilterNodeList.stream().filter(o -> o.getProperty().getConditionsConf().getIsDefault() == 0 && !ObjectUtils.isEmpty((Object)o.getProperty().getConditionsConf().getSort())).sorted(Comparator.comparing(o -> o.getProperty().getConditionsConf().getSort())).collect(Collectors.toList());
        ArrayList<BpmnNodeVo> filteredNodes = new ArrayList<BpmnNodeVo>();
        for (BpmnNodeVo bpmnNodeVo : filterNodeList) {
            if (!NodeTypeEnum.NODE_TYPE_CONDITIONS.getCode().equals(bpmnNodeVo.getNodeType())) {
                log.info("gateway's next node,but not a condition node,continue,nodeId:{},nodeType:{}", (Object)bpmnNodeVo.getNodeId(), (Object)bpmnNodeVo.getNodeType());
                continue;
            }
            boolean matchCondition = this.conditionService.checkMatchCondition(bpmnNodeVo, bpmnNodeVo.getProperty().getConditionsConf(), bpmnStartConditionsVo, false);
            if (!matchCondition) continue;
            filteredNodes.add(bpmnNodeVo);
        }
        if (!CollectionUtils.isEmpty(filteredNodes)) {
            return filteredNodes;
        }
        List<BpmnNodeVo> defaultConditionNodes = beforeFilterNodeList.stream().filter(o -> o.getProperty().getConditionsConf().getIsDefault() == 1).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(defaultConditionNodes)) {
            return defaultConditionNodes;
        }
        return null;
    }

    private List<BpmnNodeVo> deleteConditionNode(List<BpmnNodeVo> nodeList) {
        LinkedHashMap<String, BpmnNodeVo> notConditionNodeMap = new LinkedHashMap<String, BpmnNodeVo>();
        HashMap<String, BpmnNodeVo> conditionNodeMap = new HashMap<String, BpmnNodeVo>(16);
        nodeList.forEach(o -> {
            if (NodeTypeEnum.NODE_TYPE_GATEWAY.getCode().equals(o.getNodeType()) || NodeTypeEnum.NODE_TYPE_CONDITIONS.getCode().equals(o.getNodeType())) {
                conditionNodeMap.put(o.getNodeId(), (BpmnNodeVo)o);
            } else {
                notConditionNodeMap.put(o.getNodeId(), (BpmnNodeVo)o);
            }
        });
        ArrayList<BpmnNodeVo> resultList = new ArrayList<BpmnNodeVo>();
        for (Map.Entry entry : notConditionNodeMap.entrySet()) {
            String nextNodeId = ((BpmnNodeVo)entry.getValue()).getParams().getNodeTo();
            if (StringUtils.isBlank((CharSequence)nextNodeId)) {
                resultList.add((BpmnNodeVo)entry.getValue());
                continue;
            }
            if (!notConditionNodeMap.containsKey(nextNodeId)) {
                BpmnNodeVo bpmnNodeVo;
                String resultNodeId = this.findNext(nextNodeId, new ArrayList<String>(), notConditionNodeMap, conditionNodeMap);
                if (StringUtils.isNotBlank((CharSequence)resultNodeId) && !StringUtils.isEmpty((CharSequence)(bpmnNodeVo = (BpmnNodeVo)notConditionNodeMap.get(resultNodeId)).getNodeFrom()) && notConditionNodeMap.get(bpmnNodeVo.getNodeFrom()) != null && !NodeTypeEnum.NODE_TYPE_PARALLEL_GATEWAY.getCode().equals(((BpmnNodeVo)notConditionNodeMap.get(bpmnNodeVo.getNodeFrom())).getNodeType())) {
                    bpmnNodeVo.setNodeFrom(((BpmnNodeVo)entry.getValue()).getNodeId());
                }
                ((BpmnNodeVo)entry.getValue()).setNodeTo((List)Lists.newArrayList((Object[])new String[]{resultNodeId}));
                ((BpmnNodeVo)entry.getValue()).getParams().setNodeTo(resultNodeId);
            }
            resultList.add((BpmnNodeVo)entry.getValue());
        }
        return resultList;
    }

    private String findNext(String nodeId, List<String> addNodeIdList, Map<String, BpmnNodeVo> notConditionNodeMap, Map<String, BpmnNodeVo> conditionNodeMap) {
        if (notConditionNodeMap.containsKey(nodeId) || StringUtils.isBlank((CharSequence)nodeId)) {
            return nodeId;
        }
        if (addNodeIdList.contains(nodeId)) {
            log.info("node id forms a cycle,nodeId:{}", (Object)nodeId);
            throw new AFBizException("999", "node id forms a cycle");
        }
        BpmnNodeVo bpmnNodeVo = conditionNodeMap.get(nodeId);
        if (bpmnNodeVo == null) {
            log.info("has no node id,nodeId:{}", (Object)nodeId);
            throw new AFBizException("999", "has no node id");
        }
        addNodeIdList.add(nodeId);
        return this.findNext(bpmnNodeVo.getParams().getNodeTo(), addNodeIdList, notConditionNodeMap, conditionNodeMap);
    }
}

