/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.service;

import java.util.Map;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.openoa.base.constant.enums.ElementTypeEnum;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.BpmnConfCommonVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.actflowmodel.BpmnFlowDesigner;
import org.openoa.common.adaptor.bpmnelementadp.BpmnAddFlowElementAdaptor;
import org.openoa.common.constant.enus.ElementPropertyEnum;
import org.openoa.common.util.BpmnBuildUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ProcessModelServiceImpl {
    public void execute(BpmnConfCommonVo bpmnConfCommonVo, BpmnStartConditionsVo bpmnStartConditions, Map<String, Object> startParamMap, BpmnModel model) {
        Process process = new Process();
        model.addProcess(process);
        process.setId(bpmnConfCommonVo.getProcessNum());
        process.setName(bpmnConfCommonVo.getProcessName());
        for (BpmnConfCommonElementVo elementVo : bpmnConfCommonVo.getElementList()) {
            Integer elementType = elementVo.getElementType();
            Integer elementProperty = elementVo.getElementProperty();
            if (elementType.equals(ElementTypeEnum.ELEMENT_TYPE_START_EVENT.getCode())) {
                process.addFlowElement((FlowElement)BpmnBuildUtils.createStartEvent(elementVo.getElementId(), elementVo.getElementName()));
                continue;
            }
            if (elementType.equals(ElementTypeEnum.ELEMENT_TYPE_END_EVENT.getCode())) {
                process.addFlowElement((FlowElement)BpmnBuildUtils.createEndEvent(elementVo.getElementId(), elementVo.getElementName()));
                continue;
            }
            if (elementType.equals(ElementTypeEnum.ELEMENT_TYPE_USER_TASK.getCode())) {
                BpmnAddFlowElementAdaptor bean = (BpmnAddFlowElementAdaptor)SpringBeanUtils.getBean(ElementPropertyEnum.getClsByCode(elementProperty));
                if (ObjectUtils.isEmpty((Object)bean)) continue;
                bean.addFlowElement(elementVo, process, startParamMap, bpmnStartConditions);
                continue;
            }
            if (elementType.equals(ElementTypeEnum.ELEMENT_TYPE_SEQUENCE_FLOW.getCode())) {
                process.addFlowElement((FlowElement)BpmnBuildUtils.createSequenceFlow(elementVo));
                continue;
            }
            if (!elementType.equals(ElementTypeEnum.ELEMENT_TYPE_PARALLEL_GATEWAY.getCode())) continue;
            process.addFlowElement((FlowElement)BpmnBuildUtils.createParallelGateWay(elementVo.getElementId()));
        }
        new BpmnFlowDesigner(model).execute();
    }
}

