/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.util;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.AFSpecialAssigneeEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodeParamsAssigneeVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AssigneeVoBuildUtils {
    private static final Logger log = LoggerFactory.getLogger(AssigneeVoBuildUtils.class);
    @Autowired
    private BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService;

    public List<BpmnNodeParamsAssigneeVo> buildVOs(Collection<BaseIdTranStruVo> assigneeInfos, String nodeName, boolean hasSufix) {
        if (Strings.isNullOrEmpty((String)nodeName)) {
            nodeName = "\u5c42\u5c42\u5ba1\u6279";
        }
        ArrayList<BpmnNodeParamsAssigneeVo> assigneeVos = new ArrayList<BpmnNodeParamsAssigneeVo>();
        int index = 0;
        for (BaseIdTranStruVo assigneeInfo : assigneeInfos) {
            String nameSufix = String.format("_%s", ++index);
            BpmnNodeParamsAssigneeVo bpmnNodeParamsAssigneeVo = new BpmnNodeParamsAssigneeVo();
            bpmnNodeParamsAssigneeVo.setAssignee(assigneeInfo.getId());
            bpmnNodeParamsAssigneeVo.setAssigneeName(assigneeInfo.getName());
            String formattedName = nodeName;
            if (hasSufix) {
                formattedName = formattedName + nameSufix;
            }
            bpmnNodeParamsAssigneeVo.setElementName(formattedName);
            assigneeVos.add(bpmnNodeParamsAssigneeVo);
        }
        return assigneeVos;
    }

    public List<BpmnNodeParamsAssigneeVo> buildVos(Collection<String> assignees, String nodeName, boolean hasSufix) {
        ArrayList<BaseIdTranStruVo> assigneeInfos = new ArrayList<BaseIdTranStruVo>();
        Map employeeInfo = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo(assignees);
        if (CollectionUtils.isEmpty((Map)employeeInfo)) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u6307\u5b9aid\u627e\u5230\u4eba\u5458\u4fe1\u606f!");
        }
        for (String assignee : assignees) {
            BaseIdTranStruVo baseIdTranStruVo = new BaseIdTranStruVo();
            String assigneeName = (String)employeeInfo.get(assignee);
            if (StringUtils.isEmpty((CharSequence)assigneeName)) {
                log.warn("can not get employee name by its id:{},maybe it is invalid", (Object)assignee);
                continue;
            }
            baseIdTranStruVo.setId(assignee);
            baseIdTranStruVo.setName(assigneeName);
            assigneeInfos.add(baseIdTranStruVo);
        }
        return this.buildVOs(assigneeInfos, nodeName, hasSufix);
    }

    public BpmnNodeParamsAssigneeVo buildVo(String assignee, String nodeName) {
        Map employeeInfo = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo((Collection)Lists.newArrayList((Object[])new String[]{assignee}));
        if (CollectionUtils.isEmpty((Map)employeeInfo)) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u6307\u5b9aid\u627e\u5230\u4eba\u5458\u4fe1\u606f!");
        }
        BpmnNodeParamsAssigneeVo bpmnNodeParamsAssigneeVo = new BpmnNodeParamsAssigneeVo();
        bpmnNodeParamsAssigneeVo.setAssignee(assignee);
        String assigneeName = (String)employeeInfo.get(assignee);
        bpmnNodeParamsAssigneeVo.setAssigneeName(assigneeName);
        bpmnNodeParamsAssigneeVo.setElementName(nodeName);
        return bpmnNodeParamsAssigneeVo;
    }

    public BpmnNodeParamsAssigneeVo buildZeroVo() {
        return BpmnNodeParamsAssigneeVo.builder().assignee(AFSpecialAssigneeEnum.TO_BE_REMOVED.getId()).isDeduplication(Integer.valueOf(0)).build();
    }
}

