/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.common.util;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ElementTypeEnum;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.common.constant.enus.ElementPropertyEnum;

public class BpmnElementUtils {
    private static final String sequenceFlowPrefix = "sequenceFlow";
    private static final String gateWayPrefix = "gateWay";

    public static BpmnConfCommonElementVo getStartEventElement(String elementId) {
        return BpmnConfCommonElementVo.builder().elementId(elementId).elementName(ElementTypeEnum.ELEMENT_TYPE_START_EVENT.getDesc()).elementType(ElementTypeEnum.ELEMENT_TYPE_START_EVENT.getCode()).build();
    }

    public static BpmnConfCommonElementVo getEndEventElement(String elementId) {
        return BpmnConfCommonElementVo.builder().elementId(elementId).elementName(ElementTypeEnum.ELEMENT_TYPE_END_EVENT.getDesc()).elementType(ElementTypeEnum.ELEMENT_TYPE_END_EVENT.getCode()).build();
    }

    public static BpmnConfCommonElementVo getSingleElement(String elementId, String elementName, String assigneeParamName, String assigneeParamValue, Map<String, String> assigneeMap) {
        return BpmnConfCommonElementVo.builder().elementId(elementId).elementName(elementName).elementType(ElementTypeEnum.ELEMENT_TYPE_USER_TASK.getCode()).elementProperty(ElementPropertyEnum.ELEMENT_PROPERTY_SINGLE.getCode()).assigneeParamName(assigneeParamName).assigneeParamValue(assigneeParamValue).assigneeMap(assigneeMap).build();
    }

    public static BpmnConfCommonElementVo getMultiplayerSignElement(String elementId, String elementName, String collectionName, List<String> collectionValue, Map<String, String> assigneeMap) {
        return BpmnConfCommonElementVo.builder().elementId(elementId).elementName(elementName).elementType(ElementTypeEnum.ELEMENT_TYPE_USER_TASK.getCode()).elementProperty(ElementPropertyEnum.ELEMENT_PROPERTY_MULTIPLAYER_SIGN.getCode()).collectionName(collectionName).collectionValue(collectionValue).assigneeMap(assigneeMap).build();
    }

    public static BpmnConfCommonElementVo getMultiplayerSignInOrderElement(String elementId, String elementName, String collectionName, List<String> collectionValue, Map<String, String> assigneeMap) {
        return BpmnConfCommonElementVo.builder().elementId(elementId).elementName(elementName).elementType(ElementTypeEnum.ELEMENT_TYPE_USER_TASK.getCode()).elementProperty(ElementPropertyEnum.ELEMENT_PROPERTY_MULTIPLAYER_SIGN_IN_ORDER.getCode()).collectionName(collectionName).collectionValue(collectionValue).assigneeMap(assigneeMap).build();
    }

    public static BpmnConfCommonElementVo getMultiplayerOrSignElement(String elementId, String elementName, String collectionName, List<String> collectionValue, Map<String, String> assigneeMap) {
        return BpmnConfCommonElementVo.builder().elementId(elementId).elementName(elementName).elementType(ElementTypeEnum.ELEMENT_TYPE_USER_TASK.getCode()).elementProperty(ElementPropertyEnum.ELEMENT_PROPERTY_MULTIPLAYER_ORSIGN.getCode()).collectionName(collectionName).collectionValue(collectionValue).assigneeMap(assigneeMap).build();
    }

    public static BpmnConfCommonElementVo getSignUpElement(String elementId, BpmnConfCommonElementVo fatherElementVo, Integer elementProperty) {
        return BpmnConfCommonElementVo.builder().elementId(elementId).elementName(StringUtils.join((Object[])new String[]{fatherElementVo.getElementName(), "\u52a0\u6279"})).elementType(ElementTypeEnum.ELEMENT_TYPE_USER_TASK.getCode()).elementProperty(elementProperty).collectionName(StringUtils.join((Object[])new String[]{elementId, "signUpUserList"})).collectionValue((List)Lists.newArrayList()).build();
    }

    public static BpmnConfCommonElementVo getSequenceFlow(Integer sequenceFlowNum, String flowFrom, String flowTo) {
        return BpmnConfCommonElementVo.builder().elementId(StringUtils.join((Object[])new Serializable[]{sequenceFlowPrefix, sequenceFlowNum})).elementName(StringUtils.join((Object[])new Serializable[]{sequenceFlowPrefix, sequenceFlowNum})).elementType(ElementTypeEnum.ELEMENT_TYPE_SEQUENCE_FLOW.getCode()).elementProperty(ElementPropertyEnum.ELEMENT_PROPERTY_SEQUENCE_FLOW.getCode()).flowFrom(flowFrom).flowTo(flowTo).build();
    }

    public static BpmnConfCommonElementVo getParallelGateWayElement(Integer sequenceFlowNum) {
        return BpmnConfCommonElementVo.builder().elementId(StringUtils.join((Object[])new Serializable[]{gateWayPrefix, sequenceFlowNum})).elementName(StringUtils.join((Object[])new Serializable[]{gateWayPrefix, sequenceFlowNum})).elementType(ElementTypeEnum.ELEMENT_TYPE_PARALLEL_GATEWAY.getCode()).elementProperty(ElementPropertyEnum.ELEMENT_PROPERTY_PARALLEL_GATEWAY.getCode()).build();
    }
}

