/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.activitilistener;

import org.openoa.base.constant.enums.CallbackTypeEnum;
import org.openoa.base.constant.enums.EventTypeEnum;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.activitilistener.WorkflowButtonHandler;
import org.openoa.engine.bpmnconf.service.biz.BpmVariableMessageListenerServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.ThirdPartyCallBackServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableMessageBizService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AntFlowOperationListener
implements WorkflowButtonHandler {
    @Autowired
    private ThirdPartyCallBackServiceImpl thirdPartyCallBackService;
    @Autowired
    private BpmVariableMessageBizService variableMessageBizService;
    @Autowired
    private BpmVariableMessageListenerServiceImpl bpmVariableMessageListenerService;

    @Override
    public void onSubmit(BusinessDataVo businessData) {
        if (Boolean.TRUE.equals(businessData.getIsOutSideAccessProc())) {
            this.thirdPartyCallBackService.doCallback(CallbackTypeEnum.PROC_STARTED_CALL_BACK, businessData.getBpmnConfVo(), businessData.getProcessNumber(), businessData.getBusinessId(), SecurityUtils.getLogInEmpNameSafe());
        }
        this.variableMessageBizService.sendTemplateMessages(businessData);
    }

    @Override
    public void onResubmit(BusinessDataVo businessData) {
    }

    @Override
    public void onAgree(BusinessDataVo businessData) {
        if (Boolean.TRUE.equals(businessData.getIsOutSideAccessProc())) {
            this.thirdPartyCallBackService.doCallback(CallbackTypeEnum.PROC_COMMIT_CALL_BACK, businessData.getBpmnConfVo(), businessData.getProcessNumber(), businessData.getBusinessId(), SecurityUtils.getLogInEmpNameSafe());
        }
        this.variableMessageBizService.sendTemplateMessages(businessData);
    }

    @Override
    public void onDisAgree(BusinessDataVo businessData) {
        this.bpmVariableMessageListenerService.sendProcessMessages(EventTypeEnum.PROCESS_DISAGREE, businessData);
    }

    @Override
    public void onViewBusinessProcess(BusinessDataVo businessData) {
    }

    @Override
    public void onAbandon(BusinessDataVo businessData) {
        if (Boolean.TRUE.equals(businessData.getIsOutSideAccessProc())) {
            this.thirdPartyCallBackService.doCallback(CallbackTypeEnum.PROC_END_CALL_BACK, businessData.getBpmnConfVo(), businessData.getProcessNumber(), businessData.getBusinessId(), SecurityUtils.getLogInEmpNameSafe());
        }
        this.bpmVariableMessageListenerService.sendProcessMessages(EventTypeEnum.PROCESS_DISAGREE, businessData);
    }

    @Override
    public void onUndertake(BusinessDataVo businessData) {
    }

    @Override
    public void onChangeAssignee(BusinessDataVo businessData) {
    }

    @Override
    public void onStop(BusinessDataVo businessData) {
        this.bpmVariableMessageListenerService.sendProcessMessages(EventTypeEnum.PROCESS_CANCELLATION, businessData);
    }

    @Override
    public void onForward(BusinessDataVo businessData) {
        this.bpmVariableMessageListenerService.sendProcessMessages(EventTypeEnum.PROCESS_FORWARD, businessData);
    }

    @Override
    public void onBackToModify(BusinessDataVo businessData) {
        this.variableMessageBizService.sendTemplateMessages(businessData);
    }

    @Override
    public void onJp(BusinessDataVo businessData) {
        this.variableMessageBizService.sendTemplateMessages(businessData);
    }

    @Override
    public void onZb(BusinessDataVo businessData) {
    }

    @Override
    public void onChooseAssignee(BusinessDataVo businessData) {
    }

    @Override
    public void onBackToAnyNode(BusinessDataVo businessData) {
    }

    @Override
    public void onRemoveAssignee(BusinessDataVo businessData) {
    }

    @Override
    public void onAddAssignee(BusinessDataVo businessData) {
    }

    @Override
    public void onChangeFutureAssignee(BusinessDataVo businessData) {
    }

    @Override
    public void onRemoveFutureAssignee(BusinessDataVo businessData) {
    }

    @Override
    public void onAddFutureAssignee(BusinessDataVo businessData) {
    }

    @Override
    public void onFinishData(BusinessDataVo vo) {
    }
}

