/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.activitilistener;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateExecution;
import org.activiti.engine.delegate.ExecutionListener;
import org.openoa.base.constant.enums.BpmnConfFlagsEnum;
import org.openoa.base.constant.enums.CallbackTypeEnum;
import org.openoa.base.constant.enums.EventTypeEnum;
import org.openoa.base.constant.enums.ProcessNoticeEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmProcessForward;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.vo.ActivitiBpmMsgVo;
import org.openoa.base.vo.BpmVariableMessageVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.mapper.BpmnConfMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmVariableMessageListenerServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.ThirdPartyCallBackServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessForwardServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnConfServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmCallbackUrlConfServiceImpl;
import org.openoa.engine.factory.FormFactory;
import org.openoa.engine.utils.ActivitiTemplateMsgUtils;
import org.openoa.engine.vo.ProcessInforVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class BpmnExecutionListener
implements ExecutionListener {
    private static final Logger log = LoggerFactory.getLogger(BpmnExecutionListener.class);
    @Resource
    private BpmnConfServiceImpl bpmnConfService;
    @Resource
    private ProcessBusinessContans processBusinessContans;
    @Resource
    private BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    @Resource
    private FormFactory formFactory;
    @Resource
    private OutSideBpmCallbackUrlConfServiceImpl outSideBpmCallbackUrlConfService;
    @Resource
    private BpmVariableMessageListenerServiceImpl bpmVariableMessageListenerService;
    @Resource
    private ThirdPartyCallBackServiceImpl thirdPartyCallBackService;
    @Resource
    private BpmProcessForwardServiceImpl bpmProcessForwardService;

    public void notify(DelegateExecution delegateExecution) {
        BpmVariableMessageVo bpmVariableMessageVo;
        String bpmnCode = Optional.ofNullable(delegateExecution.getVariable("bpmnCode")).map(Object::toString).orElse("");
        String processNumber = Optional.ofNullable(delegateExecution.getVariable("processNumber")).map(Object::toString).orElse("");
        String formCode = Optional.ofNullable(delegateExecution.getVariable("formCode")).map(Object::toString).orElse("");
        String businessId = Optional.ofNullable(delegateExecution.getVariable("businessId")).map(Object::toString).orElse("");
        String startUser = Optional.ofNullable(delegateExecution.getVariable("startUser")).map(Object::toString).orElse("");
        BpmnConf bpmnConf = (BpmnConf)((BpmnConfMapper)this.bpmnConfService.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_code", (Object)bpmnCode));
        if (ObjectUtils.isEmpty((Object)bpmnConf)) {
            log.error("global process event listener-bpmnconf is empty\uff0cprocessNumber{}", (Object)processNumber);
            return;
        }
        log.info("execute{}process finished event Listener!", (Object)processNumber);
        boolean isOutside = false;
        if (bpmnConf.getIsOutSideProcess() == 1) {
            isOutside = true;
            BpmnConfVo bpmnConfVo = new BpmnConfVo();
            BeanUtils.copyProperties((Object)bpmnConf, (Object)bpmnConfVo);
            this.thirdPartyCallBackService.doCallback(CallbackTypeEnum.PROC_FINISH_CALL_BACK, bpmnConfVo, processNumber, businessId, "");
        } else {
            BusinessDataVo businessDataVo = new BusinessDataVo();
            businessDataVo.setBusinessId(businessId);
            businessDataVo.setFormCode(formCode);
            if (Objects.equals(bpmnConf.getIsLowCodeFlow(), 1)) {
                businessDataVo.setIsLowCodeFlow(Integer.valueOf(1));
                BpmnConfVo confVo = new BpmnConfVo();
                BeanUtils.copyProperties((Object)bpmnConf, (Object)confVo);
                businessDataVo.setBpmnConfVo(confVo);
            }
            this.formFactory.getFormAdaptor(businessDataVo).finishData(businessDataVo);
        }
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.updateBusinessProcess(BpmBusinessProcess.builder().businessNumber(processNumber).processState(Integer.valueOf(ProcessStateEnum.HANDLED_STATE.getCode())).build());
        if (BpmnConfFlagsEnum.hasFlag((Integer)bpmnConf.getExtraFlags(), (BpmnConfFlagsEnum)BpmnConfFlagsEnum.HAS_LAST_NODE_COPY)) {
            LambdaQueryWrapper qryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmProcessForward::getProcessNumber, (Object)processNumber)).eq(BpmProcessForward::getNodeId, (Object)"af_syslabel_lastnode_copy");
            BpmProcessForward processForward = new BpmProcessForward();
            processForward.setProcessInstanceId(bpmBusinessProcess.getProcInstId());
            processForward.setIsDel(Integer.valueOf(0));
            this.bpmProcessForwardService.update(processForward, (Wrapper)qryWrapper);
        }
        if (this.bpmVariableMessageListenerService.listenerCheckIsSendByTemplate(bpmVariableMessageVo = BpmVariableMessageVo.builder().processNumber(processNumber).formCode(formCode).eventType(EventTypeEnum.PROCESS_END.getCode()).messageType(Integer.valueOf(Boolean.TRUE.equals(EventTypeEnum.PROCESS_END.getIsInNode()) ? 2 : 1)).eventTypeEnum(EventTypeEnum.PROCESS_END).type(Integer.valueOf(1)).build()).booleanValue()) {
            bpmVariableMessageVo.setIsOutside(Boolean.valueOf(isOutside));
            this.bpmVariableMessageListenerService.listenerSendTemplateMessages(bpmVariableMessageVo);
        } else {
            ProcessInforVo processInforVo = ProcessInforVo.builder().processinessKey(bpmnCode).businessNumber(processNumber).formCode(formCode).type(1).build();
            ActivitiTemplateMsgUtils.sendBpmFinishMsg(ActivitiBpmMsgVo.builder().userId(startUser).processId(processNumber).bpmnCode(bpmnCode).formCode(formCode).processType("").processName(bpmnConf.getBpmnName()).emailUrl(this.processBusinessContans.getRoute(ProcessNoticeEnum.EMAIL_TYPE.getCode(), processInforVo, isOutside)).url(this.processBusinessContans.getRoute(ProcessNoticeEnum.EMAIL_TYPE.getCode(), processInforVo, isOutside)).appPushUrl(this.processBusinessContans.getRoute(ProcessNoticeEnum.APP_TYPE.getCode(), processInforVo, isOutside)).taskId(delegateExecution.getProcessInstanceId()).build());
        }
    }
}

