/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.activitilistener;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Resource;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.impl.el.FixedValue;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.EventTypeEnum;
import org.openoa.base.constant.enums.ProcessNodeEnum;
import org.openoa.base.constant.enums.ProcessNoticeEnum;
import org.openoa.base.dto.NodeExtraInfoDTO;
import org.openoa.base.entity.BpmFlowrunEntrust;
import org.openoa.base.entity.BpmProcessForward;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.ActivitiBpmMsgVo;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmVariableMessageVo;
import org.openoa.base.vo.BpmnNodeLabelVO;
import org.openoa.engine.bpmnconf.common.NodeAdditionalInfoServiceImpl;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.mapper.BpmVariableMapper;
import org.openoa.engine.bpmnconf.mapper.BpmnConfMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmVariableMessageListenerServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmFlowrunEntrustServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessForwardServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnConfServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.UserEntrustServiceImpl;
import org.openoa.engine.utils.ActivitiTemplateMsgUtils;
import org.openoa.engine.vo.ProcessInforVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class BpmnTaskListener
implements TaskListener {
    private static final Logger log = LoggerFactory.getLogger(BpmnTaskListener.class);
    private FixedValue extraInfo;
    @Resource
    private BpmnConfServiceImpl bpmnConfService;
    @Resource
    private ProcessBusinessContans processBusinessContans;
    @Resource
    private UserEntrustServiceImpl userEntrustService;
    @Resource
    private BpmFlowrunEntrustServiceImpl bpmFlowrunEntrustService;
    @Resource
    private BpmVariableMessageListenerServiceImpl bpmVariableMessageListenerService;
    @Resource
    private NodeAdditionalInfoServiceImpl nodeAdditionalInfoService;
    @Resource
    private BpmVariableMapper bpmVariableMapper;
    @Resource
    private BpmProcessForwardServiceImpl bpmProcessForwardService;

    public void setExtraInfo(FixedValue extraInfo) {
        this.extraInfo = extraInfo;
    }

    public void notify(DelegateTask delegateTask) {
        BpmVariableMessageVo bpmVariableMessageVo;
        String expressionText;
        if (delegateTask.getTaskDefinitionKey().equals(ProcessNodeEnum.START_TASK_KEY.getDesc())) {
            return;
        }
        String bpmnCode = Optional.ofNullable(delegateTask.getVariable("bpmnCode")).map(Object::toString).orElse("");
        String processNumber = Optional.ofNullable(delegateTask.getVariable("processNumber")).map(Object::toString).orElse("");
        String formCode = Optional.ofNullable(delegateTask.getVariable("formCode")).map(Object::toString).orElse("");
        String businessId = Optional.ofNullable(delegateTask.getVariable("businessId")).map(Object::toString).orElse("");
        String startUser = Optional.ofNullable(delegateTask.getVariable("startUser")).map(Object::toString).orElse("");
        BpmnConf bpmnConf = (BpmnConf)((BpmnConfMapper)this.bpmnConfService.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_code", (Object)bpmnCode));
        if (bpmnConf == null) {
            log.error("Task\u76d1\u542c-\u67e5\u8be2\u6d41\u7a0b\u914d\u7f6e\u6570\u636e\u4e3a\u7a7a\uff0c\u6d41\u7a0b\u7f16\u53f7{}", (Object)processNumber);
            throw new AFBizException("Task\u76d1\u542c-\u67e5\u8be2\u6d41\u7a0b\u914d\u7f6e\u6570\u636e\u4e3a\u7a7a");
        }
        if (this.extraInfo != null && !StringUtils.isEmpty((CharSequence)(expressionText = this.extraInfo.getExpressionText()))) {
            delegateTask.setFormKey(expressionText);
            NodeExtraInfoDTO extraInfoDTO = (NodeExtraInfoDTO)JSON.parseObject((String)expressionText, NodeExtraInfoDTO.class);
            List nodeLabelVOS = extraInfoDTO.getNodeLabelVOS();
            if (!CollectionUtils.isEmpty((Collection)nodeLabelVOS)) {
                for (BpmnNodeLabelVO nodeLabelVO : nodeLabelVOS) {
                    List<String> nodeIdsByeElementId;
                    if (!"af_syslabel_copynode".equals(nodeLabelVO.getLabelValue())) continue;
                    String processInstanceId = delegateTask.getProcessInstanceId();
                    String elementId = delegateTask.getTaskDefinitionKey();
                    if ("af_syslabel_lastnode_copy".equals(elementId) || CollectionUtils.isEmpty(nodeIdsByeElementId = this.bpmVariableMapper.getNodeIdsByeElementId(processNumber, elementId))) continue;
                    String nodeId = nodeIdsByeElementId.get(0);
                    LambdaQueryWrapper qryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmProcessForward::getProcessNumber, (Object)processNumber)).eq(BpmProcessForward::getNodeId, (Object)nodeId);
                    BpmProcessForward processForward = new BpmProcessForward();
                    processForward.setProcessInstanceId(processInstanceId);
                    processForward.setIsDel(Integer.valueOf(0));
                    this.bpmProcessForwardService.update(processForward, (Wrapper)qryWrapper);
                }
            }
        }
        boolean isOutside = Optional.ofNullable(bpmnConf.getIsOutSideProcess()).orElse(0).equals(1);
        String oldUserId = delegateTask.getAssignee();
        String oldUserName = "";
        if (delegateTask instanceof TaskEntity) {
            oldUserName = ((TaskEntity)delegateTask).getAssigneeName();
        }
        BaseIdTranStruVo entrustEmployee = this.userEntrustService.getEntrustEmployee(oldUserId, oldUserName, formCode);
        String userId = entrustEmployee.getId();
        String userName = entrustEmployee.getName();
        if (!StringUtils.isEmpty((CharSequence)userId)) {
            delegateTask.setAssignee(userId);
            if (delegateTask instanceof TaskEntity) {
                ((TaskEntity)delegateTask).setAssigneeName(userName);
            }
        }
        if (!oldUserId.equals(userId)) {
            BpmFlowrunEntrust entrust = new BpmFlowrunEntrust();
            entrust.setType(Integer.valueOf(1));
            entrust.setRuntaskid(delegateTask.getId());
            entrust.setActual(userId);
            entrust.setActualName(userName);
            entrust.setOriginal(oldUserId);
            entrust.setOriginalName(oldUserName);
            entrust.setIsRead(Integer.valueOf(2));
            entrust.setProcDefId(formCode);
            entrust.setRuninfoid(delegateTask.getProcessInstanceId());
            this.bpmFlowrunEntrustService.addFlowrunEntrust(entrust);
            log.info("\u59d4\u6258\u751f\u6548\uff0c\u59d4\u6258\u524d\uff1a{}\uff0c\u59d4\u6258\u540e\uff1b{}", (Object)oldUserId, (Object)userId);
        }
        if (this.bpmVariableMessageListenerService.listenerCheckIsSendByTemplate(bpmVariableMessageVo = BpmVariableMessageVo.builder().processNumber(processNumber).formCode(formCode).eventType(EventTypeEnum.PROCESS_FLOW.getCode()).messageType(Integer.valueOf(Boolean.TRUE.equals(EventTypeEnum.PROCESS_FLOW.getIsInNode()) ? 2 : 1)).elementId(delegateTask.getTaskDefinitionKey()).assignee(delegateTask.getAssignee()).taskId(delegateTask.getId()).eventTypeEnum(EventTypeEnum.PROCESS_FLOW).type(Integer.valueOf(2)).delegateTask(delegateTask).build()).booleanValue()) {
            bpmVariableMessageVo.setIsOutside(Boolean.valueOf(isOutside));
            this.bpmVariableMessageListenerService.listenerSendTemplateMessages(bpmVariableMessageVo);
        } else {
            ProcessInforVo processInforVo = ProcessInforVo.builder().processinessKey(bpmnCode).businessNumber(processNumber).formCode(formCode).type(2).build();
            ActivitiTemplateMsgUtils.sendBpmApprovalMsg(ActivitiBpmMsgVo.builder().userId(delegateTask.getAssignee()).processId(processNumber).bpmnCode(bpmnCode).formCode(formCode).processType("").processName(bpmnConf.getBpmnName()).emailUrl(this.processBusinessContans.getRoute(ProcessNoticeEnum.EMAIL_TYPE.getCode(), processInforVo, isOutside)).url(this.processBusinessContans.getRoute(ProcessNoticeEnum.EMAIL_TYPE.getCode(), processInforVo, isOutside)).appPushUrl(this.processBusinessContans.getRoute(ProcessNoticeEnum.APP_TYPE.getCode(), processInforVo, isOutside)).taskId(delegateTask.getProcessInstanceId()).build());
        }
    }
}

