/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.entity.BpmnNodeBusinessTableConf;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.FieldAttributeInfoVO;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.constant.enus.BusinessConfTableFieldEnum;
import org.openoa.engine.bpmnconf.constant.enus.ConfigurationTableEnum;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeBusinessTableConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NodePropertyBusinessTableAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodePropertyBusinessTableAdp.class);
    @Autowired
    private BpmnNodeBusinessTableConfServiceImpl bpmnNodeBusinessTableConfService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeBusinessTableConf bpmnNodeBusinessTableConf = (BpmnNodeBusinessTableConf)this.bpmnNodeBusinessTableConfService.getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (bpmnNodeBusinessTableConf != null) {
            bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().configurationTableType(bpmnNodeBusinessTableConf.getConfigurationTableType()).tableFieldType(bpmnNodeBusinessTableConf.getTableFieldType()).signType(bpmnNodeBusinessTableConf.getSignType()).build());
        }
        return bpmnNodeVo;
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        PersonnelRuleVO vo = new PersonnelRuleVO();
        vo.setNodePropertyName("\u5173\u8054\u4e1a\u52a1\u8868");
        vo.setNodeProperty(NodePropertyEnum.NODE_PROPERTY_BUSINESSTABLE.getCode());
        FieldAttributeInfoVO tableChoices = new FieldAttributeInfoVO();
        tableChoices.setFieldLabel("\u8bf7\u9009\u62e9\u914d\u7f6e\u8868");
        tableChoices.setFieldName("configurationTableType");
        tableChoices.setSort(Integer.valueOf(1));
        List collect = Arrays.stream(ConfigurationTableEnum.values()).map(a -> BaseIdTranStruVo.builder().id(a.getCode().toString()).name(a.getDesc()).build()).collect(Collectors.toList());
        tableChoices.setValue(collect);
        FieldAttributeInfoVO tableFieldChoice = new FieldAttributeInfoVO();
        tableFieldChoice.setFieldLabel("\u8bf7\u9009\u62e9\u914d\u7f6e\u8868\u5b57\u6bb5");
        tableFieldChoice.setFieldName("tableFieldType");
        tableFieldChoice.setSort(Integer.valueOf(2));
        HashMap choices = new HashMap();
        for (ConfigurationTableEnum value : ConfigurationTableEnum.values()) {
            tableFieldChoice.setFieldLabel(value.getDesc());
            tableFieldChoice.setFieldValue(value.getCode().toString());
            List<BusinessConfTableFieldEnum> tableFields = BusinessConfTableFieldEnum.getByParentTable(value);
            List baseIdTranStruVoList = tableFields.stream().map(a -> BaseIdTranStruVo.builder().id(a.getCode().toString()).name(a.getDesc()).build()).collect(Collectors.toList());
            choices.put(value.getCode().toString(), baseIdTranStruVoList);
        }
        tableFieldChoice.setValue(choices);
        vo.setFieldInfos(Arrays.asList(tableChoices, tableFieldChoice));
        return vo;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo bpmnNodePropertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        BpmnNodeBusinessTableConf bpmnNodeBusinessTableConf = new BpmnNodeBusinessTableConf();
        bpmnNodeBusinessTableConf.setBpmnNodeId(bpmnNodeVo.getId());
        bpmnNodeBusinessTableConf.setConfigurationTableType(bpmnNodePropertysVo.getConfigurationTableType());
        bpmnNodeBusinessTableConf.setTableFieldType(bpmnNodePropertysVo.getTableFieldType());
        bpmnNodeBusinessTableConf.setSignType(bpmnNodePropertysVo.getSignType());
        bpmnNodeBusinessTableConf.setCreateTime(new Date());
        bpmnNodeBusinessTableConf.setCreateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeBusinessTableConf.setUpdateTime(new Date());
        bpmnNodeBusinessTableConf.setUpdateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeBusinessTableConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        this.bpmnNodeBusinessTableConfService.save(bpmnNodeBusinessTableConf);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_BUSINESSTABLE});
    }
}

