/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.openoa.base.entity.BpmnNodeCustomizeConf;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeCustomizeConfServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NodePropertyCustomizeAdp
extends BpmnNodeAdaptor {
    @Autowired
    private BpmnNodeCustomizeConfServiceImpl bpmnNodeCustomizeConfService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        List list = this.bpmnNodeCustomizeConfService.list((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return bpmnNodeVo;
        }
        BpmnNodeCustomizeConf customizeConf = (BpmnNodeCustomizeConf)list.get(0);
        bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().signType(customizeConf.getSignType()).build());
        return bpmnNodeVo;
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        return null;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo bpmnNodePropertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        BpmnNodeCustomizeConf customizeConf = new BpmnNodeCustomizeConf();
        customizeConf.setBpmnNodeId(bpmnNodeVo.getId());
        customizeConf.setSignType(bpmnNodePropertysVo.getSignType());
        customizeConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        this.bpmnNodeCustomizeConfService.save(customizeConf);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_CUSTOMIZE});
    }
}

