/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.openoa.base.constant.enums.FieldValueTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.entity.BpmnNodeHrbpConf;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.FieldAttributeInfoVO;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeHrbpConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NodePropertyHrbpAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodePropertyHrbpAdp.class);
    @Autowired
    private BpmnNodeHrbpConfServiceImpl bpmnNodeHrbpConfService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeHrbpConf bpmnNodeHrbpConf = (BpmnNodeHrbpConf)this.bpmnNodeHrbpConfService.getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (bpmnNodeHrbpConf != null) {
            bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().hrbpConfType(bpmnNodeHrbpConf.getHrbpConfType()).build());
        }
        return bpmnNodeVo;
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        try {
            Class<BpmnNodeHrbpConf> entityCls = BpmnNodeHrbpConf.class;
            PersonnelRuleVO rule = new PersonnelRuleVO();
            NodePropertyEnum nodePropertyHrbp = NodePropertyEnum.NODE_PROPERTY_HRBP;
            rule.setNodeProperty(nodePropertyHrbp.getCode());
            rule.setNodePropertyName(nodePropertyHrbp.getDesc());
            String hrbpConfTypeName = entityCls.getDeclaredField("hrbpConfType").getName();
            FieldAttributeInfoVO vo = new FieldAttributeInfoVO();
            vo.setFieldName(hrbpConfTypeName);
            vo.setFieldLabel("hrbp\u7c7b\u578b");
            vo.setFieldType(FieldValueTypeEnum.NUMBERCHOICE.getDesc());
            ArrayList values = Lists.newArrayList((Object[])new BaseIdTranStruVo[]{new BaseIdTranStruVo("0", "\u8bf7\u9009\u62e9"), new BaseIdTranStruVo("1", "hrbp"), new BaseIdTranStruVo("2", "hrbp leader")});
            vo.setValue((Object)values);
            rule.setFieldInfos((List)Lists.newArrayList((Object[])new FieldAttributeInfoVO[]{vo}));
            return rule;
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo bpmnNodePropertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        BpmnNodeHrbpConf bpmnNodeHrbpConf = new BpmnNodeHrbpConf();
        bpmnNodeHrbpConf.setBpmnNodeId(bpmnNodeVo.getId());
        bpmnNodeHrbpConf.setHrbpConfType(bpmnNodePropertysVo.getHrbpConfType());
        bpmnNodeHrbpConf.setCreateTime(new Date());
        bpmnNodeHrbpConf.setCreateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeHrbpConf.setUpdateTime(new Date());
        bpmnNodeHrbpConf.setUpdateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeHrbpConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        this.bpmnNodeHrbpConfService.save(bpmnNodeHrbpConf);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_HRBP});
    }
}

