/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.openoa.base.constant.enums.FieldValueTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.entity.BpmnNodeAssignLevelConf;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.FieldAttributeInfoVO;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeAssignLevelConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NodePropertyLevelAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodePropertyLevelAdp.class);
    @Autowired
    private BpmnNodeAssignLevelConfServiceImpl bpmnNodeAssignLevelConfService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeAssignLevelConf bpmnNodeAssignLevelConf = (BpmnNodeAssignLevelConf)this.bpmnNodeAssignLevelConfService.getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (bpmnNodeAssignLevelConf != null) {
            bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().assignLevelType(bpmnNodeAssignLevelConf.getAssignLevelType()).assignLevelGrade(bpmnNodeAssignLevelConf.getAssignLevelGrade()).build());
        }
        return bpmnNodeVo;
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        Class<BpmnNodeAssignLevelConf> entityClass = BpmnNodeAssignLevelConf.class;
        PersonnelRuleVO ruleVO = new PersonnelRuleVO();
        NodePropertyEnum nodePropertyLevel = NodePropertyEnum.NODE_PROPERTY_LEVEL;
        ruleVO.setNodeProperty(nodePropertyLevel.getCode());
        ruleVO.setNodePropertyName(nodePropertyLevel.getDesc());
        try {
            String assignLevelType = entityClass.getDeclaredField("assignLevelType").getName();
            FieldAttributeInfoVO vo = new FieldAttributeInfoVO();
            vo.setFieldName(assignLevelType);
            vo.setFieldLabel("\u6307\u5b9a\u5c42\u7ea7");
            vo.setFieldType(FieldValueTypeEnum.NUMBERCHOICE.getDesc());
            ruleVO.setFieldInfos((List)Lists.newArrayList((Object[])new FieldAttributeInfoVO[]{vo}));
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        return ruleVO;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo bpmnNodePropertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        BpmnNodeAssignLevelConf bpmnNodeAssignLevelConf = new BpmnNodeAssignLevelConf();
        bpmnNodeAssignLevelConf.setBpmnNodeId(bpmnNodeVo.getId());
        bpmnNodeAssignLevelConf.setAssignLevelType(bpmnNodePropertysVo.getAssignLevelType());
        bpmnNodeAssignLevelConf.setAssignLevelGrade(Optional.ofNullable(bpmnNodePropertysVo.getAssignLevelGrade()).orElse(0));
        bpmnNodeAssignLevelConf.setCreateTime(new Date());
        bpmnNodeAssignLevelConf.setCreateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeAssignLevelConf.setUpdateTime(new Date());
        bpmnNodeAssignLevelConf.setUpdateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeAssignLevelConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        this.bpmnNodeAssignLevelConfService.save(bpmnNodeAssignLevelConf);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_LEVEL});
    }
}

