/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.FieldValueTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.OrderNodeTypeEnum;
import org.openoa.base.entity.BpmnNodeLoopConf;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.AntCollectionUtil;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.FieldAttributeInfoVO;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeLoopConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NodePropertyLoopAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodePropertyLoopAdp.class);
    @Autowired
    private BpmnNodeLoopConfServiceImpl bpmnNodeLoopConfService;
    @Autowired
    private BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeLoopConf bpmnNodeLoopConf = (BpmnNodeLoopConf)this.bpmnNodeLoopConfService.getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (bpmnNodeLoopConf != null) {
            ArrayList list = !StringUtil.isEmpty((CharSequence)bpmnNodeLoopConf.getLoopEndPerson()) ? Arrays.asList(bpmnNodeLoopConf.getLoopEndPerson().split(",")).stream().map(Long::new).collect(Collectors.toList()) : new ArrayList();
            ArrayList noList = !StringUtil.isEmpty((CharSequence)bpmnNodeLoopConf.getNoparticipatingStaffIds()) ? Arrays.asList(bpmnNodeLoopConf.getNoparticipatingStaffIds().split(",")).stream().map(Long::new).collect(Collectors.toList()) : new ArrayList();
            List loopEndPersonList = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo(AntCollectionUtil.serializeToStringCollection(list)).entrySet().stream().map(a -> BaseIdTranStruVo.builder().id((String)a.getKey()).name((String)a.getValue()).build()).collect(Collectors.toList());
            List noparticipatingStaffs = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo(AntCollectionUtil.serializeToStringCollection(noList)).entrySet().stream().map(a -> BaseIdTranStruVo.builder().id((String)a.getKey()).name((String)a.getValue()).build()).collect(Collectors.toList());
            bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().loopEndType(bpmnNodeLoopConf.getLoopEndType()).loopNumberPlies(bpmnNodeLoopConf.getLoopNumberPlies()).loopEndGrade(bpmnNodeLoopConf.getLoopEndGrade()).loopEndPersonList(list).loopEndPersonObjList(loopEndPersonList).noparticipatingStaffIds(noList).noparticipatingStaffs(noparticipatingStaffs).build());
            bpmnNodeVo.setOrderedNodeType(OrderNodeTypeEnum.LOOP_NODE.getCode());
        }
        return bpmnNodeVo;
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        Class<BpmnNodeLoopConf> entityClass = BpmnNodeLoopConf.class;
        PersonnelRuleVO rule = new PersonnelRuleVO();
        NodePropertyEnum nodePropertyLoop = NodePropertyEnum.NODE_PROPERTY_LOOP;
        rule.setNodeProperty(nodePropertyLoop.getCode());
        rule.setNodePropertyName(nodePropertyLoop.getDesc());
        try {
            String loopNumberPlies = entityClass.getDeclaredField("loopNumberPlies").getName();
            FieldAttributeInfoVO loopNumberPliesVO = new FieldAttributeInfoVO();
            loopNumberPliesVO.setFieldName(loopNumberPlies);
            loopNumberPliesVO.setFieldLabel("\u5c42\u6570");
            loopNumberPliesVO.setFieldType(FieldValueTypeEnum.NUMBERCHOICE.getDesc());
            String loopEndPerson = "loopEndPersonList";
            FieldAttributeInfoVO loopEndPersonVO = new FieldAttributeInfoVO();
            loopEndPersonVO.setFieldName(loopEndPerson);
            loopEndPersonVO.setFieldLabel("\u5c42\u5c42\u5ba1\u6279\u7ed3\u675f\u4eba\u5458");
            loopEndPersonVO.setFieldType(FieldValueTypeEnum.PERSONCHOICE.getDesc());
            String loopEndGrade = entityClass.getDeclaredField("loopEndGrade").getName();
            FieldAttributeInfoVO loopEndGradeVO = new FieldAttributeInfoVO();
            loopEndGradeVO.setFieldName(loopEndGrade);
            loopEndGradeVO.setFieldLabel("\u5c42\u5c42\u5ba1\u6279\u7ed3\u675f\u7b49\u7ea7");
            loopEndGradeVO.setFieldType(FieldValueTypeEnum.NUMBERCHOICE.getDesc());
            rule.setFieldInfos((List)Lists.newArrayList((Object[])new FieldAttributeInfoVO[]{loopNumberPliesVO, loopEndPersonVO, loopEndGradeVO}));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rule;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo bpmnNodePropertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        BpmnNodeLoopConf bpmnNodeLoopConf = new BpmnNodeLoopConf();
        bpmnNodeLoopConf.setBpmnNodeId(bpmnNodeVo.getId());
        bpmnNodeLoopConf.setLoopEndType(bpmnNodePropertysVo.getLoopEndType());
        bpmnNodeLoopConf.setLoopNumberPlies(bpmnNodePropertysVo.getLoopNumberPlies());
        bpmnNodeLoopConf.setLoopEndGrade(bpmnNodePropertysVo.getLoopEndGrade());
        if (!CollectionUtils.isEmpty((Collection)bpmnNodePropertysVo.getLoopEndPersonList())) {
            bpmnNodeLoopConf.setLoopEndPerson(StringUtils.join((Iterable)bpmnNodePropertysVo.getLoopEndPersonList(), (String)","));
        }
        if (!CollectionUtils.isEmpty((Collection)bpmnNodePropertysVo.getNoparticipatingStaffIds())) {
            bpmnNodeLoopConf.setNoparticipatingStaffIds(StringUtils.join((Iterable)bpmnNodePropertysVo.getNoparticipatingStaffIds(), (String)","));
        }
        bpmnNodeLoopConf.setCreateTime(new Date());
        bpmnNodeLoopConf.setCreateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeLoopConf.setUpdateTime(new Date());
        bpmnNodeLoopConf.setUpdateUser(SecurityUtils.getLogInEmpName());
        bpmnNodeLoopConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        this.bpmnNodeLoopConfService.save(bpmnNodeLoopConf);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_LOOP});
    }
}

