/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Optional;
import org.openoa.base.constant.enums.OrderNodeTypeEnum;
import org.openoa.base.entity.BpmnNodeOutSideAccessConf;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeOutSideAccessConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NodePropertyOutSideAccessAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodePropertyOutSideAccessAdp.class);
    @Autowired
    private BpmnNodeOutSideAccessConfServiceImpl bpmnNodeOutSideAccessConfService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeOutSideAccessConf nodeOutSideAccessConf = (BpmnNodeOutSideAccessConf)this.bpmnNodeOutSideAccessConfService.getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (nodeOutSideAccessConf != null) {
            bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().signType(nodeOutSideAccessConf.getSignType()).nodeMark(nodeOutSideAccessConf.getNodeMark()).build());
            bpmnNodeVo.setOrderedNodeType(OrderNodeTypeEnum.OUT_SIDE_NODE.getCode());
        }
        return bpmnNodeVo;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo propertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        this.bpmnNodeOutSideAccessConfService.save(BpmnNodeOutSideAccessConf.builder().bpmnNodeId(bpmnNodeVo.getId()).signType(propertysVo.getSignType()).nodeMark(propertysVo.getNodeMark()).tenantId(MultiTenantUtil.getCurrentTenantId()).build());
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        return null;
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_OUT_SIDE_ACCESS});
    }
}

