/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.FieldValueTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.entity.BpmnNodePersonnelConf;
import org.openoa.base.entity.BpmnNodePersonnelEmplConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.FieldAttributeInfoVO;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.mapper.BpmnNodePersonnelConfMapper;
import org.openoa.engine.bpmnconf.mapper.BpmnNodePersonnelEmplConfMapper;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodePersonnelConfServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodePersonnelEmplConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class NodePropertyPersonnelAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodePropertyPersonnelAdp.class);
    @Autowired
    private BpmnNodePersonnelConfServiceImpl bpmnNodePersonnelConfService;
    @Autowired
    private BpmnNodePersonnelEmplConfServiceImpl bpmnNodePersonnelEmplConfService;
    @Autowired
    private BpmnEmployeeInfoProviderService bpmnEmployeeInfoProviderService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePersonnelConf bpmnNodePersonnelConf = (BpmnNodePersonnelConf)((BpmnNodePersonnelConfMapper)this.bpmnNodePersonnelConfService.getBaseMapper()).selectOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        ArrayList<String> emplIds = new ArrayList<String>();
        ArrayList<String> emplNames = new ArrayList<String>();
        List bpmnNodePersons = ((BpmnNodePersonnelEmplConfMapper)this.bpmnNodePersonnelEmplConfService.getBaseMapper()).selectList((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_personne_id", (Object)bpmnNodePersonnelConf.getId())).stream().distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(bpmnNodePersons)) {
            throw new AFBizException("\u914d\u7f6e\u9519\u8bef\u6216\u8005\u6570\u636e\u88ab\u5220\u9664,\u6307\u5b9a\u5458\u4eba\u5ba1\u6279\u672a\u83b7\u53d6\u5230\u4eba\u5458");
        }
        for (BpmnNodePersonnelEmplConf bpmnNodePerson : bpmnNodePersons) {
            String emplId = bpmnNodePerson.getEmplId();
            String emplName = bpmnNodePerson.getEmplName();
            emplIds.add(emplId);
            if (StringUtils.isEmpty((CharSequence)emplName)) continue;
            emplNames.add(emplName);
        }
        bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().signType(bpmnNodePersonnelConf.getSignType()).emplIds(emplIds).emplList(this.getEmplList(emplIds, emplNames)).build());
        return bpmnNodeVo;
    }

    private List<BaseIdTranStruVo> getEmplList(List<String> emplIds, List<String> emplNames) {
        ArrayList<BaseIdTranStruVo> result = new ArrayList<BaseIdTranStruVo>();
        if (!CollectionUtils.isEmpty(emplNames)) {
            if (emplIds.size() != emplNames.size()) {
                throw new AFBizException("\u6307\u5b9a\u4eba\u5458\u5ba1\u6279\u5b58\u5728\u59d3\u540d\u4e0d\u5b58\u5728\u7684\u4eba\u5458!");
            }
            for (int i = 0; i < emplIds.size(); ++i) {
                BaseIdTranStruVo vo = new BaseIdTranStruVo();
                String emplId = emplIds.get(i);
                String emplName = emplNames.get(i);
                vo.setId(emplId);
                vo.setName(emplName);
                result.add(vo);
            }
            return result;
        }
        Map employeeInfos = this.bpmnEmployeeInfoProviderService.provideEmployeeInfo(emplIds);
        for (String emplId : emplIds) {
            BaseIdTranStruVo vo = new BaseIdTranStruVo();
            vo.setId(emplId);
            String empName = (String)employeeInfos.get(emplId);
            vo.setName(empName);
            result.add(vo);
        }
        return result;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo bpmnNodePropertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        BpmnNodePersonnelConf bpmnNodePersonnelConf = new BpmnNodePersonnelConf();
        bpmnNodePersonnelConf.setBpmnNodeId(Integer.valueOf(bpmnNodeVo.getId().intValue()));
        bpmnNodePersonnelConf.setSignType(bpmnNodePropertysVo.getSignType());
        bpmnNodePersonnelConf.setCreateTime(new Date());
        bpmnNodePersonnelConf.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
        bpmnNodePersonnelConf.setUpdateTime(new Date());
        bpmnNodePersonnelConf.setUpdateUser(SecurityUtils.getLogInEmpNameSafe());
        bpmnNodePersonnelConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        ((BpmnNodePersonnelConfMapper)this.bpmnNodePersonnelConfService.getBaseMapper()).insert(bpmnNodePersonnelConf);
        Integer nodePersonnelId = Optional.of(bpmnNodePersonnelConf.getId()).orElse(0);
        if (ObjectUtils.isEmpty((Object)bpmnNodePropertysVo.getEmplIds())) {
            return;
        }
        ArrayList<BpmnNodePersonnelEmplConf> personnelEmplConfs = new ArrayList<BpmnNodePersonnelEmplConf>();
        List emplList = bpmnNodePropertysVo.getEmplList();
        Map<String, String> id2nameMap = null;
        if (!CollectionUtils.isEmpty((Collection)emplList)) {
            id2nameMap = emplList.stream().collect(Collectors.toMap(a -> a.getId().toString(), BaseIdTranStruVo::getName, (k1, k2) -> k1));
        }
        for (String emplId : bpmnNodePropertysVo.getEmplIds()) {
            BpmnNodePersonnelEmplConf personnelEmplConf = new BpmnNodePersonnelEmplConf();
            personnelEmplConf.setBpmnNodePersonneId(nodePersonnelId);
            personnelEmplConf.setEmplId(emplId);
            personnelEmplConf.setCreateTime(new Date());
            personnelEmplConf.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
            personnelEmplConf.setUpdateUser(SecurityUtils.getLogInEmpNameSafe());
            personnelEmplConf.setUpdateTime(new Date());
            personnelEmplConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
            if (id2nameMap != null && !StringUtils.isEmpty((CharSequence)id2nameMap.get(emplId))) {
                personnelEmplConf.setEmplName(id2nameMap.get(emplId));
            }
            personnelEmplConfs.add(personnelEmplConf);
        }
        this.bpmnNodePersonnelEmplConfService.saveBatch(personnelEmplConfs);
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        Class<BpmnNodePersonnelEmplConf> entityClass = BpmnNodePersonnelEmplConf.class;
        PersonnelRuleVO personnelRuleVO = new PersonnelRuleVO();
        NodePropertyEnum nodePropertyPersonnel = NodePropertyEnum.NODE_PROPERTY_PERSONNEL;
        personnelRuleVO.setNodeProperty(nodePropertyPersonnel.getCode());
        personnelRuleVO.setNodePropertyName(nodePropertyPersonnel.getDesc());
        String fieldName = "emplIds";
        FieldAttributeInfoVO vo = new FieldAttributeInfoVO();
        vo.setFieldName(fieldName);
        vo.setFieldLabel("\u8bf7\u9009\u62e9");
        vo.setFieldType(FieldValueTypeEnum.PERSONCHOICE.getDesc());
        personnelRuleVO.setFieldInfos((List)Lists.newArrayList((Object[])new FieldAttributeInfoVO[]{vo}));
        return personnelRuleVO;
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_PERSONNEL, BpmnNodeAdpConfEnum.ADP_CONF_NODE_TYPE_COPY});
    }
}

