/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.FieldValueTypeEnum;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.entity.BpmnNodeRoleConf;
import org.openoa.base.entity.BpmnNodeRoleOutsideEmpConf;
import org.openoa.base.service.empinfoprovider.BpmnRoleInfoProvider;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.FieldAttributeInfoVO;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeRoleConfServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeRoleOutsideEmpConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class NodePropertyRoleAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodePropertyRoleAdp.class);
    @Autowired
    private BpmnNodeRoleConfServiceImpl bpmnNodeRoleConfService;
    @Autowired
    private BpmnRoleInfoProvider roleInfoProvider;
    @Autowired
    private BpmnNodeRoleOutsideEmpConfServiceImpl bpmnNodeRoleOutsideEmpConfService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        List bpmnNodeRoleOutsideEmpConfs;
        List list = this.bpmnNodeRoleConfService.list((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (CollectionUtils.isEmpty((Collection)list)) {
            return bpmnNodeVo;
        }
        List roles = list.stream().map(conf -> BaseIdTranStruVo.builder().id(conf.getRoleId()).name(conf.getRoleName()).build()).collect(Collectors.toList());
        bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().roleIds(roles.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList())).roleList(roles).signType(((BpmnNodeRoleConf)list.get(0)).getSignType()).build());
        if (bpmnNodeVo.getIsOutSideProcess() != null && bpmnNodeVo.getIsOutSideProcess().equals(1) && !CollectionUtils.isEmpty((Collection)(bpmnNodeRoleOutsideEmpConfs = this.bpmnNodeRoleOutsideEmpConfService.list((Wrapper)new QueryWrapper().eq((Object)"node_id", (Object)bpmnNodeVo.getId()))))) {
            bpmnNodeVo.getProperty().setEmplIds(bpmnNodeRoleOutsideEmpConfs.stream().map(BpmnNodeRoleOutsideEmpConf::getEmplId).collect(Collectors.toList()));
            List emplList = bpmnNodeRoleOutsideEmpConfs.stream().map(a -> BaseIdTranStruVo.builder().id(a.getEmplId()).name(a.getEmplName()).build()).collect(Collectors.toList());
            bpmnNodeVo.getProperty().setEmplList(emplList);
        }
        return bpmnNodeVo;
    }

    private List<BaseIdTranStruVo> getRoleList(List<String> roleIds) {
        if (CollectionUtils.isEmpty(roleIds)) {
            log.info("roIds is empty");
            return Collections.EMPTY_LIST;
        }
        Map roleInfos = this.roleInfoProvider.provideRoleInfo(roleIds);
        if (CollectionUtils.isEmpty((Map)roleInfos)) {
            log.warn("role info is empty,please check you config");
            return Collections.EMPTY_LIST;
        }
        return roleInfos.entrySet().stream().map(e -> BaseIdTranStruVo.builder().id((String)e.getKey()).name((String)e.getValue()).build()).collect(Collectors.toList());
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        PersonnelRuleVO personnelRuleVO = new PersonnelRuleVO();
        NodePropertyEnum nodePropertyRole = NodePropertyEnum.NODE_PROPERTY_ROLE;
        personnelRuleVO.setNodeProperty(nodePropertyRole.getCode());
        personnelRuleVO.setNodePropertyName(nodePropertyRole.getDesc());
        FieldAttributeInfoVO attributeInfo = new FieldAttributeInfoVO();
        attributeInfo.setFieldLabel("\u8bf7\u9009\u62e9\u89d2\u8272");
        attributeInfo.setFieldName("roleIds");
        attributeInfo.setFieldType(FieldValueTypeEnum.ROLECHOICE.getDesc());
        personnelRuleVO.setFieldInfos((List)Lists.newArrayList((Object[])new FieldAttributeInfoVO[]{attributeInfo}));
        return personnelRuleVO;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodePropertysVo bpmnNodePropertysVo = Optional.ofNullable(bpmnNodeVo.getProperty()).orElse(new BpmnNodePropertysVo());
        if (!CollectionUtils.isEmpty((Collection)bpmnNodePropertysVo.getRoleList())) {
            List emplList;
            List roleList = bpmnNodePropertysVo.getRoleList();
            if (!CollectionUtils.isEmpty((Collection)roleList)) {
                this.bpmnNodeRoleConfService.saveBatch(roleList.stream().map(o -> BpmnNodeRoleConf.builder().bpmnNodeId(bpmnNodeVo.getId()).roleId(o.getId()).roleName(o.getName()).signType(bpmnNodePropertysVo.getSignType()).createTime(new Date()).createUser(SecurityUtils.getLogInEmpName()).updateTime(new Date()).updateUser(SecurityUtils.getLogInEmpName()).tenantId(MultiTenantUtil.getCurrentTenantId()).build()).collect(Collectors.toList()));
            }
            if (bpmnNodeVo.getIsOutSideProcess() != null && bpmnNodeVo.getIsOutSideProcess().equals(1) && !CollectionUtils.isEmpty((Collection)(emplList = bpmnNodeVo.getProperty().getEmplList()))) {
                ArrayList<BpmnNodeRoleOutsideEmpConf> bpmnNodeRoleOutsideEmpConfs = new ArrayList<BpmnNodeRoleOutsideEmpConf>();
                for (BaseIdTranStruVo baseIdTranStruVo : emplList) {
                    BpmnNodeRoleOutsideEmpConf bpmnNodeRoleOutsideEmpConf = new BpmnNodeRoleOutsideEmpConf();
                    bpmnNodeRoleOutsideEmpConf.setNodeId(bpmnNodeVo.getId());
                    bpmnNodeRoleOutsideEmpConf.setEmplId(baseIdTranStruVo.getId());
                    bpmnNodeRoleOutsideEmpConf.setEmplName(baseIdTranStruVo.getName());
                    bpmnNodeRoleOutsideEmpConf.setCreateUser(SecurityUtils.getLogInEmpName());
                    bpmnNodeRoleOutsideEmpConf.setUpdateUser(SecurityUtils.getLogInEmpName());
                    bpmnNodeRoleOutsideEmpConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
                    bpmnNodeRoleOutsideEmpConfs.add(bpmnNodeRoleOutsideEmpConf);
                }
                this.bpmnNodeRoleOutsideEmpConfService.saveBatch(bpmnNodeRoleOutsideEmpConfs);
            }
        }
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_PROPERTY_ROLE});
    }
}

