/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.TypeReference;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.openoa.base.constant.enums.ConditionRelationShipEnum;
import org.openoa.base.entity.BpmnNodeConditionsConf;
import org.openoa.base.entity.BpmnNodeConditionsParamConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnNodeConditionsConfBaseVo;
import org.openoa.base.vo.BpmnNodeConditionsConfVueVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.PersonnelRuleVO;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.adp.conditionfilter.nodetypeconditions.BpmnNodeConditionsAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.constant.enus.ConditionTypeEnum;
import org.openoa.engine.bpmnconf.mapper.BpmnConfLfFormdataFieldMapper;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeConditionsConfMapper;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeConditionsParamConfMapper;
import org.openoa.engine.bpmnconf.service.BpmnConfLfFormdataFieldServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeConditionsConfServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeConditionsParamConfServiceImpl;
import org.openoa.engine.utils.BpmnConfNodePropertyConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.ReflectionUtils;

@Component(value="nodeTypeConditionsAdp")
public class NodeTypeConditionsAdp
extends BpmnNodeAdaptor {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeConditionsAdp.class);
    @Autowired
    private BpmnNodeConditionsConfServiceImpl bpmnNodeConditionsConfService;
    @Autowired
    private BpmnNodeConditionsParamConfServiceImpl bpmnNodeConditionsParamConfService;
    @Autowired
    private BpmnNodeConditionsConfMapper confMapper;
    @Autowired
    private BpmnConfLfFormdataFieldServiceImpl lfFormdataFieldService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeConditionsConf bpmnNodeConditionsConf = (BpmnNodeConditionsConf)this.bpmnNodeConditionsConfService.getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        if (ObjectUtils.isEmpty((Object)bpmnNodeConditionsConf)) {
            return bpmnNodeVo;
        }
        String extJson = bpmnNodeConditionsConf.getExtJson();
        List extFieldsGroup = (List)JSON.parseObject((String)extJson, (TypeReference)new TypeReference<List<List<BpmnNodeConditionsConfVueVo>>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
        Map<String, BpmnNodeConditionsConfVueVo> name2confVueMap = extFieldsGroup.stream().flatMap(Collection::stream).collect(Collectors.toMap(a -> a.getColumnDbname() + "_" + a.getCondGroup(), b -> b, (k1, k2) -> k1));
        BpmnNodeConditionsConfBaseVo bpmnNodeConditionsConfBaseVo = new BpmnNodeConditionsConfBaseVo();
        bpmnNodeConditionsConfBaseVo.setIsDefault(bpmnNodeConditionsConf.getIsDefault());
        bpmnNodeConditionsConfBaseVo.setSort(bpmnNodeConditionsConf.getSort());
        bpmnNodeConditionsConfBaseVo.setExtJson(extJson);
        bpmnNodeConditionsConfBaseVo.setGroupRelation(bpmnNodeConditionsConf.getGroupRelation());
        if (Objects.equals(bpmnNodeConditionsConf.getIsDefault(), 1)) {
            this.setProperty(bpmnNodeVo, bpmnNodeConditionsConfBaseVo);
            bpmnNodeVo.getProperty().setIsDefault(bpmnNodeConditionsConf.getIsDefault());
            bpmnNodeVo.getProperty().setSort(bpmnNodeConditionsConf.getSort());
            return bpmnNodeVo;
        }
        List nodeConditionsParamConfs = this.bpmnNodeConditionsParamConfService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(BpmnNodeConditionsParamConf::getBpmnNodeConditionsId, (Object)bpmnNodeConditionsConf.getId())).orderByAsc(BpmnNodeConditionsParamConf::getCondGroup));
        if (!ObjectUtils.isEmpty((Object)nodeConditionsParamConfs)) {
            bpmnNodeConditionsConfBaseVo.setConditionParamTypes(nodeConditionsParamConfs.stream().map(BpmnNodeConditionsParamConf::getConditionParamType).collect(Collectors.toList()));
            bpmnNodeConditionsConfBaseVo.setGroupedConditionParamTypes(nodeConditionsParamConfs.stream().peek(a -> {
                Integer condGroup = a.getCondGroup();
                Integer condRelation = a.getCondRelation();
                Map groupedCondRelations = bpmnNodeConditionsConfBaseVo.getGroupedCondRelations();
                groupedCondRelations.put(condGroup, condRelation);
            }).collect(Collectors.groupingBy(BpmnNodeConditionsParamConf::getCondGroup, Collectors.mapping(BpmnNodeConditionsParamConf::getConditionParamType, Collectors.toList()))));
            HashMap<Integer, LinkedHashMap<String, Object>> groupedWrappedValue = new HashMap<Integer, LinkedHashMap<String, Object>>();
            boolean isLowCodeFlow = false;
            for (BpmnNodeConditionsParamConf nodeConditionsParamConf : nodeConditionsParamConfs) {
                LinkedHashMap<String, Object> wrappedValue = null;
                ConditionTypeEnum conditionTypeEnum = ConditionTypeEnum.getEnumByCode(nodeConditionsParamConf.getConditionParamType());
                if (conditionTypeEnum == null) {
                    throw new AFBizException("can not get ConditionTypeEnum by code:" + nodeConditionsParamConf.getConditionParamType());
                }
                Integer condGroup = nodeConditionsParamConf.getCondGroup();
                String conditionParamJsom = nodeConditionsParamConf.getConditionParamJsom();
                Integer operator = nodeConditionsParamConf.getOperator();
                String paramKey = nodeConditionsParamConf.getConditionParamName() + "_" + nodeConditionsParamConf.getCondGroup();
                if (!ObjectUtils.isEmpty((Object)conditionParamJsom)) {
                    Field field;
                    String columnDbname;
                    if (conditionTypeEnum.getFieldType().equals(1)) {
                        List objects = JSON.parseArray((String)conditionParamJsom, conditionTypeEnum.getFieldCls());
                        if (ConditionTypeEnum.isLowCodeFlow(conditionTypeEnum)) {
                            columnDbname = name2confVueMap.get(paramKey).getColumnDbname();
                            if (wrappedValue == null) {
                                wrappedValue = new LinkedHashMap();
                            }
                            wrappedValue.put(columnDbname, objects);
                            if (groupedWrappedValue.containsKey(condGroup)) {
                                ((Map)groupedWrappedValue.get(condGroup)).put(columnDbname, objects);
                            } else {
                                groupedWrappedValue.put(condGroup, wrappedValue);
                            }
                        }
                        field = FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)conditionTypeEnum.getFieldName(), (boolean)true);
                        ReflectionUtils.setField((Field)field, (Object)bpmnNodeConditionsConfBaseVo, (Object)(wrappedValue != null ? wrappedValue : objects));
                    } else if (conditionTypeEnum.getFieldType().equals(2)) {
                        Object object = null;
                        object = String.class.isAssignableFrom(conditionTypeEnum.getFieldCls()) ? conditionParamJsom : JSON.parseObject((String)conditionParamJsom, conditionTypeEnum.getFieldCls());
                        if (ConditionTypeEnum.isLowCodeFlow(conditionTypeEnum)) {
                            isLowCodeFlow = true;
                            columnDbname = name2confVueMap.get(paramKey).getColumnDbname();
                            if (wrappedValue == null) {
                                wrappedValue = new LinkedHashMap<String, Object>();
                            }
                            wrappedValue.put(columnDbname, object);
                            if (groupedWrappedValue.containsKey(condGroup)) {
                                ((Map)groupedWrappedValue.get(condGroup)).put(columnDbname, object);
                            } else {
                                groupedWrappedValue.put(condGroup, wrappedValue);
                            }
                        } else {
                            field = FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)conditionTypeEnum.getFieldName(), (boolean)true);
                            ReflectionUtils.setField((Field)field, (Object)bpmnNodeConditionsConfBaseVo, (Object)(wrappedValue != null ? wrappedValue : object));
                        }
                    }
                }
                BpmnNodeConditionsAdaptor bean = (BpmnNodeConditionsAdaptor)SpringBeanUtils.getBean(conditionTypeEnum.getCls());
                bean.setConditionsResps(bpmnNodeConditionsConfBaseVo);
                bpmnNodeConditionsConfBaseVo.getNumberOperatorList().add(operator);
                Map groupedNumberOperatorListMap = bpmnNodeConditionsConfBaseVo.getGroupedNumberOperatorListMap();
                if (groupedNumberOperatorListMap.containsKey(nodeConditionsParamConf.getCondGroup())) {
                    ((List)groupedNumberOperatorListMap.get(nodeConditionsParamConf.getCondGroup())).add(operator);
                    continue;
                }
                ArrayList numberOperatorList = Lists.newArrayList();
                numberOperatorList.add(operator);
                groupedNumberOperatorListMap.put(nodeConditionsParamConf.getCondGroup(), numberOperatorList);
            }
            if (isLowCodeFlow) {
                bpmnNodeConditionsConfBaseVo.setGroupedLfConditionsMap(groupedWrappedValue);
            }
        }
        this.setProperty(bpmnNodeVo, bpmnNodeConditionsConfBaseVo);
        List<BpmnNodeConditionsConfVueVo> bpmnNodeConditionsConfVueVos = BpmnConfNodePropertyConverter.toVue3Model(bpmnNodeConditionsConfBaseVo);
        Map<String, BpmnNodeConditionsConfVueVo> voMap = bpmnNodeConditionsConfVueVos.stream().collect(Collectors.toMap(BpmnNodeConditionsConfVueVo::getColumnDbname, v -> v, (k1, k2) -> k1));
        List extFields = extFieldsGroup.stream().flatMap(Collection::stream).collect(Collectors.toList());
        for (BpmnNodeConditionsConfVueVo extField : extFields) {
            BpmnNodeConditionsConfVueVo vueVo;
            String columnDbname = extField.getColumnDbname();
            boolean lowCodeFlow = ConditionTypeEnum.isLowCodeFlow(ConditionTypeEnum.getEnumByCode(Integer.parseInt(extField.getColumnId())));
            if (lowCodeFlow) {
                columnDbname = "lfConditions";
            }
            if (!CollectionUtils.isEmpty(voMap) && (vueVo = voMap.get(columnDbname)) == null) {
                throw new AFBizException("logic error!");
            }
            extField.setFixedDownBoxValue(extField.getFixedDownBoxValue());
        }
        bpmnNodeVo.getProperty().setIsDefault(bpmnNodeConditionsConf.getIsDefault());
        bpmnNodeVo.getProperty().setSort(bpmnNodeConditionsConf.getSort());
        bpmnNodeVo.getProperty().setGroupRelation(Boolean.valueOf(ConditionRelationShipEnum.getValueByCode((Integer)bpmnNodeConditionsConf.getGroupRelation())));
        bpmnNodeVo.getProperty().setConditionList(extFieldsGroup);
        return bpmnNodeVo;
    }

    @Override
    public PersonnelRuleVO formaFieldAttributeInfoVO() {
        return null;
    }

    private void setProperty(BpmnNodeVo bpmnNodeVo, BpmnNodeConditionsConfBaseVo bpmnNodeConditionsConfBaseVo) {
        bpmnNodeVo.setProperty(BpmnNodePropertysVo.builder().conditionsConf(bpmnNodeConditionsConfBaseVo).build());
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeConditionsConfBaseVo bpmnNodeConditionsConfBaseVo = Optional.ofNullable(bpmnNodeVo.getProperty()).map(BpmnConfNodePropertyConverter::fromVue3Model).orElse(new BpmnNodeConditionsConfBaseVo());
        BpmnNodeConditionsConf bpmnNodeConditionsConf = new BpmnNodeConditionsConf();
        bpmnNodeConditionsConf.setBpmnNodeId(bpmnNodeVo.getId());
        bpmnNodeConditionsConf.setIsDefault(bpmnNodeConditionsConfBaseVo.getIsDefault());
        bpmnNodeConditionsConf.setSort(bpmnNodeConditionsConfBaseVo.getSort());
        bpmnNodeConditionsConf.setGroupRelation(bpmnNodeConditionsConfBaseVo.getGroupRelation());
        bpmnNodeConditionsConf.setExtJson(bpmnNodeConditionsConfBaseVo.getExtJson());
        bpmnNodeConditionsConf.setCreateTime(new Date());
        bpmnNodeConditionsConf.setCreateUser(SecurityUtils.getLogInEmpNameSafe());
        bpmnNodeConditionsConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        this.confMapper.insert(bpmnNodeConditionsConf);
        if (Objects.equals(bpmnNodeConditionsConfBaseVo.getIsDefault(), 1)) {
            return;
        }
        Long nodeConditionsId = Optional.ofNullable(Optional.of(bpmnNodeConditionsConf).orElse(new BpmnNodeConditionsConf()).getId()).orElse(0L);
        if (nodeConditionsId > 0L) {
            boolean emptyCondition = false;
            String extJson = bpmnNodeConditionsConfBaseVo.getExtJson();
            List extFieldsArray = (List)JSON.parseObject((String)extJson, (TypeReference)new TypeReference<List<List<BpmnNodeConditionsConfVueVo>>>(){}, (JSONReader.Feature[])new JSONReader.Feature[0]);
            int index = 0;
            for (List extFields : extFieldsArray) {
                ++index;
                for (BpmnNodeConditionsConfVueVo extField : extFields) {
                    String columnId = extField.getColumnId();
                    String columnDbname = extField.getColumnDbname();
                    ConditionTypeEnum conditionTypeEnum = ConditionTypeEnum.getEnumByCode(Integer.parseInt(columnId));
                    if (conditionTypeEnum == null) {
                        throw new AFBizException(Strings.lenientFormat((String)"can not get node ConditionTypeEnum by code:%s", (Object[])new Object[]{columnId}));
                    }
                    Object conditionParam = null;
                    if (ConditionTypeEnum.isLowCodeFlow(conditionTypeEnum)) {
                        Map groupedLfConditionsMap = bpmnNodeConditionsConfBaseVo.getGroupedLfConditionsMap();
                        conditionParam = groupedLfConditionsMap.get(index);
                    } else {
                        conditionParam = ReflectionUtils.getField((Field)FieldUtils.getField(BpmnNodeConditionsConfBaseVo.class, (String)conditionTypeEnum.getFieldName(), (boolean)true), (Object)bpmnNodeConditionsConfBaseVo);
                    }
                    if (ObjectUtils.isEmpty((Object)conditionParam)) continue;
                    if (ConditionTypeEnum.isLowCodeFlow(conditionTypeEnum)) {
                        Map containerWrapper = (Map)conditionParam;
                        conditionParam = containerWrapper.get(columnDbname);
                    }
                    String conditionParamJson = conditionParam instanceof String ? conditionParam.toString() : JSON.toJSONString((Object)conditionParam);
                    if (conditionTypeEnum.getFieldType() == 1 && ObjectUtils.isEmpty((Object)JSON.parseArray((String)conditionParamJson, conditionTypeEnum.getFieldCls()))) continue;
                    Integer numberOperator = extField.getOptType();
                    ((BpmnNodeConditionsParamConfMapper)this.bpmnNodeConditionsParamConfService.getBaseMapper()).insert(BpmnNodeConditionsParamConf.builder().bpmnNodeConditionsId(nodeConditionsId).conditionParamType(conditionTypeEnum.getCode()).conditionParamName(extField.getColumnDbname()).conditionParamJsom(conditionParamJson).operator(numberOperator).condGroup(extField.getCondGroup()).condRelation(ConditionRelationShipEnum.getCodeByValue((Boolean)extField.getCondRelation())).createUser(SecurityUtils.getLogInEmpNameSafe()).createTime(new Date()).build());
                    if (conditionTypeEnum.getFieldType() == 2 && !String.class.isAssignableFrom(conditionTypeEnum.getFieldCls())) {
                        ((BpmnNodeConditionsParamConfMapper)this.bpmnNodeConditionsParamConfService.getBaseMapper()).insert(BpmnNodeConditionsParamConf.builder().bpmnNodeConditionsId(nodeConditionsId).conditionParamType(ConditionTypeEnum.CONDITION_TYPE_NUMBER_OPERATOR.getCode()).conditionParamName(ConditionTypeEnum.CONDITION_TYPE_NUMBER_OPERATOR.getFieldName()).conditionParamJsom(numberOperator.toString()).condGroup(extField.getCondGroup()).condRelation(ConditionRelationShipEnum.getCodeByValue((Boolean)extField.getCondRelation())).createUser(SecurityUtils.getLogInEmpNameSafe()).createTime(new Date()).build());
                    }
                    Long confId = bpmnNodeVo.getConfId();
                    ((BpmnConfLfFormdataFieldMapper)this.lfFormdataFieldService.getBaseMapper()).updateByConfIdAndFieldName(confId, columnDbname);
                }
            }
        }
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_TYPE_CONDITIONS});
    }
}

