/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.bpmnnodeadp;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import jodd.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.entity.OutSideBpmnNodeConditionsConf;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.NodeTypeConditionsAdp;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmnNodeConditionsConfServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="nodeTypeOutSideConditionsAdp")
public class NodeTypeOutSideConditionsAdp
extends NodeTypeConditionsAdp {
    private static final Logger log = LoggerFactory.getLogger(NodeTypeOutSideConditionsAdp.class);
    @Autowired
    private OutSideBpmnNodeConditionsConfServiceImpl outSideBpmnNodeConditionsConfService;

    @Override
    public BpmnNodeVo formatToBpmnNodeVo(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeVo nodeVo = super.formatToBpmnNodeVo(bpmnNodeVo);
        if (StringUtil.isEmpty((CharSequence)bpmnNodeVo.getConditionsUrl())) {
            return nodeVo;
        }
        OutSideBpmnNodeConditionsConf outSideBpmnNodeConditionsConf = (OutSideBpmnNodeConditionsConf)this.outSideBpmnNodeConditionsConfService.getOne((Wrapper)new QueryWrapper().eq((Object)"bpmn_node_id", (Object)bpmnNodeVo.getId()));
        String outSideConditionsUrl = StringUtils.join((Object[])new String[]{bpmnNodeVo.getConditionsUrl(), outSideBpmnNodeConditionsConf.getOutSideId()});
        nodeVo.getProperty().getConditionsConf().setOutSideConditionsUrl(outSideConditionsUrl);
        nodeVo.setNodeType(NodeTypeEnum.NODE_TYPE_CONDITIONS.getCode());
        return nodeVo;
    }

    @Override
    public void editBpmnNode(BpmnNodeVo bpmnNodeVo) {
        super.editBpmnNode(bpmnNodeVo);
        OutSideBpmnNodeConditionsConf outSideBpmnNodeConditionsConf = new OutSideBpmnNodeConditionsConf();
        outSideBpmnNodeConditionsConf.setBpmnNodeId(bpmnNodeVo.getId());
        outSideBpmnNodeConditionsConf.setTenantId(MultiTenantUtil.getCurrentTenantId());
        if (bpmnNodeVo.getProperty().getConditionsConf() != null) {
            outSideBpmnNodeConditionsConf.setOutSideId(bpmnNodeVo.getProperty().getConditionsConf().getOutSideConditionsId());
        }
        this.outSideBpmnNodeConditionsConfService.save(outSideBpmnNodeConditionsConf);
    }

    @Override
    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{BpmnNodeAdpConfEnum.ADP_CONF_NODE_TYPE_OUT_SIDE_CONDITIONS});
    }
}

