/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.conditionfilter;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.ConditionRelationShipEnum;
import org.openoa.base.entity.BpmDynamicConditionChoosen;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ConditionService;
import org.openoa.base.util.SpringBeanUtils;
import org.openoa.base.vo.BpmnNodeConditionsConfBaseVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.engine.bpmnconf.adp.conditionfilter.ConditionJudge;
import org.openoa.engine.bpmnconf.constant.enus.ConditionTypeEnum;
import org.openoa.engine.bpmnconf.mapper.BpmDynamicConditionChoosenMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ConditionServiceImpl
implements ConditionService {
    private static final Logger log = LoggerFactory.getLogger(ConditionServiceImpl.class);
    @Autowired
    private BpmDynamicConditionChoosenMapper dynamicConditionChoosenMapper;

    public boolean checkMatchCondition(BpmnNodeVo bpmnNodeVo, BpmnNodeConditionsConfBaseVo conditionsConf, BpmnStartConditionsVo bpmnStartConditionsVo, boolean isDynamicConditionGateway) {
        LambdaQueryWrapper qryWrapper;
        List conditionChoosens;
        List nodeIdsEverUsed;
        String nodeId = bpmnNodeVo.getNodeId();
        Map groupedConditionParamTypes = conditionsConf.getGroupedConditionParamTypes();
        if (CollectionUtils.isEmpty((Map)groupedConditionParamTypes)) {
            return false;
        }
        boolean result = true;
        Integer groupRelation = conditionsConf.getGroupRelation();
        for (Map.Entry conditionTypeEntry : groupedConditionParamTypes.entrySet()) {
            Integer currentGroup = (Integer)conditionTypeEntry.getKey();
            Integer condRelation = (Integer)conditionsConf.getGroupedCondRelations().get(currentGroup);
            boolean currentGroupResult = true;
            if (condRelation == null) {
                throw new AFBizException("logic error,please contact the Administrator");
            }
            List conditionParamTypeList = (List)conditionTypeEntry.getValue();
            if (CollectionUtils.isEmpty((Collection)conditionParamTypeList)) {
                result = false;
                break;
            }
            conditionParamTypeList = conditionParamTypeList.stream().distinct().collect(Collectors.toList());
            for (Integer integer : conditionParamTypeList) {
                ConditionTypeEnum conditionTypeEnum = ConditionTypeEnum.getEnumByCode(integer);
                if (conditionTypeEnum == null) {
                    log.info("condition type is null,type:{}", (Object)integer);
                    throw new AFBizException("logic error,please contact the Administrator");
                }
                try {
                    if (!((ConditionJudge)SpringBeanUtils.getBean(conditionTypeEnum.getConditionJudgeCls())).judge(nodeId, conditionsConf, bpmnStartConditionsVo, currentGroup)) {
                        currentGroupResult = false;
                        if (!condRelation.equals(ConditionRelationShipEnum.AND.getCode())) continue;
                        break;
                    }
                    currentGroupResult = true;
                    if (!condRelation.equals(ConditionRelationShipEnum.OR.getCode())) continue;
                    break;
                }
                catch (AFBizException e) {
                    log.info("condition judge business exception:{}", (Object)e.getMessage());
                    throw e;
                }
                catch (Exception e) {
                    log.error("conditionJudgeClass instantiate failure", (Throwable)e);
                    throw e;
                }
            }
            result = currentGroupResult;
            if ((groupRelation != ConditionRelationShipEnum.AND.getCode() || result) && (groupRelation != ConditionRelationShipEnum.OR.getCode() || !result)) continue;
            break;
        }
        if (Boolean.TRUE.equals(bpmnStartConditionsVo.getIsMigration()) && Boolean.TRUE.equals(bpmnStartConditionsVo.isPreview() && isDynamicConditionGateway) && (!(nodeIdsEverUsed = (conditionChoosens = this.dynamicConditionChoosenMapper.selectList((Wrapper)(qryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(BpmDynamicConditionChoosen::getProcessNumber, (Object)bpmnStartConditionsVo.getProcessNum())).eq(BpmDynamicConditionChoosen::getNodeFrom, (Object)bpmnNodeVo.getNodeFrom())))).stream().map(BpmDynamicConditionChoosen::getNodeId).collect(Collectors.toList())).contains(nodeId) && result || nodeIdsEverUsed.contains(nodeId) && !result)) {
            this.dynamicConditionChoosenMapper.delete((Wrapper)qryWrapper);
            BpmDynamicConditionChoosen dynamicConditionChoosen = new BpmDynamicConditionChoosen();
            dynamicConditionChoosen.setProcessNumber(bpmnStartConditionsVo.getProcessNum());
            dynamicConditionChoosen.setNodeId(bpmnNodeVo.getNodeId());
            this.dynamicConditionChoosenMapper.insert(dynamicConditionChoosen);
            throw new AFBizException("condition_changed", "\u6d41\u7a0b\u6761\u4ef6\u53d1\u751f\u6539\u53d8");
        }
        if (isDynamicConditionGateway && !Boolean.TRUE.equals(bpmnStartConditionsVo.isPreview()) && result) {
            BpmDynamicConditionChoosen dynamicConditionChoosen = new BpmDynamicConditionChoosen();
            dynamicConditionChoosen.setProcessNumber(bpmnStartConditionsVo.getProcessNum());
            dynamicConditionChoosen.setNodeId(bpmnNodeVo.getNodeId());
            dynamicConditionChoosen.setNodeFrom(bpmnNodeVo.getNodeFrom());
            this.dynamicConditionChoosenMapper.insert(dynamicConditionChoosen);
        }
        return result;
    }
}

