/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.conditionfilter.conditionjudge;

import java.math.BigDecimal;
import org.openoa.base.exception.AFBizException;
import org.openoa.engine.bpmnconf.adp.conditionfilter.ConditionJudge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractComparableJudge
implements ConditionJudge {
    private static final Logger log = LoggerFactory.getLogger(AbstractComparableJudge.class);

    protected boolean compareJudge(BigDecimal confTotal, BigDecimal confTotal2, BigDecimal actual, Integer operator) {
        if (confTotal == null) {
            log.error("confTotal is null");
            return false;
        }
        if (actual == null) {
            log.error("operator right is null");
            return false;
        }
        if (operator == null) {
            throw new AFBizException("operator is null");
        }
        boolean flag = false;
        switch (operator) {
            case 1: {
                if (actual.compareTo(confTotal) < 0) break;
                flag = true;
                break;
            }
            case 2: {
                if (actual.compareTo(confTotal) <= 0) break;
                flag = true;
                break;
            }
            case 3: {
                if (actual.compareTo(confTotal) > 0) break;
                flag = true;
                break;
            }
            case 4: {
                if (actual.compareTo(confTotal) >= 0) break;
                flag = true;
                break;
            }
            case 5: {
                if (actual.compareTo(confTotal) != 0) break;
                flag = true;
                break;
            }
            case 6: {
                if (actual.compareTo(confTotal) <= 0 || actual.compareTo(confTotal2) >= 0) break;
                flag = true;
                break;
            }
            case 7: {
                if (actual.compareTo(confTotal) < 0 || actual.compareTo(confTotal2) >= 0) break;
                flag = true;
                break;
            }
            case 8: {
                if (actual.compareTo(confTotal) <= 0 || actual.compareTo(confTotal2) > 0) break;
                flag = true;
                break;
            }
            case 9: {
                if (actual.compareTo(confTotal) < 0 || actual.compareTo(confTotal2) > 0) break;
                flag = true;
                break;
            }
            default: {
                throw new AFBizException("operator is not support at the moment yet");
            }
        }
        return flag;
    }
}

