/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.conditionfilter.conditionjudge;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Map;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BpmnNodeConditionsConfBaseVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.engine.bpmnconf.adp.conditionfilter.conditionjudge.AbstractComparableJudge;
import org.openoa.engine.bpmnconf.service.TriplePredict;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

public abstract class AbstractLFConditionJudge
extends AbstractComparableJudge {
    private static final Logger log = LoggerFactory.getLogger(AbstractLFConditionJudge.class);

    protected boolean lfCommonJudge(BpmnNodeConditionsConfBaseVo conditionsConf, BpmnStartConditionsVo bpmnStartConditionsVo, TriplePredict<Object, Object, Integer> predicate, int currentGroup) {
        Map groupedLfConditionsMap = conditionsConf.getGroupedLfConditionsMap();
        Map groupedNumberOperatorListMap = conditionsConf.getGroupedNumberOperatorListMap();
        if (groupedLfConditionsMap == null) {
            return false;
        }
        Map lfConditionsFromDb = (Map)groupedLfConditionsMap.get(currentGroup);
        Map lfConditionsFromUser = bpmnStartConditionsVo.getLfConditions();
        if (CollectionUtils.isEmpty((Map)lfConditionsFromDb)) {
            throw new AFBizException("the process has no no code conditions conf,please contact the administrator to add one");
        }
        if (ObjectUtils.isEmpty((Object)lfConditionsFromUser)) {
            return false;
        }
        boolean isMatch = true;
        int iterIndex = 0;
        List numberOperatorList = (List)groupedNumberOperatorListMap.get(currentGroup);
        for (Map.Entry stringObjectEntry : lfConditionsFromDb.entrySet()) {
            String key = (String)stringObjectEntry.getKey();
            Integer numberOperator = (Integer)numberOperatorList.get(iterIndex);
            Object valueFromUser = lfConditionsFromUser.get(key);
            if (valueFromUser == null) {
                log.error(Strings.lenientFormat((String)"condition field from user %s can not be null", (Object[])new Object[]{key}));
                return false;
            }
            Object valueFromDb = stringObjectEntry.getValue();
            if (valueFromDb == null) {
                throw new AFBizException(Strings.lenientFormat((String)"condition field from db %s can not be null", (Object[])new Object[]{key}));
            }
            isMatch = predicate.test(valueFromDb, valueFromUser, numberOperator);
            ++iterIndex;
            if (isMatch) continue;
            return false;
        }
        return isMatch;
    }
}

