/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.conditionfilter.conditionjudge;

import java.util.Objects;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodeConditionsConfBaseVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.engine.bpmnconf.adp.conditionfilter.ConditionJudge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class JobLevelJudge
implements ConditionJudge {
    private static final Logger log = LoggerFactory.getLogger(JobLevelJudge.class);

    @Override
    public boolean judge(String nodeId, BpmnNodeConditionsConfBaseVo conditionsConf, BpmnStartConditionsVo bpmnStartConditionsVo, int group) {
        BaseIdTranStruVo voFromDb = conditionsConf.getJobLevelVo();
        BaseIdTranStruVo voFromUser = bpmnStartConditionsVo.getJobLevelVo();
        if (ObjectUtils.isEmpty((Object)voFromDb)) {
            throw new AFBizException("the process has no third party account conf,please contact the administrator to add one");
        }
        if (ObjectUtils.isEmpty((Object)voFromUser)) {
            throw new AFBizException("process has no third party account form,please contact the administrator");
        }
        return Objects.equals(voFromDb.getId(), voFromUser.getId()) && Objects.equals(voFromDb.getName(), voFromUser.getName());
    }
}

