/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.conditionfilter.conditionjudge;

import com.google.common.base.Strings;
import java.math.BigDecimal;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BpmnNodeConditionsConfBaseVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.engine.bpmnconf.adp.conditionfilter.conditionjudge.AbstractComparableJudge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class OutTotalMoneyJudge
extends AbstractComparableJudge {
    private static final Logger log = LoggerFactory.getLogger(OutTotalMoneyJudge.class);

    @Override
    public boolean judge(String nodeId, BpmnNodeConditionsConfBaseVo conditionsConf, BpmnStartConditionsVo bpmnStartConditionsVo, int group) {
        if (Strings.isNullOrEmpty((String)conditionsConf.getOutTotalMoney()) || Strings.isNullOrEmpty((String)bpmnStartConditionsVo.getOutTotalMoney())) {
            log.info("process's out total money is empty");
            throw new AFBizException("999", "process's out total money is empty");
        }
        BigDecimal outTotalMoney = new BigDecimal(conditionsConf.getOutTotalMoney());
        BigDecimal total = new BigDecimal(bpmnStartConditionsVo.getOutTotalMoney());
        Integer theOperatorType = conditionsConf.getNumberOperator();
        return super.compareJudge(outTotalMoney, null, total, theOperatorType);
    }
}

