/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.conditionfilter.conditionjudge;

import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BpmnNodeConditionsConfBaseVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.engine.bpmnconf.adp.conditionfilter.ConditionJudge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ThirdAccountJudge
implements ConditionJudge {
    private static final Logger log = LoggerFactory.getLogger(ThirdAccountJudge.class);

    @Override
    public boolean judge(String nodeId, BpmnNodeConditionsConfBaseVo conditionsConf, BpmnStartConditionsVo bpmnStartConditionsVo, int group) {
        if (ObjectUtils.isEmpty((Object)conditionsConf.getAccountType())) {
            throw new AFBizException("the process has no third party account conf,please contact the administrator to add one");
        }
        if (ObjectUtils.isEmpty((Object)bpmnStartConditionsVo.getAccountType())) {
            return false;
        }
        return conditionsConf.getAccountType().contains(bpmnStartConditionsVo.getAccountType());
    }
}

