/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.orderedsignadp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.OrderNodeTypeEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AfUserService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnNodePropertysVo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.common.adaptor.bpmnelementadp.AbstractOrderedSignNodeAdp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class BpmnLoopSignNodeAdp
extends AbstractOrderedSignNodeAdp {
    @Autowired
    private AfUserService userService;

    public List<String> getAssigneeIds(BpmnNodeVo nodeVo, BpmnStartConditionsVo bpmnStartConditions) {
        BpmnNodePropertysVo propertysVo = nodeVo.getProperty();
        if (propertysVo == null) {
            throw new AFBizException("loop sign failure,node has no property!");
        }
        String startUserId = bpmnStartConditions.getStartUserId();
        Integer loopEndType = propertysVo.getLoopEndType();
        Integer loopNumberPlies = propertysVo.getLoopNumberPlies();
        Integer loopEndGrade = propertysVo.getLoopEndGrade();
        HashSet<String> loopEndPersonList = new HashSet<String>();
        if (!CollectionUtils.isEmpty((Collection)propertysVo.getLoopEndPersonList())) {
            for (Serializable s : propertysVo.getLoopEndPersonList()) {
                loopEndPersonList.add(s.toString());
            }
        }
        if (loopNumberPlies == null && loopEndGrade == null) {
            throw new AFBizException("\u7ec4\u7ec7\u7ebf\u5c42\u5c42\u5ba1\u6279\u627e\u4eba\u65f6\uff0c\u4e24\u4e2a\u5165\u53c2\u90fd\u4e3a\u7a7a\uff01");
        }
        List baseIdTranStruVos = null;
        if (loopNumberPlies != null && CollectionUtils.isEmpty((Collection)(baseIdTranStruVos = this.userService.queryLeadersByEmployeeIdAndTier(startUserId, loopNumberPlies)))) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u53d1\u8d77\u4eba\u627e\u5230\u5c42\u5c42\u5ba1\u6279\u4eba\u4fe1\u606f");
        }
        if (loopEndGrade != null && CollectionUtils.isEmpty((Collection)(baseIdTranStruVos = this.userService.queryLeadersByEmployeeIdAndGrade(startUserId, loopEndGrade)))) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u53d1\u8d77\u4eba\u627e\u5230\u6c47\u62a5\u7ebf\u5ba1\u6279\u4eba\u4fe1\u606f");
        }
        if (CollectionUtils.isEmpty(baseIdTranStruVos)) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u53d1\u8d77\u4eba\u627e\u5230\u5ba1\u6279\u4eba\u4fe1\u606f");
        }
        List approverIds = baseIdTranStruVos.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList());
        ArrayList<String> finalApproverIds = new ArrayList<String>();
        for (String approverId : approverIds) {
            if (loopEndPersonList.contains(approverId)) continue;
            finalApproverIds.add(approverId);
        }
        return finalApproverIds;
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{OrderNodeTypeEnum.LOOP_NODE});
    }
}

