/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.ManagementService;
import org.activiti.engine.TaskService;
import org.activiti.engine.impl.bpmn.behavior.MultiInstanceActivityBehavior;
import org.activiti.engine.impl.bpmn.behavior.ParallelMultiInstanceBehavior;
import org.activiti.engine.impl.bpmn.behavior.SequentialMultiInstanceBehavior;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.pvm.delegate.ActivityBehavior;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.common.ActivitiAdditionalInfoServiceImpl;
import org.openoa.engine.bpmnconf.service.cmd.MultiCharacterInstanceParallelSign;
import org.openoa.engine.bpmnconf.service.cmd.MultiCharacterInstanceSequentialSign;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmFlowrunEntrustService;
import org.openoa.engine.utils.MultiInstanceUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class AddAssigneeProcessImpl
implements ProcessOperationAdaptor {
    @Autowired
    private TaskService taskService;
    @Autowired
    private ManagementService managementService;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private ActivitiAdditionalInfoServiceImpl additionalInfoService;
    @Autowired
    private BpmFlowrunEntrustService flowrunEntrustService;

    public void doProcessButton(BusinessDataVo vo) {
        String processNumber = vo.getProcessNumber();
        String taskDefKey = vo.getTaskDefKey();
        List userInfos = vo.getUserInfos();
        if (CollectionUtils.isEmpty((Collection)userInfos)) {
            throw new AFBizException("\u8bf7\u9009\u62e9\u8981\u52a0\u7b7e\u7684\u4eba\u5458");
        }
        if (userInfos.size() > 1) {
            throw new AFBizException("\u6bcf\u6b21\u52a0\u80fd\u52a0\u7b7e1\u4eba");
        }
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(processNumber);
        if (bpmBusinessProcess == null) {
            throw new RuntimeException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b:" + processNumber);
        }
        String procInstId = bpmBusinessProcess.getProcInstId();
        List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).taskDefinitionKey(taskDefKey)).list();
        if (CollectionUtils.isEmpty((Collection)tasks)) {
            throw new RuntimeException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid:" + procInstId + "\u548c\u4efb\u52a1\u8282\u70b9key:" + taskDefKey + "\u627e\u5230\u5f53\u524d\u5ba1\u6279\u4efb\u52a1");
        }
        Task task = (Task)tasks.get(0);
        List<ActivityImpl> activitiList = this.additionalInfoService.getActivitiList(task.getProcessDefinitionId());
        if (CollectionUtils.isEmpty(activitiList)) {
            throw new RuntimeException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u5b9a\u4e49id:" + task.getProcessDefinitionId() + "\u627e\u5230\u6d41\u7a0b\u56fe");
        }
        List currentActivities = activitiList.stream().filter(a -> a.getId().equals(task.getTaskDefinitionKey())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(currentActivities)) {
            throw new RuntimeException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u8282\u70b9key:" + task.getTaskDefinitionKey() + "\u627e\u5230\u6d41\u7a0b\u56fe\u5bf9\u5e94\u8282\u70b9\u4fe1\u606f");
        }
        ActivityImpl currentActiviti = (ActivityImpl)currentActivities.get(0);
        ActivityBehavior activityBehavior = currentActiviti.getActivityBehavior();
        if (!(activityBehavior instanceof MultiInstanceActivityBehavior)) {
            throw new AFBizException("\u4e0d\u652f\u6301\u975e\u591a\u5b9e\u4f8b\u8282\u70b9!");
        }
        String collectionName = MultiInstanceUtils.getCollectionNameByBehavior(activityBehavior);
        Object variable = this.taskService.getVariable(task.getId(), collectionName);
        ArrayList<String> assigneeValues = new ArrayList<String>();
        Iterable iterable = (Iterable)variable;
        Iterator iterator = iterable.iterator();
        List assignees = userInfos.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList());
        while (iterator.hasNext()) {
            Object next = iterator.next();
            String nextValue = next.toString();
            if (assignees.contains(nextValue)) continue;
            assigneeValues.add(nextValue);
            if (!task.getAssignee().equals(nextValue)) continue;
            assigneeValues.addAll(assignees);
        }
        HashMap<String, Object> variables = new HashMap<String, Object>();
        variables.put(collectionName, assigneeValues);
        Object command = null;
        if (activityBehavior instanceof ParallelMultiInstanceBehavior) {
            command = new MultiCharacterInstanceParallelSign(task.getId(), userInfos);
        } else if (activityBehavior instanceof SequentialMultiInstanceBehavior) {
            command = new MultiCharacterInstanceSequentialSign(task.getId(), variables);
        } else {
            throw new AFBizException("\u4e0d\u652f\u6301\u52a0\u7b7e\u7684\u8282\u70b9\u7c7b\u578b!");
        }
        this.managementService.executeCommand((Command)command);
        BaseIdTranStruVo userinfo = (BaseIdTranStruVo)userInfos.get(0);
        this.flowrunEntrustService.addFlowrunEntrust(userinfo.getId(), userinfo.getName(), "0", "\u7ba1\u7406\u5458\u52a0\u7b7e", task.getId(), 0, task.getProcessInstanceId(), bpmBusinessProcess.getProcessinessKey());
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_ADD_ASSIGNEE});
    }
}

