/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmFlowrunEntrustService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChangeAssigneeProcessImpl
implements ProcessOperationAdaptor {
    @Autowired
    protected BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private BpmFlowrunEntrustService bpmFlowrunEntrustService;

    public void doProcessButton(BusinessDataVo vo) {
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(vo.getProcessNumber());
        String taskDefKey = vo.getTaskDefKey();
        List list = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(bpmBusinessProcess.getProcInstId())).taskDefinitionKey(taskDefKey)).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            throw new RuntimeException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u627e\u5230\u6d41\u7a0b\u5b9e\u4f8b:" + vo.getProcessNumber());
        }
        List userInfos = vo.getUserInfos();
        List userIds = userInfos.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList());
        for (int i = 0; i < list.size(); ++i) {
            Task task = (Task)list.get(i);
            String user = ((BaseIdTranStruVo)userInfos.get(i)).getId();
            String userName = ((BaseIdTranStruVo)userInfos.get(i)).getName();
            String assignee = task.getAssignee();
            String assigneeName = task.getDescription();
            if (userIds.contains(assignee)) continue;
            this.bpmFlowrunEntrustService.addFlowrunEntrust(user, userName, assignee, assigneeName, task.getId(), 0, bpmBusinessProcess.getProcInstId(), vo.getProcessKey());
            TaskMgmtVO taskMgmtVO = TaskMgmtVO.builder().applyUser(user).applyUserName(userName).taskId(task.getId()).build();
            this.taskMgmtMapper.updateaActinst(taskMgmtVO);
            this.taskMgmtMapper.updateaTaskinst(taskMgmtVO);
            this.taskMgmtMapper.updateTask(taskMgmtVO);
        }
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_CHANGE_ASSIGNEE});
    }
}

