/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BaseInfoTranStructVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.common.entity.BpmVariableMultiplayerPersonnel;
import org.openoa.common.entity.BpmVariableSingle;
import org.openoa.common.mapper.BpmVariableMultiplayerMapper;
import org.openoa.common.mapper.BpmVariableMultiplayerPersonnelMapper;
import org.openoa.common.mapper.BpmVariableSingleMapper;
import org.openoa.engine.bpmnconf.common.TaskMgmtServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmFlowrunEntrustService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ChangeFutureAssigneeProcessImpl
implements ProcessOperationAdaptor {
    @Autowired
    private BpmVariableMultiplayerMapper bpmVariableMultiplayerMapper;
    @Autowired
    private BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    @Autowired
    private TaskMgmtServiceImpl taskMgmtService;
    @Autowired
    private BpmFlowrunEntrustService flowrunEntrustService;
    @Autowired
    private BpmVariableSingleMapper variableSingleMapper;
    @Autowired
    private BpmVariableMultiplayerPersonnelMapper variableMultiplayerPersonnelMapper;

    public void doProcessButton(BusinessDataVo vo) {
        String processNumber = vo.getProcessNumber();
        String nodeId = vo.getNodeId();
        List userInfos = vo.getUserInfos();
        if (StringUtils.isEmpty((CharSequence)processNumber)) {
            throw new AFBizException("\u6d41\u7a0b\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            throw new AFBizException("\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (CollectionUtils.isEmpty((Collection)userInfos)) {
            throw new AFBizException("\u5ba1\u6279\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(processNumber);
        if (null == bpmBusinessProcess) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u7f16\u53f7\u627e\u5230\u6d41\u7a0b\u4fe1\u606f:" + processNumber);
        }
        List assignees = this.bpmVariableMultiplayerMapper.getAssigneeAndVariableByNodeId(processNumber, nodeId);
        if (userInfos.size() != assignees.size()) {
            throw new AFBizException("\u5ba1\u6279\u4eba\u6570\u91cf\u548c\u6d41\u7a0b\u4e2d\u5ba1\u6279\u4eba\u6570\u91cf\u4e0d\u4e00\u81f4");
        }
        HashMap<BaseInfoTranStructVo, BaseIdTranStruVo> changedAssignees = new HashMap<BaseInfoTranStructVo, BaseIdTranStruVo>();
        for (int i = 0; i < assignees.size(); ++i) {
            BaseInfoTranStructVo currentAssignee = (BaseInfoTranStructVo)assignees.get(i);
            BaseIdTranStruVo mayChangedAssignee = (BaseIdTranStruVo)userInfos.get(i);
            List sameAssignees = userInfos.stream().filter(a -> currentAssignee.getId().equals(a.getId())).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(sameAssignees)) continue;
            changedAssignees.put(currentAssignee, mayChangedAssignee);
        }
        if (CollectionUtils.isEmpty(changedAssignees)) {
            throw new AFBizException("\u5f53\u524d\u5ba1\u6279\u4eba\u672a\u53d1\u751f\u53d8\u66f4!\u52ff\u9700\u64cd\u4f5c!");
        }
        String varName = ((BaseInfoTranStructVo)assignees.get(0)).getVarName();
        String variableId = ((BaseInfoTranStructVo)assignees.get(0)).getVariableId();
        List<String> assigneeIds = userInfos.stream().map(BaseIdTranStruVo::getId).collect(Collectors.toList());
        this.taskMgmtService.changeFutureAssignees(bpmBusinessProcess.getProcInstId(), varName, assigneeIds);
        for (Map.Entry old2newAssignees : changedAssignees.entrySet()) {
            LambdaUpdateWrapper updateWrapper;
            BaseIdTranStruVo oldAssignee = (BaseIdTranStruVo)old2newAssignees.getKey();
            BaseIdTranStruVo newAssignee = (BaseIdTranStruVo)old2newAssignees.getValue();
            this.flowrunEntrustService.addFlowrunEntrust(newAssignee.getId(), newAssignee.getName(), oldAssignee.getId(), oldAssignee.getName(), nodeId, 0, bpmBusinessProcess.getProcInstId(), vo.getProcessKey());
            if (assignees.size() > 1) {
                updateWrapper = Wrappers.lambdaUpdate();
                updateWrapper.set(BpmVariableMultiplayerPersonnel::getAssignee, (Object)newAssignee.getId());
                updateWrapper.set(BpmVariableMultiplayerPersonnel::getAssigneeName, (Object)(newAssignee.getName() + "*"));
                updateWrapper.eq(BpmVariableMultiplayerPersonnel::getId, (Object)variableId);
                this.variableMultiplayerPersonnelMapper.update(null, (Wrapper)updateWrapper);
                continue;
            }
            updateWrapper = Wrappers.lambdaUpdate();
            updateWrapper.set(BpmVariableSingle::getAssignee, (Object)newAssignee.getId());
            updateWrapper.set(BpmVariableSingle::getAssigneeName, (Object)(newAssignee.getName() + "*"));
            updateWrapper.eq(BpmVariableSingle::getId, (Object)variableId);
            this.variableSingleMapper.update(null, (Wrapper)updateWrapper);
        }
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_CHANGE_FUTURE_ASSIGNEE});
    }
}

