/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.constant.enums.ProcessSubmitStateEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmVerifyInfo;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.common.ProcessBusinessContans;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.biz.ThirdPartyCallBackServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVerifyInfoBizService;
import org.openoa.engine.factory.FormFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class EndProcessImpl
implements ProcessOperationAdaptor {
    private static final Logger log = LoggerFactory.getLogger(EndProcessImpl.class);
    @Autowired
    private FormFactory formFactory;
    @Autowired
    protected BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private BpmVerifyInfoBizService bpmVerifyInfoBizService;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private ProcessBusinessContans businessContans;
    @Autowired
    private TaskService taskService;
    @Autowired
    private ThirdPartyCallBackServiceImpl thirdPartyCallBackService;

    public void doProcessButton(BusinessDataVo vo) {
        List taskList;
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(vo.getProcessNumber());
        String verifyUserName = "";
        String verifyUserId = "";
        if (vo.getIsOutSideAccessProc().booleanValue()) {
            Map objectMap = vo.getObjectMap();
            if (!CollectionUtils.isEmpty((Map)objectMap)) {
                verifyUserName = Optional.ofNullable(objectMap.get("employeeName")).map(String::valueOf).orElse("");
                verifyUserId = Optional.ofNullable(objectMap.get("employeeId")).map(Object::toString).orElse("");
            }
        } else {
            verifyUserName = SecurityUtils.getLogInEmpName();
            verifyUserId = SecurityUtils.getLogInEmpIdStr();
        }
        String processInstanceId = bpmBusinessProcess.getProcInstId();
        Integer processState = ProcessStateEnum.REJECT_STATE.getCode();
        if (vo.getFlag().booleanValue()) {
            processState = ProcessStateEnum.END_STATE.getCode();
        }
        if (ObjectUtils.isEmpty((Object)(taskList = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(bpmBusinessProcess.getProcInstId())).taskAssignee(SecurityUtils.getLogInEmpId())).list()))) {
            throw new AFBizException("\u5f53\u524d\u6d41\u7a0b\u5df2\u5ba1\u6279!");
        }
        Task taskData = (Task)taskList.get(0);
        this.bpmBusinessProcessService.updateBusinessProcess(BpmBusinessProcess.builder().businessNumber(bpmBusinessProcess.getBusinessNumber()).processState(processState).build());
        this.bpmVerifyInfoBizService.addVerifyInfo(BpmVerifyInfo.builder().businessId(bpmBusinessProcess.getBusinessId()).verifyUserId(verifyUserId).verifyUserName(verifyUserName).verifyStatus(Integer.valueOf(processState.equals(ProcessStateEnum.END_STATE.getCode()) ? ProcessSubmitStateEnum.END_AGRESS_TYPE.getCode() : processState.intValue())).verifyDate(new Date()).processCode(vo.getProcessNumber()).verifyDesc(vo.getApprovalComment()).taskName(taskData.getName()).taskId(taskData.getId()).runInfoId(bpmBusinessProcess.getProcInstId()).build());
        this.businessContans.deleteProcessInstance(processInstanceId);
        vo.setBusinessId(bpmBusinessProcess.getBusinessId());
        if (!vo.getIsOutSideAccessProc().booleanValue()) {
            this.formFactory.getFormAdaptor(vo).cancellationData(vo);
        }
        vo.setStartUserId(bpmBusinessProcess.getCreateUser());
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_STOP, ProcessOperationEnum.BUTTON_TYPE_DIS_AGREE, ProcessOperationEnum.BUTTON_TYPE_ABANDON});
        this.addSupportBusinessObjects(ProcessOperationEnum.getOutSideAccessmarker(), new Enum[]{ProcessOperationEnum.BUTTON_TYPE_STOP, ProcessOperationEnum.BUTTON_TYPE_DIS_AGREE, ProcessOperationEnum.BUTTON_TYPE_ABANDON});
    }
}

