/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ApprovalFormCodeEnum;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.OutSideBpmAccessBusiness;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.FormOperationAdaptor;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.service.AfUserService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnConfBizServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.DepartmentServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmAccessBusinessServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.OutSideBpmConditionsTemplateServiceImpl;
import org.openoa.engine.factory.FormFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OutSideAccessSubmitProcessImpl
implements ProcessOperationAdaptor {
    private static final Logger log = LoggerFactory.getLogger(OutSideAccessSubmitProcessImpl.class);
    @Autowired
    private BpmnConfBizServiceImpl bpmnConfCommonService;
    @Autowired
    protected BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    @Autowired
    private AfUserService employeeService;
    @Autowired
    private DepartmentServiceImpl departmentService;
    @Autowired
    private OutSideBpmAccessBusinessServiceImpl outSideBpmAccessBusinessService;
    @Autowired
    private OutSideBpmConditionsTemplateServiceImpl outSideBpmConditionsTemplateService;
    @Autowired
    private FormFactory formFactory;

    public void doProcessButton(BusinessDataVo businessDataVo) {
        OutSideBpmAccessBusiness outSideBpmAccessBusiness;
        String templateMark;
        String processNum = StringUtils.join((Object[])new String[]{businessDataVo.getFormCode(), "_", businessDataVo.getBusinessId()});
        if (!this.bpmBusinessProcessService.checkProcessData(processNum)) {
            throw new AFBizException("\u6d41\u7a0b\u5df2\u53d1\u8d77\uff01");
        }
        String originalBusinessId = businessDataVo.getBusinessId();
        BpmnStartConditionsVo bpmnStartConditionsVo = new BpmnStartConditionsVo();
        if (Objects.equals(businessDataVo.getIsLowCodeFlow(), 1)) {
            FormOperationAdaptor formAdapter = this.formFactory.getFormAdaptor(businessDataVo);
            bpmnStartConditionsVo = formAdapter.launchParameters(businessDataVo);
            formAdapter.submitData(businessDataVo);
        }
        if (!StringUtils.isEmpty((CharSequence)(templateMark = (outSideBpmAccessBusiness = (OutSideBpmAccessBusiness)this.outSideBpmAccessBusinessService.getById((Serializable)((Object)originalBusinessId))).getTemplateMark()))) {
            String[] templateMarkList = templateMark.split(",");
            List outSideBpmConditionsTemplate = this.outSideBpmConditionsTemplateService.list((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"is_del", (Object)0)).eq((Object)"business_party_id", (Object)outSideBpmAccessBusiness.getBusinessPartyId())).in((Object)"template_mark", new Object[]{outSideBpmAccessBusiness.getTemplateMark()}));
            if (outSideBpmConditionsTemplate == null) {
                throw new AFBizException("\u6761\u4ef6\u6a21\u677f[" + outSideBpmAccessBusiness.getTemplateMark() + "]\u5df2\u7ecf\u5931\u6548\uff0c\u65e0\u6cd5\u53d1\u8d77\u6d41\u7a0b");
            }
            List templateMarkIds = outSideBpmConditionsTemplate.stream().map(a -> a.getId().intValue()).collect(Collectors.toList());
            bpmnStartConditionsVo.setTemplateMarkIds(templateMarkIds);
        }
        bpmnStartConditionsVo.setOutSideType(businessDataVo.getOutSideType());
        bpmnStartConditionsVo.setBusinessId(businessDataVo.getBusinessId());
        bpmnStartConditionsVo.setStartUserId(businessDataVo.getStartUserId());
        bpmnStartConditionsVo.setApproversList(Optional.ofNullable(businessDataVo.getApproversList()).orElse(Maps.newHashMap()));
        bpmnStartConditionsVo.setProcessNum(processNum);
        bpmnStartConditionsVo.setEntryId(processNum);
        bpmnStartConditionsVo.setEmbedNodes(businessDataVo.getEmbedNodes());
        bpmnStartConditionsVo.setOutSideLevelNodes(businessDataVo.getOutSideLevelNodes());
        bpmnStartConditionsVo.setIsOutSideAccessProc(Boolean.valueOf(true));
        bpmnStartConditionsVo.setBusinessDataVo(businessDataVo);
        String processTitlePrefix = ApprovalFormCodeEnum.exist((String)businessDataVo.getFormCode()) ? Optional.ofNullable(this.employeeService.getById(bpmnStartConditionsVo.getApprovalEmplId())).orElse(new BaseIdTranStruVo()).getName() : businessDataVo.getSubmitUser();
        BpmBusinessProcess bpmBusinessProcess = BpmBusinessProcess.builder().businessId(businessDataVo.getBusinessId()).processinessKey(businessDataVo.getFormCode()).businessNumber(processNum).createUser(businessDataVo.getStartUserId()).userName(businessDataVo.getSubmitUser()).createTime(new Date()).processState(Integer.valueOf(ProcessStateEnum.HANDLING_STATE.getCode())).entryId(processNum).description(processTitlePrefix + "-" + businessDataVo.getBpmnName()).version(businessDataVo.getBpmnCode()).isOutSideProcess(Integer.valueOf(1)).isLowCodeFlow(businessDataVo.getIsLowCodeFlow()).build();
        this.bpmBusinessProcessService.addBusinessProcess(bpmBusinessProcess);
        businessDataVo.setProcessNumber(processNum);
        this.bpmnConfCommonService.startProcess(businessDataVo.getBpmnCode(), bpmnStartConditionsVo);
        this.outSideBpmAccessBusinessService.updateById(OutSideBpmAccessBusiness.builder().id(Long.valueOf(Long.parseLong(originalBusinessId))).processNumber(processNum).bpmnConfId(Optional.ofNullable(businessDataVo.getBpmnConfVo()).orElse(new BpmnConfVo()).getId()).build());
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(ProcessOperationEnum.getOutSideAccessmarker(), new Enum[]{ProcessOperationEnum.BUTTON_TYPE_SUBMIT});
    }
}

