/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.constant.enums.ProcessSubmitStateEnum;
import org.openoa.base.dto.NodeExtraInfoDTO;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmVerifyInfo;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.BpmBusinessProcessService;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmnNodeLabelVO;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.service.biz.BpmnConfBizServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnProcessMigrationServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessNodeSubmitBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableSignUpPersonnelBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVerifyInfoBizService;
import org.openoa.engine.factory.FormFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class ResubmitProcessImpl
implements ProcessOperationAdaptor {
    @Autowired
    private FormFactory formFactory;
    @Autowired
    private BpmBusinessProcessService bpmBusinessProcessService;
    @Autowired
    private BpmVerifyInfoBizService bpmVerifyInfoBizService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private BpmProcessNodeSubmitBizService processNodeSubmitBizService;
    @Autowired
    private BpmVariableSignUpPersonnelBizService bpmVariableSignUpPersonnelBizService;
    @Autowired
    private BpmnProcessMigrationServiceImpl bpmnProcessMigrationService;
    @Autowired
    private BpmnConfBizServiceImpl bpmnConfCommonService;

    public void doProcessButton(BusinessDataVo vo) {
        NodeExtraInfoDTO extraInfoDTO;
        List nodeLabelVOS;
        Task task;
        vo.setStartUserId(SecurityUtils.getLogInEmpIdStr());
        vo.setStartUserName(SecurityUtils.getLogInEmpName());
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(vo.getProcessNumber());
        vo.setBusinessId(bpmBusinessProcess.getBusinessId());
        List tasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(bpmBusinessProcess.getProcInstId())).list();
        if (ObjectUtils.isEmpty((Object)tasks)) {
            throw new AFBizException("\u5f53\u524d\u6d41\u7a0b\u5df2\u5ba1\u6279\uff01");
        }
        if (tasks.stream().noneMatch(a -> a.getAssignee().equals(SecurityUtils.getLogInEmpIdStr()))) {
            throw new AFBizException("\u5f53\u524d\u6d41\u7a0b\u5df2\u5ba1\u6279\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)vo.getTaskId())) {
            task = tasks.stream().filter(o -> o.getId().equals(vo.getTaskId())).findFirst().orElse(null);
        } else {
            task = (Task)tasks.get(0);
            if (StringUtils.isEmpty((CharSequence)task.getAssigneeName())) {
                task.setAssigneeName(SecurityUtils.getLogInEmpNameSafe());
            }
        }
        if (ObjectUtils.isEmpty((Object)task)) {
            throw new AFBizException("\u5f53\u524d\u6d41\u7a0b\u4ee3\u529e\u5df2\u5ba1\u6279\u6216\u4e0d\u5b58\u5728\uff01");
        }
        String formKey = task.getFormKey();
        if (!StringUtils.isEmpty((CharSequence)formKey) && !CollectionUtils.isEmpty((Collection)(nodeLabelVOS = (extraInfoDTO = (NodeExtraInfoDTO)JSON.parseObject((String)formKey, NodeExtraInfoDTO.class)).getNodeLabelVOS()))) {
            for (BpmnNodeLabelVO nodeLabelVO : nodeLabelVOS) {
                boolean conditionsChanged;
                if (!"af_syslabel_dynamiccondition".equals(nodeLabelVO.getLabelValue()) || tasks.size() != 1 || !(conditionsChanged = this.bpmnConfCommonService.migrationCheckConditionsChange(vo))) continue;
                this.bpmnProcessMigrationService.migrateAndJumpToCurrent(task, bpmBusinessProcess, vo, this::executeTaskCompletion);
                return;
            }
        }
        if (ObjectUtils.isEmpty((Object)task)) {
            throw new AFBizException("\u5f53\u524d\u6d41\u7a0b\u4ee3\u529e\u5df2\u5ba1\u6279\uff01");
        }
        this.executeTaskCompletion(vo, task, bpmBusinessProcess);
        vo.setStartUserId(bpmBusinessProcess.getCreateUser());
    }

    private void executeTaskCompletion(BusinessDataVo vo, Task task, BpmBusinessProcess bpmBusinessProcess) {
        vo.setTaskId(task.getId());
        BusinessDataVo businessDataVo = vo;
        if (!vo.getIsOutSideAccessProc().booleanValue()) {
            businessDataVo = this.formFactory.getFormAdaptor(vo).consentData(vo);
        }
        BpmVerifyInfo bpmVerifyInfo = BpmVerifyInfo.builder().verifyDate(new Date()).taskName(task.getName()).taskId(task.getId()).runInfoId(bpmBusinessProcess.getProcInstId()).verifyUserId(task.getAssignee()).verifyUserName(vo.getStartUserName()).taskDefKey(task.getTaskDefinitionKey()).verifyStatus(Integer.valueOf(ProcessSubmitStateEnum.PROCESS_AGRESS_TYPE.getCode())).verifyDesc(ObjectUtils.isEmpty((Object)vo.getApprovalComment()) ? "\u540c\u610f" : vo.getApprovalComment()).processCode(vo.getProcessNumber()).build();
        if (!ObjectUtils.isEmpty((Object)businessDataVo) && !ObjectUtils.isEmpty((Object)businessDataVo.getProcessDigest())) {
            this.bpmBusinessProcessService.update((Object)BpmBusinessProcess.builder().processDigest(businessDataVo.getProcessDigest()).build(), (Wrapper)new QueryWrapper().eq((Object)"BUSINESS_NUMBER", (Object)businessDataVo.getProcessNumber()));
        }
        if (vo.getOperationType().intValue() == ProcessOperationEnum.BUTTON_TYPE_JP.getCode().intValue()) {
            bpmVerifyInfo.setVerifyStatus(Integer.valueOf(ProcessSubmitStateEnum.PROCESS_SIGN_UP.getCode()));
            bpmVerifyInfo.setVerifyDesc(ObjectUtils.isEmpty((Object)vo.getApprovalComment()) ? "\u52a0\u6279" : vo.getApprovalComment());
        }
        if (!"currentUserAlreadyProcessed".equals(bpmVerifyInfo.getVerifyDesc())) {
            this.bpmVerifyInfoBizService.addVerifyInfo(bpmVerifyInfo);
        }
        if (!ObjectUtils.isEmpty((Object)vo.getOperationType()) && vo.getOperationType().intValue() == ProcessOperationEnum.BUTTON_TYPE_JP.getCode().intValue()) {
            this.bpmVariableSignUpPersonnelBizService.insertSignUpPersonnel(this.taskService, task.getId(), vo.getProcessNumber(), task.getTaskDefinitionKey(), task.getAssignee(), vo.getSignUpUsers());
        }
        this.processNodeSubmitBizService.processComplete(task);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_RESUBMIT, ProcessOperationEnum.BUTTON_TYPE_AGREE, ProcessOperationEnum.BUTTON_TYPE_JP});
        this.addSupportBusinessObjects(ProcessOperationEnum.getOutSideAccessmarker(), new Enum[]{ProcessOperationEnum.BUTTON_TYPE_RESUBMIT, ProcessOperationEnum.BUTTON_TYPE_AGREE, ProcessOperationEnum.BUTTON_TYPE_JP});
    }
}

