/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmProcessName;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.FormOperationAdaptor;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.util.MultiTenantUtil;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BpmnStartConditionsVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmnConfBizServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmProcessNameBizService;
import org.openoa.engine.factory.FormFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SubmitProcessImpl
implements ProcessOperationAdaptor {
    private static final Logger log = LoggerFactory.getLogger(SubmitProcessImpl.class);
    @Autowired
    private FormFactory formFactory;
    @Autowired
    private BpmnConfBizServiceImpl bpmnConfCommonService;
    @Autowired
    protected BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    @Autowired
    private BpmProcessNameBizService bpmProcessNameBizService;

    public void doProcessButton(BusinessDataVo businessDataVo) {
        log.info("Start submit process. param:{}", (Object)businessDataVo);
        FormOperationAdaptor formAdapter = this.formFactory.getFormAdaptor(businessDataVo);
        BusinessDataVo vo = businessDataVo;
        if (!Boolean.TRUE.equals(businessDataVo.getIsMigration())) {
            vo = formAdapter.submitData(businessDataVo);
        }
        BpmnStartConditionsVo bpmnStartConditionsVo = formAdapter.launchParameters(vo);
        bpmnStartConditionsVo.setBusinessDataVo(vo);
        bpmnStartConditionsVo.setApproversList(Optional.ofNullable(businessDataVo.getApproversList()).orElse(Maps.newHashMap()));
        String processNumber = businessDataVo.getFormCode() + "_" + vo.getBusinessId();
        if (Boolean.TRUE.equals(businessDataVo.getIsMigration())) {
            processNumber = businessDataVo.getProcessNumber();
        }
        if (StringUtils.isEmpty((CharSequence)vo.getProcessNumber())) {
            vo.setProcessNumber(processNumber);
        }
        bpmnStartConditionsVo.setProcessNum(processNumber);
        bpmnStartConditionsVo.setEntryId(vo.getEntityName() + ":" + vo.getBusinessId());
        bpmnStartConditionsVo.setBusinessId(vo.getBusinessId());
        if (Boolean.TRUE.equals(businessDataVo.getIsMigration())) {
            bpmnStartConditionsVo.setIsMigration(vo.getIsMigration());
        } else {
            String entryId = vo.getEntityName() + ":" + vo.getBusinessId();
            if (!this.bpmBusinessProcessService.checkProcessData(entryId)) {
                throw new AFBizException("the process has already been submitted\uff01");
            }
        }
        String processName = Optional.ofNullable(this.bpmProcessNameBizService.getBpmProcessName(businessDataVo.getFormCode())).orElse(new BpmProcessName()).getProcessName();
        String applyName = SecurityUtils.getLogInEmpName();
        if (!Boolean.TRUE.equals(businessDataVo.getIsMigration())) {
            this.bpmBusinessProcessService.addBusinessProcess(BpmBusinessProcess.builder().businessId(vo.getBusinessId()).processinessKey(businessDataVo.getFormCode()).businessNumber(processNumber).isLowCodeFlow(vo.getIsLowCodeFlow()).createUser(businessDataVo.getStartUserId()).userName(businessDataVo.getStartUserName()).createTime(new Date()).processDigest(vo.getProcessDigest()).processState(Integer.valueOf(ProcessStateEnum.HANDLING_STATE.getCode())).entryId(vo.getEntityName() + ":" + vo.getBusinessId()).description(applyName + "-" + processName).dataSourceId(vo.getDataSourceId()).version(businessDataVo.getBpmnCode()).tenantId(MultiTenantUtil.getCurrentTenantId()).build());
            businessDataVo.setProcessNumber(businessDataVo.getFormCode() + "_" + vo.getBusinessId());
        }
        this.bpmnConfCommonService.startProcess(businessDataVo.getBpmnCode(), bpmnStartConditionsVo);
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_SUBMIT});
    }
}

