/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskInfo;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmFlowrunEntrustServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TransferAssigneeProcessImpl
implements ProcessOperationAdaptor {
    @Autowired
    protected BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private BpmFlowrunEntrustServiceImpl bpmFlowrunEntrustService;

    public void doProcessButton(BusinessDataVo vo) {
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(vo.getProcessNumber());
        List list = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(bpmBusinessProcess.getProcInstId())).list();
        List userInfos = vo.getUserInfos();
        if (userInfos.size() != 2) {
            throw new AFBizException("\u8f6c\u529e\u4eba\u5458\u914d\u7f6e\u9519\u8bef,\u65e0\u6cd5\u8f6c\u529e!");
        }
        String originalUserId = ((BaseIdTranStruVo)userInfos.get(0)).getId();
        String originalUserName = ((BaseIdTranStruVo)userInfos.get(0)).getName();
        String transferToUserId = ((BaseIdTranStruVo)userInfos.get(1)).getId();
        String transferToUserName = ((BaseIdTranStruVo)userInfos.get(1)).getName();
        boolean matched = false;
        List assignees = list.stream().map(TaskInfo::getAssignee).collect(Collectors.toList());
        int originAssigneeIndex = assignees.indexOf(originalUserId);
        if (originAssigneeIndex < 0) {
            throw new AFBizException("\u6d41\u7a0b\u72b6\u6001\u5df2\u53d8\u66f4,\u65e0\u5f53\u524d\u529e\u7406\u4eba\u4fe1\u606f,\u8f6c\u529e\u5931\u8d25!");
        }
        for (Task task : list) {
            String assignee = task.getAssignee();
            if (!assignee.equals(originalUserId)) continue;
            this.bpmFlowrunEntrustService.addFlowrunEntrust(transferToUserId, transferToUserName, originalUserId, originalUserName, task.getId(), 0, bpmBusinessProcess.getProcInstId(), vo.getProcessKey());
            this.taskMgmtMapper.updateaActinst(TaskMgmtVO.builder().applyUser(transferToUserId).applyUserName(transferToUserName).taskId(task.getId()).build());
            this.taskMgmtMapper.updateaTaskinst(TaskMgmtVO.builder().applyUser(transferToUserId).applyUserName(transferToUserName).taskId(task.getId()).build());
            this.taskMgmtMapper.updateTask(TaskMgmtVO.builder().applyUser(transferToUserId).applyUserName(transferToUserName).taskId(task.getId()).build());
            matched = true;
        }
        if (!matched) {
            throw new AFBizException("\u6d41\u7a0b\u72b6\u6001\u5df2\u53d8\u66f4,\u65e0\u5f53\u524d\u529e\u7406\u4eba\u4fe1\u606f,\u8f6c\u529e\u5931\u8d25!");
        }
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_ZB});
        this.addSupportBusinessObjects(ProcessOperationEnum.getOutSideAccessmarker(), new Enum[]{ProcessOperationEnum.BUTTON_TYPE_ZB});
    }
}

