/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.adp.processoperation;

import java.util.List;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ProcessEnum;
import org.openoa.base.constant.enums.ProcessOperationEnum;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ProcessOperationAdaptor;
import org.openoa.base.vo.BusinessDataVo;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.common.service.BpmVariableMultiplayerPersonnelServiceImpl;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.impl.UserMessageServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.ObjectUtils;

@Component
public class UndertakeProcessImpl
implements ProcessOperationAdaptor {
    @Autowired
    private TaskService taskService;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    protected UserMessageServiceImpl userMessageService;
    @Autowired
    private BpmVariableMultiplayerPersonnelServiceImpl bpmVariableMultiplayerPersonnelService;

    public void doProcessButton(BusinessDataVo vo) {
        if (ObjectUtils.isEmpty((Object)vo.getTaskId())) {
            throw new AFBizException("\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u7b49\u4e8e\u7a7a\uff01");
        }
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(vo.getTaskId())).singleResult();
        if (ObjectUtils.isEmpty((Object)task)) {
            throw new AFBizException("\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u5df2\u7ecf\u88ab\u4eba\u627f\u529e\uff01");
        }
        List<TaskMgmtVO> list = this.taskMgmtMapper.getAgencyList(vo.getTaskId(), ProcessEnum.AGENCY_TYPE.getCode(), task.getProcessInstanceId());
        if (!ObjectUtils.isEmpty(list)) {
            for (TaskMgmtVO t : list) {
                this.userMessageService.readNode(task.getProcessInstanceId());
                Integer n = this.taskMgmtMapper.deletTask(t.getTaskId());
            }
        }
        this.bpmVariableMultiplayerPersonnelService.undertake(vo.getProcessNumber(), task.getTaskDefinitionKey());
    }

    public void setSupportBusinessObjects() {
        this.addSupportBusinessObjects(new Enum[]{ProcessOperationEnum.BUTTON_TYPE_UNDERTAKE});
        this.addSupportBusinessObjects(ProcessOperationEnum.getOutSideAccessmarker(), new Enum[]{ProcessOperationEnum.BUTTON_TYPE_UNDERTAKE});
    }
}

