/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.common;

import com.google.common.collect.Lists;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.empinfoprovider.BpmnEmployeeInfoProviderService;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableSignUpPersonnelServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ActivitiAdditionalInfoServiceImpl {
    @Autowired
    private RepositoryServiceImpl repositoryService;
    @Autowired
    private BpmnEmployeeInfoProviderService employeeInfoProvider;
    @Autowired
    private BpmVariableSignUpPersonnelServiceImpl bpmVariableSignUpPersonnelService;
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;

    public List<ActivityImpl> getActivitiList(String procDefId) {
        ProcessDefinitionEntity def = (ProcessDefinitionEntity)this.repositoryService.getDeployedProcessDefinition(procDefId);
        List activitiList = def.getActivities();
        return activitiList;
    }

    public PvmActivity getNextElement(String elementId, List<ActivityImpl> activitiList) {
        for (ActivityImpl activity : activitiList) {
            if (!elementId.equals(activity.getId())) continue;
            List outTransitions = activity.getOutgoingTransitions();
            Iterator iterator = outTransitions.iterator();
            if (!iterator.hasNext()) break;
            PvmTransition tr = (PvmTransition)iterator.next();
            PvmActivity ac = tr.getDestination();
            return ac;
        }
        return null;
    }

    public List<PvmActivity> getNextElementList(String elementId, List<ActivityImpl> activitiList) {
        Object[] elementIs = elementId.split(",");
        HashSet<PvmActivity> pvmActivityList = new HashSet<PvmActivity>();
        for (ActivityImpl activity : activitiList) {
            if (!ArrayUtils.contains((Object[])elementIs, (Object)activity.getId())) continue;
            List outTransitions = activity.getOutgoingTransitions();
            for (PvmTransition tr : outTransitions) {
                PvmActivity ac = tr.getDestination();
                pvmActivityList.add(ac);
            }
        }
        return Lists.newArrayList(pvmActivityList);
    }

    public PvmActivity getNextElement(String elementId, String procInstId) {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{elementId, procInstId})) {
            throw new AFBizException("\u83b7\u53d6\u6d41\u7a0b\u4e0b\u4e00\u8282\u70b9\u5931\u8d25,elementId\u6216procInstId\u503c\u4e3a\u7a7a!");
        }
        String procDefIdByInstId = this.taskMgmtMapper.findProcDefIdByInstId(procInstId);
        if (StringUtils.isBlank((CharSequence)procDefIdByInstId)) {
            throw new AFBizException("\u672a\u80fd\u6839\u636e\u6d41\u7a0b\u5b9e\u4f8bid\u67e5\u627e\u5230\u6d41\u7a0b\u5b9a\u4e49id,\u8bf7\u68c0\u67e5\u903b\u8f91!");
        }
        List<ActivityImpl> activitiList = this.getActivitiList(procDefIdByInstId);
        return this.getNextElement(elementId, activitiList);
    }

    public String getVerifyUserNameFromHis(String elementId, Long variableId) {
        String verifyUserName = "";
        List<BaseIdTranStruVo> assigneeMap = this.bpmVariableSignUpPersonnelService.getSignUpInfoByVariableAndElementId(variableId, elementId);
        if (!CollectionUtils.isEmpty(assigneeMap)) {
            verifyUserName = StringUtils.join((Iterable)assigneeMap.stream().map(BaseIdTranStruVo::getName).collect(Collectors.toList()), (char)',');
            return verifyUserName;
        }
        return verifyUserName;
    }
}

