/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.common;

import com.alibaba.fastjson2.JSON;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.TaskQuery;
import org.openoa.base.constant.enums.ButtonPageTypeEnum;
import org.openoa.base.constant.enums.ButtonTypeEnum;
import org.openoa.base.constant.enums.ConfigFlowButtonSortEnum;
import org.openoa.base.constant.enums.ProcessButtonEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmVariableButton;
import org.openoa.base.entity.BpmVariableSignUp;
import org.openoa.base.entity.BpmVariableViewPageButton;
import org.openoa.base.util.FilterUtil;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.ProcessActionButtonVo;
import org.openoa.common.constant.enus.ElementPropertyEnum;
import org.openoa.common.entity.BpmVariableMultiplayer;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableButtonServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableViewPageButtonServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableSignUpBizService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class ConfigFlowButtonContans {
    @Autowired
    private BpmBusinessProcessServiceImpl bpmBusinessProcessService;
    @Autowired
    private BpmVariableButtonServiceImpl bpmVariableButtonService;
    @Autowired
    private BpmVariableViewPageButtonServiceImpl bpmVariableViewPageButtonService;
    @Autowired
    private BpmVariableMultiplayerServiceImpl bpmVariableMultiplayerService;
    @Autowired
    private BpmVariableSignUpBizService bpmVariableSignUpBizService;
    @Autowired
    private TaskService taskService;

    public Map<String, List<ProcessActionButtonVo>> getButtons(String processNum, String elementId, Boolean isJurisdiction, Boolean isInitiate) {
        HashMap<String, List<ProcessActionButtonVo>> buttonMap = new HashMap<String, List<ProcessActionButtonVo>>();
        ArrayList<ProcessActionButtonVo> initiateButtons = new ArrayList();
        ArrayList<ProcessActionButtonVo> auditButtons = new ArrayList();
        List<Object> toViewButtons = new ArrayList();
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(processNum);
        if (bpmBusinessProcess == null || bpmBusinessProcess.getProcessState() == null || bpmBusinessProcess.getProcessState().intValue() == ProcessStateEnum.HANDLING_STATE.getCode()) {
            String procInstId;
            if (processNum != null && elementId != null) {
                List<BpmVariableButton> bpmVariableButtons = this.bpmVariableButtonService.getButtonsByProcessNumber(processNum, elementId);
                initiateButtons = this.getButtons(bpmVariableButtons, ButtonPageTypeEnum.INITIATE);
                auditButtons = this.getButtons(bpmVariableButtons, ButtonPageTypeEnum.AUDIT);
            }
            if (processNum != null) {
                List<BpmVariableViewPageButton> bpmVariableViewPageButtons = this.bpmVariableViewPageButtonService.getButtonsByProcessNumber(processNum);
                toViewButtons = this.toViewButtons(bpmVariableViewPageButtons, isInitiate);
            }
            if (isJurisdiction.booleanValue()) {
                ProcessActionButtonVo change = ProcessActionButtonVo.builder().buttonType(ButtonTypeEnum.BUTTON_TYPE_CHANGE_ASSIGNEE.getCode()).name(ButtonTypeEnum.BUTTON_TYPE_CHANGE_ASSIGNEE.getDesc()).show(Integer.valueOf(ProcessButtonEnum.DEAL_WITH_TYPE.getCode())).type(ProcessButtonEnum.DEFAULT_COLOR.getDesc()).build();
                ProcessActionButtonVo end = ProcessActionButtonVo.builder().buttonType(ButtonTypeEnum.BUTTON_TYPE_STOP.getCode()).name(ButtonTypeEnum.BUTTON_TYPE_STOP.getDesc()).show(Integer.valueOf(ProcessButtonEnum.DEAL_WITH_TYPE.getCode())).type(ProcessButtonEnum.DEFAULT_COLOR.getDesc()).build();
                toViewButtons.add(end);
                toViewButtons.add(change);
            }
            if (this.isMoreNode(processNum, procInstId = Optional.ofNullable(bpmBusinessProcess).map(BpmBusinessProcess::getProcInstId).orElse(""), elementId)) {
                ProcessActionButtonVo undertake = ProcessActionButtonVo.builder().buttonType(ButtonTypeEnum.BUTTON_TYPE_UNDERTAKE.getCode()).name(ButtonTypeEnum.BUTTON_TYPE_UNDERTAKE.getDesc()).show(Integer.valueOf(ProcessButtonEnum.DEAL_WITH_TYPE.getCode())).type(ProcessButtonEnum.DEFAULT_COLOR.getDesc()).build();
                auditButtons.clear();
                auditButtons.add(undertake);
            }
        } else if (bpmBusinessProcess.getProcessState().intValue() == ProcessStateEnum.HANDLED_STATE.getCode() || bpmBusinessProcess.getProcessState().intValue() == ProcessStateEnum.REJECT_STATE.getCode() || bpmBusinessProcess.getProcessState().intValue() == ProcessStateEnum.END_STATE.getCode()) {
            ArrayList<ProcessActionButtonVo> toViewButtonsComplete = new ArrayList<ProcessActionButtonVo>();
            if (processNum != null) {
                List<BpmVariableViewPageButton> bpmVariableViewPageButtons = this.bpmVariableViewPageButtonService.getButtonsByProcessNumber(processNum);
                toViewButtons = this.toViewButtons(bpmVariableViewPageButtons, isInitiate);
                for (ProcessActionButtonVo processActionButtonVo : toViewButtons) {
                    if (processActionButtonVo.getButtonType().equals(ButtonTypeEnum.BUTTON_TYPE_ABANDONED.getCode())) continue;
                    toViewButtonsComplete.add(processActionButtonVo);
                }
                initiateButtons.addAll(toViewButtonsComplete);
                auditButtons.addAll(toViewButtonsComplete);
                toViewButtons = toViewButtonsComplete;
            }
        }
        buttonMap.put(ButtonPageTypeEnum.INITIATE.getName(), this.buttonsSort(this.repeatFilter(initiateButtons)));
        buttonMap.put(ButtonPageTypeEnum.AUDIT.getName(), this.buttonsSort(this.repeatFilter(auditButtons)));
        buttonMap.put(ButtonPageTypeEnum.TO_VIEW.getName(), this.buttonsSort(this.repeatFilter(toViewButtons)));
        return buttonMap;
    }

    private List<ProcessActionButtonVo> toViewButtons(List<BpmVariableViewPageButton> btnVarList, Boolean isInitiate) {
        ArrayList<ProcessActionButtonVo> buttonlist = new ArrayList<ProcessActionButtonVo>();
        for (BpmVariableViewPageButton item : btnVarList) {
            if (isInitiate.booleanValue()) {
                if (item.getViewType() != 1) continue;
                buttonlist.add(ProcessActionButtonVo.builder().buttonType(item.getButtonType()).name(item.getButtonName()).show(Integer.valueOf(ProcessButtonEnum.VIEW_TYPE.getCode())).type(ProcessButtonEnum.DEFAULT_COLOR.getDesc()).build());
                continue;
            }
            if (item.getViewType() != 2) continue;
            buttonlist.add(ProcessActionButtonVo.builder().buttonType(item.getButtonType()).name(item.getButtonName()).show(Integer.valueOf(ProcessButtonEnum.VIEW_TYPE.getCode())).type(ProcessButtonEnum.DEFAULT_COLOR.getDesc()).build());
        }
        return buttonlist;
    }

    private List<ProcessActionButtonVo> getButtons(List<BpmVariableButton> bpmVariableButtons, ButtonPageTypeEnum buttonPageTypeEnum) {
        ArrayList<ProcessActionButtonVo> buttonlist = new ArrayList<ProcessActionButtonVo>();
        for (BpmVariableButton bpmVariableButton : bpmVariableButtons) {
            if (bpmVariableButton.getButtonPageType().intValue() != buttonPageTypeEnum.getCode()) continue;
            buttonlist.add(ProcessActionButtonVo.builder().buttonType(bpmVariableButton.getButtonType()).name(bpmVariableButton.getButtonName()).show(Integer.valueOf(ProcessButtonEnum.DEAL_WITH_TYPE.getCode())).type(ProcessButtonEnum.DEFAULT_COLOR.getDesc()).build());
        }
        return buttonlist;
    }

    public boolean isMoreNode(String processNum, String procInstId, String elementId) {
        List<BpmVariableSignUp> signUpList;
        List list = this.bpmVariableMultiplayerService.isMoreNode(processNum, elementId);
        if (list == null && !CollectionUtils.isEmpty(signUpList = this.bpmVariableSignUpBizService.getSignUpList(processNum))) {
            List subElementStrs = signUpList.stream().map(BpmVariableSignUp::getSubElements).collect(Collectors.toList());
            for (String subElementStr : subElementStrs) {
                BpmnConfCommonElementVo bpmnConfCommonElementVo;
                List bpmnConfCommonElementVos = JSON.parseArray((String)subElementStr, BpmnConfCommonElementVo.class);
                if (CollectionUtils.isEmpty((Collection)bpmnConfCommonElementVos) || !(bpmnConfCommonElementVo = (BpmnConfCommonElementVo)bpmnConfCommonElementVos.get(0)).getElementId().equals(elementId) || !ElementPropertyEnum.ELEMENT_PROPERTY_SIGN_UP_PARALLEL_OR.getCode().equals(bpmnConfCommonElementVo.getElementProperty())) continue;
                List tasks = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(procInstId)).taskDefinitionKey(elementId)).list();
                return tasks.size() > 1;
            }
        }
        return list != null && list.size() > 1 && ((BpmVariableMultiplayer)list.get(0)).getSignType() == 2;
    }

    private List<ProcessActionButtonVo> buttonsSort(List<ProcessActionButtonVo> buttons) {
        buttons.sort((o1, o2) -> {
            ConfigFlowButtonSortEnum sort1 = ConfigFlowButtonSortEnum.getEnumByCode((Integer)o1.getButtonType());
            ConfigFlowButtonSortEnum sort2 = ConfigFlowButtonSortEnum.getEnumByCode((Integer)o2.getButtonType());
            assert (sort1 != null);
            assert (sort2 != null);
            return sort1.getSort() - sort2.getSort();
        });
        return buttons;
    }

    public List<ProcessActionButtonVo> repeatFilter(List<ProcessActionButtonVo> initiateButtons) {
        if (ObjectUtils.isEmpty(initiateButtons)) {
            return Lists.newArrayList();
        }
        List<ProcessActionButtonVo> lists = initiateButtons.stream().filter(FilterUtil.distinctByKeys((Function[])new Function[]{ProcessActionButtonVo::getButtonType})).collect(Collectors.toList());
        return lists;
    }
}

