/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.google.common.collect.Lists;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.constant.enums.NodeTypeEnum;
import org.openoa.base.entity.BpmnNodeTo;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.engine.bpmnconf.adp.bpmnnodeadp.BpmnNodeAdaptor;
import org.openoa.engine.bpmnconf.constant.enus.BpmnNodeAdpConfEnum;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeToMapper;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeToServiceImpl;
import org.openoa.engine.factory.IAdaptorFactory;
import org.openoa.engine.utils.AFWrappers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class NodeAdditionalInfoServiceImpl {
    @Autowired
    private BpmnNodeToServiceImpl bpmnNodeToService;
    @Autowired
    private IAdaptorFactory adaptorFactory;

    public Map<Long, List<String>> getBpmnNodeToMap(List<Long> idList) {
        return ((BpmnNodeToMapper)this.bpmnNodeToService.getBaseMapper()).selectList((Wrapper)AFWrappers.lambdaTenantQuery().in(BpmnNodeTo::getBpmnNodeId, idList)).stream().collect(Collectors.toMap(BpmnNodeTo::getBpmnNodeId, v -> Lists.newArrayList(Collections.singletonList(v.getNodeTo())), (a, b) -> {
            a.addAll(b);
            return a;
        }));
    }

    public BpmnNodeAdaptor getBpmnNodeAdaptor(BpmnNodeAdpConfEnum bpmnNodeAdpConfEnum) {
        if (bpmnNodeAdpConfEnum == null) {
            return null;
        }
        return this.adaptorFactory.getBpmnNodeAdaptor(bpmnNodeAdpConfEnum);
    }

    public static BpmnNodeAdpConfEnum getBpmnNodeAdpConfEnum(BpmnNodeVo bpmnNodeVo) {
        BpmnNodeAdpConfEnum bpmnNodeAdpConfEnum;
        NodeTypeEnum nodeTypeEnumByCode = NodeTypeEnum.getNodeTypeEnumByCode((Integer)bpmnNodeVo.getNodeType());
        if (!ObjectUtils.isEmpty((Object)nodeTypeEnumByCode)) {
            if (NodeTypeEnum.NODE_TYPE_APPROVER.equals((Object)nodeTypeEnumByCode)) {
                NodePropertyEnum nodePropertyEnum = NodePropertyEnum.getNodePropertyEnumByCode((Integer)bpmnNodeVo.getNodeProperty());
                bpmnNodeAdpConfEnum = BpmnNodeAdpConfEnum.getBpmnNodeAdpConfEnumByEnum(nodePropertyEnum);
            } else {
                bpmnNodeAdpConfEnum = BpmnNodeAdpConfEnum.getBpmnNodeAdpConfEnumByEnum(nodeTypeEnumByCode);
            }
        } else {
            NodePropertyEnum nodePropertyEnum = NodePropertyEnum.getNodePropertyEnumByCode((Integer)bpmnNodeVo.getNodeProperty());
            bpmnNodeAdpConfEnum = BpmnNodeAdpConfEnum.getBpmnNodeAdpConfEnumByEnum(nodePropertyEnum);
        }
        return bpmnNodeAdpConfEnum;
    }
}

