/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.common;

import com.alibaba.fastjson2.JSON;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.ProcessJurisdictionEnum;
import org.openoa.base.constant.enums.ProcessNoticeEnum;
import org.openoa.base.constant.enums.ProcessStateEnum;
import org.openoa.base.entity.ActHiTaskinst;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmProcessForward;
import org.openoa.base.entity.BpmVariable;
import org.openoa.base.entity.BpmVariableSignUp;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.service.AfUserService;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseIdTranStruVo;
import org.openoa.base.vo.BpmnConfCommonElementVo;
import org.openoa.base.vo.LFFieldControlVO;
import org.openoa.base.vo.ProcessRecordInfoVo;
import org.openoa.common.entity.BpmVariableMultiplayer;
import org.openoa.common.service.BpmVariableMultiplayerServiceImpl;
import org.openoa.engine.bpmnconf.common.ProcessServiceFactory;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeLfFormdataFieldControlMapper;
import org.openoa.engine.bpmnconf.service.impl.ActHiTaskinstServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessForwardServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmVariableServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmnNodeLfFormdataFieldControlServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVariableSignUpBizService;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmVerifyInfoBizService;
import org.openoa.engine.vo.ProcessInforVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Component
public class ProcessBusinessContans
extends ProcessServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessBusinessContans.class);
    @Autowired
    private BpmProcessForwardServiceImpl processForwardService;
    @Autowired
    private ActHiTaskinstServiceImpl actHiTaskinstService;
    @Autowired
    private AfUserService employeeService;
    @Autowired
    private BpmnNodeLfFormdataFieldControlServiceImpl bpmnNodeLfFormdataFieldControlService;
    @Autowired
    private BpmVariableServiceImpl bpmnVariableService;
    @Autowired
    private BpmVariableMultiplayerServiceImpl bpmnVariableMultiplayerService;
    @Autowired
    private BpmVariableSignUpBizService bpmVariableSignUpBizService;
    @Autowired
    private BpmVerifyInfoBizService bpmVerifyInfoBizService;

    public ProcessRecordInfoVo processInfo(BpmBusinessProcess bpmBusinessProcess) {
        ActHiTaskinst actHiTaskinst;
        ProcessRecordInfoVo processInfoVo = new ProcessRecordInfoVo();
        if (bpmBusinessProcess == null) {
            return processInfoVo;
        }
        if (!this.showProcessData(bpmBusinessProcess.getBusinessNumber())) {
            throw new AFBizException("00", "current user has no access right\uff01");
        }
        processInfoVo.setTaskState(ProcessStateEnum.getDescByCode((Integer)bpmBusinessProcess.getProcessState()));
        processInfoVo.setVerifyInfoList(this.bpmVerifyInfoBizService.verifyInfoList(bpmBusinessProcess));
        processInfoVo.setProcessTitle(bpmBusinessProcess.getDescription());
        BaseIdTranStruVo employee = this.employeeService.getById(bpmBusinessProcess.getCreateUser());
        processInfoVo.setEmployee(employee);
        processInfoVo.setCreateTime(bpmBusinessProcess.getCreateTime());
        processInfoVo.setStartUserId(bpmBusinessProcess.getCreateUser());
        processInfoVo.setProcessNumber(bpmBusinessProcess.getBusinessNumber());
        String processInstanceId = bpmBusinessProcess.getBusinessId();
        this.processForwardService.updateProcessForward(BpmProcessForward.builder().processInstanceId(processInstanceId).forwardUserId(SecurityUtils.getLogInEmpIdStr()).build());
        this.userMessageService.readNode(processInstanceId);
        List list = ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(bpmBusinessProcess.getProcInstId())).taskAssignee(SecurityUtils.getLogInEmpId())).list();
        String taskDefKey = "";
        if (!ObjectUtils.isEmpty((Object)list)) {
            taskDefKey = ((Task)list.get(0)).getTaskDefinitionKey();
            processInfoVo.setTaskId(((Task)list.get(0)).getId());
            processInfoVo.setNodeId(taskDefKey);
        } else if (Objects.equals(bpmBusinessProcess.getIsLowCodeFlow(), 1) && (actHiTaskinst = this.actHiTaskinstService.queryLastHisRecord(bpmBusinessProcess.getProcInstId(), SecurityUtils.getLogInEmpId())) != null) {
            taskDefKey = actHiTaskinst.getTaskDefKey();
            processInfoVo.setNodeId(taskDefKey);
        }
        if (!StringUtils.isEmpty((CharSequence)taskDefKey) && Objects.equals(bpmBusinessProcess.getIsLowCodeFlow(), 1)) {
            Long variableId = Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.bpmnVariableService.lambdaQuery().eq(BpmVariable::getProcessNum, (Object)processInfoVo.getProcessNumber())).last(" limit 1")).one()).map(BpmVariable::getId).orElse(null);
            String elementId = processInfoVo.getNodeId();
            String nodeId = Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.bpmnVariableMultiplayerService.lambdaQuery().eq(BpmVariableMultiplayer::getElementId, (Object)elementId)).eq(BpmVariableMultiplayer::getVariableId, (Object)variableId)).last(" limit 1")).one()).map(BpmVariableMultiplayer::getNodeId).orElse(null);
            if (StringUtils.isBlank((CharSequence)nodeId)) {
                List<BpmVariableSignUp> signUpList = this.bpmVariableSignUpBizService.getSignUpList(bpmBusinessProcess.getBusinessNumber());
                BpmVariableSignUp signUpParent = null;
                if (!CollectionUtils.isEmpty(signUpList)) {
                    for (BpmVariableSignUp bpmVariableSignUp : signUpList) {
                        BpmnConfCommonElementVo bpmnConfCommonElementVo;
                        String subElements = bpmVariableSignUp.getSubElements();
                        List subElementVos = JSON.parseArray((String)subElements, BpmnConfCommonElementVo.class);
                        if (CollectionUtils.isEmpty((Collection)subElementVos) || !taskDefKey.equals((bpmnConfCommonElementVo = (BpmnConfCommonElementVo)subElementVos.get(0)).getElementId())) continue;
                        signUpParent = bpmVariableSignUp;
                        break;
                    }
                }
                if (signUpParent != null) {
                    elementId = signUpParent.getElementId();
                    nodeId = Optional.ofNullable(((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.bpmnVariableMultiplayerService.lambdaQuery().eq(BpmVariableMultiplayer::getElementId, (Object)elementId)).eq(BpmVariableMultiplayer::getVariableId, (Object)variableId)).last(" limit 1")).one()).map(BpmVariableMultiplayer::getNodeId).orElse(null);
                }
            }
            if (StringUtils.isNotBlank((CharSequence)nodeId)) {
                List<LFFieldControlVO> currentFieldControls = ((BpmnNodeLfFormdataFieldControlMapper)this.bpmnNodeLfFormdataFieldControlService.getBaseMapper()).getFieldControlByNodeId(Long.valueOf(nodeId));
                processInfoVo.setLfFieldControlVOs(currentFieldControls);
            }
        }
        return processInfoVo;
    }

    public void deleteProcessInstance(String processInstanceId) {
        this.runtimeService.deleteProcessInstance(processInstanceId, "process ending");
    }

    public boolean showProcessData(String processCode) {
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(processCode);
        if (!ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
            List<ActHiTaskinst> taskInstanceList = this.actHiTaskinstService.queryRecordsByProcInstId(bpmBusinessProcess.getProcInstId());
            List list = taskInstanceList.stream().filter(s -> !ObjectUtils.isEmpty((Object)s)).map(ActHiTaskinst::getAssignee).collect(Collectors.toList());
            if (list.contains(SecurityUtils.getLogInEmpIdStr())) {
                return true;
            }
            return true;
        }
        return true;
    }

    public String applyRoute(String processKey, String fromCode, boolean isOutSide) {
        String roure = "";
        try {
            String inParameter = URLEncoder.encode("{\"processKey\":\"" + processKey + "\",\"formCode\":\"" + fromCode + "\"}", "UTF-8");
            roure = "oaapp://oa.app/page?param={\"type\":\"H5\",\"pageName\":\"{\u7533\u8bf7\u7c7b\u578b}\",\"pageURL\":\"/{\u7533\u8bf7\u7c7b\u578b}/{\u8def\u7531}/{\u5de5\u4f5c\u6d41\u5165\u53c2}\"}";
            if (isOutSide) {
                fromCode = "OUTSIDE_WMA";
            }
            String routePath = "apply";
            roure = StringUtils.replaceEach((String)roure, (String[])new String[]{"{\u7533\u8bf7\u7c7b\u578b}", "{\u8def\u7531}", "{\u5de5\u4f5c\u6d41\u5165\u53c2}"}, (String[])new String[]{fromCode, routePath, inParameter});
            roure = URLEncoder.encode(roure, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return roure;
    }

    public String pcApplyRoute(String processKey, String formCode, String processNumber, Integer type, boolean isOutside) {
        if (isOutside) {
            return StringUtils.join((Object[])new String[]{"/user/workflow/detail/third-party/", formCode, "/", processNumber});
        }
        String pcUrl = type.equals(ProcessJurisdictionEnum.VIEW_TYPE.getCode()) ? "/user/workflow/detail/" + formCode + "/" + processKey + "/" + processNumber : (type.equals(ProcessJurisdictionEnum.CREATE_TYPE.getCode()) ? "/user/workflow/Upcoming/check/" + formCode + "/" + processKey + "/" + processNumber : "/user/workflow/Upcoming/apply/" + formCode + "/" + processKey + "/" + processNumber);
        return pcUrl;
    }

    public String getRoute(Integer type, ProcessInforVo inforVo, boolean isOutside) {
        String url = "";
        url = type.equals(ProcessNoticeEnum.EMAIL_TYPE.getCode()) ? this.pcApplyRoute(inforVo.getProcessinessKey(), inforVo.getFormCode(), inforVo.getBusinessNumber(), inforVo.getType(), isOutside) : this.detailRoute(inforVo.getFormCode(), inforVo.getBusinessNumber(), inforVo.getType(), isOutside);
        return url;
    }

    public String detailRoute(String formCode, String processNumber, Integer type, boolean isOutSide) {
        String detail = "";
        String appUrl = "";
        if (type.equals(ProcessJurisdictionEnum.CONTROL_TYPE.getCode())) {
            type = ProcessJurisdictionEnum.CREATE_TYPE.getCode();
            appUrl = "apply";
        } else {
            appUrl = "approval";
            if (!StringUtils.isEmpty((CharSequence)processNumber)) {
                BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessService.getBpmBusinessProcess(processNumber);
                appUrl = appUrl.concat("_");
                if (bpmBusinessProcess.getVersion() != null) {
                    appUrl = appUrl.concat(bpmBusinessProcess.getVersion().toString());
                }
            }
        }
        try {
            String inParameter = URLEncoder.encode("{\"formCode\":\"" + formCode + "\",\"processNumber\":\"" + processNumber + "\",\"type\":" + type + "}", "UTF-8");
            detail = "";
            if (isOutSide) {
                formCode = "OUTSIDE_WMA";
            }
            detail = StringUtils.replaceEach((String)detail, (String[])new String[]{"{\u7533\u8bf7\u7c7b\u578b}", "{\u8def\u7531}", "{\u5de5\u4f5c\u6d41\u5165\u53c2}"}, (String[])new String[]{formCode, appUrl, inParameter});
            detail = URLEncoder.encode(detail, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return detail;
    }

    public boolean checkAppVersionByCurrentUser() {
        return false;
    }
}

