/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.common;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.pvm.PvmActivity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.entity.ActHiTaskinst;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.common.ProcessServiceFactory;
import org.openoa.engine.bpmnconf.service.impl.ActHiTaskinstServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ProcessConstants
extends ProcessServiceFactory {
    private static final Logger log = LoggerFactory.getLogger(ProcessConstants.class);
    @Autowired
    private ActHiTaskinstServiceImpl actHiTaskinstService;

    public PvmActivity getNextNodePvmActivity(String procInstanceId) {
        List tasks = ((TaskQuery)this.processEngine.getTaskService().createTaskQuery().processInstanceId(procInstanceId)).list();
        String nextId = "";
        block0: for (Task task : tasks) {
            RepositoryService rs = this.processEngine.getRepositoryService();
            ProcessDefinitionEntity def = (ProcessDefinitionEntity)((RepositoryServiceImpl)rs).getDeployedProcessDefinition(task.getProcessDefinitionId());
            List activitiList = def.getActivities();
            String excId = task.getExecutionId();
            RuntimeService runtimeService = this.processEngine.getRuntimeService();
            ExecutionEntity execution = (ExecutionEntity)runtimeService.createExecutionQuery().executionId(excId).singleResult();
            String activitiId = execution.getActivityId();
            for (ActivityImpl activityImpl : activitiList) {
                String id = activityImpl.getId();
                if (!id.equals(activitiId)) continue;
                List outTransitions = activityImpl.getOutgoingTransitions();
                Iterator iterator = outTransitions.iterator();
                if (!iterator.hasNext()) continue block0;
                PvmTransition tr = (PvmTransition)iterator.next();
                PvmActivity ac = tr.getDestination();
                return ac;
            }
        }
        return null;
    }

    public String getMapValue(Map<String, Object> map, String key) {
        return Optional.ofNullable(map).map(o -> {
            if (o.containsKey(key)) {
                return Optional.ofNullable(o.get(key)).orElse("").toString();
            }
            return "";
        }).orElse("");
    }

    public String getTaskId(String businessId, String processCode) {
        BpmBusinessProcess bpmBusinessProcess = this.bpmBusinessProcessMapper.findBpmBusinessProcess(BpmBusinessProcess.builder().businessId(businessId).businessNumber(processCode).build());
        if (!ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
            TaskMgmtVO taskMgmtVO = this.taskMgmtService.findByTask(TaskMgmtVO.builder().businessId(businessId).code(processCode).build());
            if (!ObjectUtils.isEmpty((Object)taskMgmtVO)) {
                throw new AFBizException("00", "current task is finished\uff01\uff01\uff01");
            }
            return taskMgmtVO.getTaskId();
        }
        return null;
    }

    public List<Task> findTaskListByKey(String processInstanceId, String key) {
        return ((TaskQuery)((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).taskDefinitionKey(key)).list();
    }

    public ActHiTaskinst getPrevTask(String taskDefKey, String procInstId) {
        if (StringUtils.isEmpty((CharSequence)taskDefKey)) {
            return null;
        }
        if (StringUtils.isEmpty((CharSequence)procInstId)) {
            throw new AFBizException("taskId\u4e0d\u4e3a\u7a7a,\u6d41\u7a0b\u5b9e\u4f8bId\u4e0d\u5b58\u5728!");
        }
        List<ActHiTaskinst> list = this.actHiTaskinstService.queryRecordsByProcInstIdOrderByCreateTimeDesc(procInstId);
        ActHiTaskinst historicTaskInstance = list.stream().filter(a -> a.getEndTime() != null && !taskDefKey.equals(a.getTaskDefKey())).findFirst().orElse(null);
        return historicTaskInstance;
    }
}

