/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.common;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.BpmnConfFlagsEnum;
import org.openoa.base.constant.enums.ProcessNoticeEnum;
import org.openoa.base.entity.BpmBusinessProcess;
import org.openoa.base.entity.BpmProcessNotice;
import org.openoa.base.entity.BpmnConf;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.interf.ActivitiServiceAnno;
import org.openoa.base.interf.FormOperationAdaptor;
import org.openoa.base.util.SecurityUtils;
import org.openoa.base.vo.BaseNumIdStruVo;
import org.openoa.base.vo.BpmnConfVo;
import org.openoa.base.vo.DIYProcessInfoDTO;
import org.openoa.base.vo.TaskMgmtVO;
import org.openoa.engine.bpmnconf.mapper.BpmBusinessProcessMapper;
import org.openoa.engine.bpmnconf.mapper.TaskMgmtMapper;
import org.openoa.engine.bpmnconf.service.biz.BpmBusinessProcessServiceImpl;
import org.openoa.engine.bpmnconf.service.impl.BpmProcessNoticeServiceImpl;
import org.openoa.engine.bpmnconf.service.interf.biz.BpmnConfBizService;
import org.openoa.engine.bpmnconf.service.interf.repository.BpmnConfService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.ClassUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class TaskMgmtServiceImpl
extends ServiceImpl<TaskMgmtMapper, TaskMgmtVO> {
    private static final Logger log = LoggerFactory.getLogger(TaskMgmtServiceImpl.class);
    @Autowired
    private TaskMgmtMapper taskMgmtMapper;
    @Autowired
    private TaskService taskService;
    @Autowired
    private BpmBusinessProcessServiceImpl processService;
    @Autowired
    protected BpmBusinessProcessMapper bpmBusinessProcessMapper;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired(required=false)
    private Map<String, FormOperationAdaptor> formOperationAdaptorMap;
    @Autowired
    @Lazy
    private BpmnConfBizService bpmnConfBizService;
    @Autowired
    private BpmProcessNoticeServiceImpl bpmProcessNoticeService;

    public TaskMgmtVO findTask(String taskId) throws AFBizException {
        return this.taskMgmtMapper.findTask(taskId);
    }

    public TaskMgmtVO getAgencyList(String taskId) throws AFBizException {
        Task task = (Task)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        TaskMgmtVO mgmtVO = new TaskMgmtVO();
        if (!ObjectUtils.isEmpty((Object)task)) {
            mgmtVO.setTaskStype(Integer.valueOf(2));
        } else {
            mgmtVO.setTaskStype(Integer.valueOf(1));
        }
        return mgmtVO;
    }

    public void updateTask(TaskMgmtVO taskMgmtVO) {
        if (ObjectUtils.isEmpty((Object)taskMgmtVO.getTaskIds())) {
            throw new AFBizException("please select the task ids to modify \uff01\uff01");
        }
        if (!ObjectUtils.isEmpty((Object)taskMgmtVO.getTaskIds())) {
            taskMgmtVO.getTaskIds().forEach(o -> {
                this.taskMgmtMapper.updateaActinst(TaskMgmtVO.builder().applyUser(taskMgmtVO.getApplyUser()).applyUserName(taskMgmtVO.getApplyUserName()).taskId(o).build());
                this.taskMgmtMapper.updateaTaskinst(TaskMgmtVO.builder().applyUser(taskMgmtVO.getApplyUser()).applyUserName(taskMgmtVO.getApplyUserName()).taskId(o).build());
                this.taskMgmtMapper.updateTask(TaskMgmtVO.builder().applyUser(taskMgmtVO.getApplyUser()).applyUserName(taskMgmtVO.getApplyUserName()).taskId(o).build());
            });
        }
    }

    public TaskMgmtVO findByTask(TaskMgmtVO taskMgmtVO) {
        try {
            taskMgmtVO.setApplyUser(SecurityUtils.getLogInEmpIdSafe().toString());
            BpmBusinessProcess bpmBusinessProcess = this.processService.findBpmBusinessProcess(taskMgmtVO.getBusinessId(), taskMgmtVO.getCode());
            if (!ObjectUtils.isEmpty((Object)bpmBusinessProcess)) {
                taskMgmtVO.setEntryId(bpmBusinessProcess.getEntryId());
                TaskMgmtVO mgmtVO = this.taskMgmtMapper.findByTask(taskMgmtVO);
                return mgmtVO;
            }
            return null;
        }
        catch (Exception e) {
            throw new AFBizException("\u6839\u636e\u4e1a\u52a1ID:[" + taskMgmtVO.getBusinessId() + "]\u65e0\u6cd5\u67e5\u8be2\u4ee3\u529e\u6570\u636e");
        }
    }

    public void changeFutureAssignees(String executionId, String variableName, List<String> assignees) {
        HashMap<String, List<String>> assigneeMap = new HashMap<String, List<String>>();
        assigneeMap.put(variableName, assignees);
        this.runtimeService.setVariables(executionId, assigneeMap);
    }

    public List<DIYProcessInfoDTO> viewProcessInfo(String desc) {
        List<DIYProcessInfoDTO> diyProcessInfoDTOS = this.baseFormInfo(desc);
        if (CollectionUtils.isEmpty(diyProcessInfoDTOS)) {
            return diyProcessInfoDTOS;
        }
        List<String> formCodes = diyProcessInfoDTOS.stream().map(DIYProcessInfoDTO::getKey).collect(Collectors.toList());
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().select(new SFunction[]{BpmnConf::getFormCode, BpmnConf::getExtraFlags}).in(BpmnConf::getFormCode, formCodes)).eq(BpmnConf::getEffectiveStatus, (Object)1);
        List bpmnConfs = ((BpmnConfService)this.bpmnConfBizService.getService()).list((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)bpmnConfs)) {
            Map<String, Integer> formCode2Flags = bpmnConfs.stream().filter(a -> a.getExtraFlags() != null).collect(Collectors.toMap(BpmnConf::getFormCode, BpmnConf::getExtraFlags, (v1, v2) -> v1));
            Map<String, List<BpmProcessNotice>> processNoticeMap = this.bpmProcessNoticeService.processNoticeMap(formCodes);
            for (DIYProcessInfoDTO diyProcessInfoDTO : diyProcessInfoDTOS) {
                List<BpmProcessNotice> bpmProcessNotices;
                String formCode = diyProcessInfoDTO.getKey();
                Integer flags = formCode2Flags.get(formCode);
                if (flags != null) {
                    boolean hasStartUserChooseModules = BpmnConfFlagsEnum.hasFlag((Integer)flags, (BpmnConfFlagsEnum)BpmnConfFlagsEnum.HAS_STARTUSER_CHOOSE_MODULES);
                    diyProcessInfoDTO.setHasStarUserChooseModule(Boolean.valueOf(hasStartUserChooseModules));
                }
                if (!CollectionUtils.isEmpty(bpmProcessNotices = processNoticeMap.get(diyProcessInfoDTO.getKey()))) {
                    ArrayList<BaseNumIdStruVo> processNotices = new ArrayList<BaseNumIdStruVo>();
                    for (ProcessNoticeEnum value : ProcessNoticeEnum.values()) {
                        Integer type = value.getCode();
                        String descByCode = value.getDesc();
                        BaseNumIdStruVo struVo = new BaseNumIdStruVo();
                        struVo.setId(Long.valueOf(type.longValue()));
                        struVo.setName(descByCode);
                        for (BpmProcessNotice bpmProcessNotice : bpmProcessNotices) {
                            if (!Objects.equals(value.getCode(), bpmProcessNotice.getType())) continue;
                            struVo.setActive(Boolean.valueOf(true));
                        }
                        processNotices.add(struVo);
                    }
                    diyProcessInfoDTO.setProcessNotices(processNotices);
                }
                BpmnConfVo confVo = new BpmnConfVo();
                confVo.setFormCode(formCode);
                this.bpmnConfBizService.setBpmnTemplateVos(confVo);
                diyProcessInfoDTO.setTemplateVos(confVo.getTemplateVos());
            }
        }
        return diyProcessInfoDTOS;
    }

    private List<DIYProcessInfoDTO> baseFormInfo(String desc) {
        ArrayList<DIYProcessInfoDTO> results = new ArrayList<DIYProcessInfoDTO>();
        for (Map.Entry<String, FormOperationAdaptor> stringFormOperationAdaptorEntry : this.formOperationAdaptorMap.entrySet()) {
            String key = stringFormOperationAdaptorEntry.getKey();
            ActivitiServiceAnno annotation = ClassUtils.getUserClass((Object)stringFormOperationAdaptorEntry.getValue()).getAnnotation(ActivitiServiceAnno.class);
            if (StringUtils.isEmpty((CharSequence)annotation.desc())) continue;
            if (!StringUtils.isEmpty((CharSequence)desc)) {
                if (!annotation.desc().contains(desc)) continue;
                results.add(DIYProcessInfoDTO.builder().key(key).value(annotation.desc()).type("DIY").build());
                continue;
            }
            results.add(DIYProcessInfoDTO.builder().key(key).value(annotation.desc()).type("DIY").build());
        }
        return results;
    }
}

