/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.engine.bpmnconf.controller;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.constant.enums.NodePropertyEnum;
import org.openoa.base.dto.PageDto;
import org.openoa.base.entity.BpmnNode;
import org.openoa.base.entity.Result;
import org.openoa.base.entity.UserEntrust;
import org.openoa.base.exception.AFBizException;
import org.openoa.base.vo.BpmnNodeVo;
import org.openoa.base.vo.DIYProcessInfoDTO;
import org.openoa.base.vo.DataVo;
import org.openoa.base.vo.DetailRequestDto;
import org.openoa.base.vo.Entrust;
import org.openoa.base.vo.ResultAndPage;
import org.openoa.engine.bpmnconf.common.TaskMgmtServiceImpl;
import org.openoa.engine.bpmnconf.mapper.BpmnNodeMapper;
import org.openoa.engine.bpmnconf.service.impl.UserEntrustServiceImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bpmnBusiness"})
public class BpmnBusinessController {
    private static final Logger log = LoggerFactory.getLogger(BpmnBusinessController.class);
    @Autowired
    private TaskMgmtServiceImpl taskMgmtService;
    @Autowired
    private UserEntrustServiceImpl userEntrustService;
    @Autowired
    private BpmnNodeMapper bpmnNodeMapper;

    @GetMapping(value={"/getDIYFormCodeList"})
    public Result getDIYFormCodeList(String desc) {
        List<DIYProcessInfoDTO> diyProcessInfoDTOS = this.taskMgmtService.viewProcessInfo(desc);
        return Result.newSuccessResult(diyProcessInfoDTOS);
    }

    @PostMapping(value={"/entrustlist/{type}"})
    public ResultAndPage<Entrust> entrustlist(@RequestBody DetailRequestDto requestDto, @PathVariable(value="type") Integer type) {
        PageDto pageDto = requestDto.getPageDto();
        Entrust vo = new Entrust();
        return this.userEntrustService.getEntrustPageList(pageDto, vo, type);
    }

    @GetMapping(value={"/entrustDetail/{id}"})
    public Result entrustDetail(@PathVariable(value="id") Integer id) {
        UserEntrust detail = this.userEntrustService.getEntrustDetail(id);
        return Result.newSuccessResult((Object)detail);
    }

    @PostMapping(value={"/editEntrust"})
    public Result editEntrust(@RequestBody DataVo dataVo) {
        this.userEntrustService.updateEntrustList(dataVo);
        return Result.newSuccessResult((Object)"ok");
    }

    @GetMapping(value={"/getStartUserChooseModules"})
    public Result getStartUserChooseModules(String formCode) {
        if (StringUtils.isEmpty((CharSequence)formCode)) {
            throw new AFBizException("\u53c2\u6570formCode\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        List<BpmnNode> nodesByFormCodeAndProperty = this.bpmnNodeMapper.getNodesByFormCodeAndProperty(formCode, NodePropertyEnum.NODE_PROPERTY_CUSTOMIZE.getCode());
        List nodeVos = nodesByFormCodeAndProperty.stream().map(a -> {
            BpmnNodeVo bpmnNodeVo = new BpmnNodeVo();
            bpmnNodeVo.setId(a.getId());
            bpmnNodeVo.setNodeName(a.getNodeName());
            return bpmnNodeVo;
        }).collect(Collectors.toList());
        return Result.newSuccessResult(nodeVos);
    }
}

